/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.aop.PublisherAnnotationBeanPostProcessor;
import org.springframework.integration.config.EnablePublisher;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class PublisherRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Log LOGGER = LogFactory.getLog(PublisherRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition("org.springframework.integration.internalPublisherAnnotationBeanPostProcessor")) {
            throw new BeanDefinitionStoreException("Only one enable publisher definition (@EnablePublisher or <annotation-config>) can be declared in the application context.");
        }
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnablePublisher.class.getName());
        Object beanFactory = registry instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)registry : (registry instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)registry).getBeanFactory() : null);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(PublisherAnnotationBeanPostProcessor.class, () -> this.lambda$registerBeanDefinitions$0(annotationAttributes, (ConfigurableBeanFactory)beanFactory)).setRole(2);
        registry.registerBeanDefinition("org.springframework.integration.internalPublisherAnnotationBeanPostProcessor", (BeanDefinition)builder.getBeanDefinition());
    }

    private PublisherAnnotationBeanPostProcessor createPublisherAnnotationBeanPostProcessor(@Nullable Map<String, Object> annotationAttributes, @Nullable ConfigurableBeanFactory beanFactory) {
        String defaultChannel;
        PublisherAnnotationBeanPostProcessor postProcessor = new PublisherAnnotationBeanPostProcessor();
        String string = defaultChannel = annotationAttributes == null ? (String)AnnotationUtils.getDefaultValue(EnablePublisher.class) : (String)annotationAttributes.get("defaultChannel");
        if (StringUtils.hasText((String)defaultChannel)) {
            if (beanFactory != null) {
                defaultChannel = beanFactory.resolveEmbeddedValue(defaultChannel);
            }
            postProcessor.setDefaultChannelName(defaultChannel);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Setting '@Publisher' default-output-channel to '" + defaultChannel + "'."));
            }
        }
        if (annotationAttributes != null) {
            String proxyTargetClass = annotationAttributes.get("proxyTargetClass").toString();
            if (beanFactory != null) {
                proxyTargetClass = beanFactory.resolveEmbeddedValue(proxyTargetClass);
            }
            postProcessor.setProxyTargetClass(Boolean.parseBoolean(proxyTargetClass));
            String order = annotationAttributes.get("order").toString();
            if (beanFactory != null) {
                order = beanFactory.resolveEmbeddedValue(order);
            }
            if (StringUtils.hasText((String)order)) {
                postProcessor.setOrder(Integer.parseInt(order));
            }
        }
        return postProcessor;
    }

    private /* synthetic */ PublisherAnnotationBeanPostProcessor lambda$registerBeanDefinitions$0(Map annotationAttributes, ConfigurableBeanFactory beanFactory) {
        return this.createPublisherAnnotationBeanPostProcessor(annotationAttributes, beanFactory);
    }
}

