/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.common.signature;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Arrays;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.der.DERParser;
import org.apache.sshd.common.util.io.der.DERWriter;

public class LegacyDSASigner
extends Signature {
    public static final String LEGACY_SIGNATURE = "LegacySHA1withDSA";
    protected final MessageDigest md;
    protected final Factory<Random> randomFactory;
    protected BigInteger x;
    protected BigInteger y;
    protected DSAParams params;

    public LegacyDSASigner(Factory<Random> randomFactory) throws GeneralSecurityException {
        super(LEGACY_SIGNATURE);
        this.randomFactory = randomFactory;
        this.md = MessageDigest.getInstance("SHA-1");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String key, Object param) {
        throw new InvalidParameterException("No parameter accepted");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String key) {
        return null;
    }

    protected void initDSAParameters(DSAKey key) throws InvalidKeyException {
        this.params = key.getParams();
        if (this.params == null) {
            throw new InvalidKeyException("Missing DSA parameters in key");
        }
        this.md.reset();
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Not a DSA private key");
        }
        DSAPrivateKey prvKey = (DSAPrivateKey)key;
        this.initDSAParameters(prvKey);
        this.x = prvKey.getX();
        this.y = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] sEncoding;
            byte[] rEncoding;
            ValidateUtils.checkState((this.params != null ? 1 : 0) != 0, (String)"Missing DSA parameters");
            BigInteger q = this.params.getQ();
            BigInteger k = this.generateK(q);
            BigInteger r = this.generateR(this.params.getP(), q, this.params.getG(), k);
            try (DERWriter w = new DERWriter(24);){
                w.writeBigInteger(r);
                rEncoding = w.toByteArray();
            }
            BigInteger s = this.generateS(this.x, q, r, k);
            try (DERWriter w = new DERWriter(24);){
                w.writeBigInteger(s);
                sEncoding = w.toByteArray();
            }
            int length = rEncoding.length + sEncoding.length;
            try (DERWriter w = new DERWriter(1 + length + 4);){
                w.write(48);
                w.writeLength(length);
                w.write(rEncoding);
                w.write(sEncoding);
                byte[] byArray = w.toByteArray();
                return byArray;
            }
        }
        catch (IOException | RuntimeException e) {
            throw new SignatureException(e.getMessage(), e);
        }
    }

    protected BigInteger generateK(BigInteger q) {
        BigInteger posK;
        BigInteger k;
        Random random;
        if (this.appRandom == null) {
            ValidateUtils.checkState((this.randomFactory != null ? 1 : 0) != 0, (String)"No signing random factory provided");
            random = (Random)this.randomFactory.create();
        } else {
            random = null;
        }
        byte[] kValue = new byte[q.bitLength() / 8];
        do {
            if (random == null) {
                this.appRandom.nextBytes(kValue);
                continue;
            }
            random.fill(kValue);
        } while ((k = (posK = new BigInteger(1, kValue)).mod(q)).signum() <= 0 || k.compareTo(q) >= 0);
        return k;
    }

    protected BigInteger generateR(BigInteger p, BigInteger q, BigInteger g, BigInteger k) {
        BigInteger temp = g.modPow(k, p);
        return temp.mod(q);
    }

    protected BigInteger generateS(BigInteger x, BigInteger q, BigInteger r, BigInteger k) {
        byte[] s2 = this.md.digest();
        int nBytes = q.bitLength() / 8;
        if (nBytes < s2.length) {
            s2 = Arrays.copyOfRange(s2, 0, nBytes);
        }
        BigInteger z = new BigInteger(1, s2);
        BigInteger k1 = k.modInverse(q);
        BigInteger mul1 = x.multiply(r);
        BigInteger withZ = mul1.add(z);
        BigInteger mul2 = withZ.multiply(k1);
        return mul2.mod(q);
    }

    @Override
    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Not a DSA public key");
        }
        DSAPublicKey pubKey = (DSAPublicKey)key;
        this.initDSAParameters(pubKey);
        this.x = null;
        this.y = pubKey.getY();
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        return this.engineVerify(signature, 0, signature.length);
    }

    @Override
    protected boolean engineVerify(byte[] signature, int offset, int length) throws SignatureException {
        ValidateUtils.checkState((this.params != null ? 1 : 0) != 0, (String)"Missing DSA parameters");
        try {
            BigInteger q;
            BigInteger s;
            BigInteger r;
            try (DERParser parser = new DERParser(signature, offset, length);){
                int type = parser.read();
                if (type != 48) {
                    throw new SignatureException("Invalid signature format - not a DER SEQUENCE: 0x" + Integer.toHexString(type));
                }
                int remainLen = parser.readLength();
                if (remainLen < 6) {
                    throw new SignatureException("Invalid signature format - not enough encoded data length: " + remainLen);
                }
                r = parser.readBigInteger();
                s = parser.readBigInteger();
            }
            catch (IOException e) {
                throw new SignatureException("Failed to parse DSA DER data", e);
            }
            if (r.signum() < 0) {
                r = new BigInteger(1, r.toByteArray());
            }
            if (s.signum() < 0) {
                s = new BigInteger(1, s.toByteArray());
            }
            if (r.compareTo(q = this.params.getQ()) != -1 || s.compareTo(q) != -1) {
                throw new IndexOutOfBoundsException("Out of range values in signature");
            }
            BigInteger p = this.params.getP();
            BigInteger g = this.params.getG();
            BigInteger w = this.generateW(p, q, g, s);
            BigInteger v = this.generateV(this.y, p, q, g, w, r);
            return v.equals(r);
        }
        catch (RuntimeException e) {
            throw new SignatureException(e.getMessage(), e);
        }
    }

    protected BigInteger generateW(BigInteger p, BigInteger q, BigInteger g, BigInteger s) {
        return s.modInverse(q);
    }

    protected BigInteger generateV(BigInteger y, BigInteger p, BigInteger q, BigInteger g, BigInteger w, BigInteger r) {
        byte[] s2 = this.md.digest();
        int nBytes = q.bitLength() / 8;
        if (nBytes < s2.length) {
            s2 = Arrays.copyOfRange(s2, 0, nBytes);
        }
        BigInteger z = new BigInteger(1, s2);
        BigInteger u1 = z.multiply(w).mod(q);
        BigInteger mul = r.multiply(w);
        BigInteger u2 = mul.mod(q);
        BigInteger t1 = g.modPow(u1, p);
        BigInteger t2 = y.modPow(u2, p);
        BigInteger t3 = t1.multiply(t2);
        BigInteger t5 = t3.mod(p);
        return t5.mod(q);
    }

    @Override
    protected void engineUpdate(byte b) {
        this.md.update(b);
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        this.md.update(data, off, len);
    }

    @Override
    protected void engineUpdate(ByteBuffer b) {
        this.md.update(b);
    }
}

