/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.common.session.helpers;

import java.io.IOException;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.exception.SshChannelNotFoundException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.DefaultUnknownChannelReferenceHandler;
import org.apache.sshd.common.util.buffer.Buffer;

public class ChannelIdTrackingUnknownChannelReferenceHandler
extends DefaultUnknownChannelReferenceHandler
implements ChannelListener {
    public static final AttributeRepository.AttributeKey<Integer> LAST_CHANNEL_ID_KEY = new AttributeRepository.AttributeKey();
    public static final ChannelIdTrackingUnknownChannelReferenceHandler TRACKER = new ChannelIdTrackingUnknownChannelReferenceHandler();

    public void channelInitialized(Channel channel) {
        int channelId = channel.getId();
        Session session = channel.getSession();
        Integer lastTracked = (Integer)session.setAttribute(LAST_CHANNEL_ID_KEY, (Object)channelId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("channelInitialized({}) updated last tracked channel ID {} => {}", new Object[]{channel, lastTracked, channelId});
        }
    }

    public Channel handleUnknownChannelCommand(ConnectionService service, byte cmd, int channelId, Buffer buffer) throws IOException {
        Session session = service.getSession();
        Integer lastTracked = (Integer)session.getAttribute(LAST_CHANNEL_ID_KEY);
        if (lastTracked != null && channelId <= lastTracked) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleUnknownChannelCommand({}) apply default handling for {} on channel={} (lastTracked={})", new Object[]{session, SshConstants.getCommandMessageName((int)cmd), channelId, lastTracked});
            }
            return super.handleUnknownChannelCommand(service, cmd, channelId, buffer);
        }
        throw new SshChannelNotFoundException(channelId, "Received " + SshConstants.getCommandMessageName((int)cmd) + " on unassigned channel " + channelId + " (last assigned=" + lastTracked + ")");
    }
}

