/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.channels.Channel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.sshd.cli.CliLogger;
import org.apache.sshd.cli.client.SftpCommandExecutor;
import org.apache.sshd.cli.client.SshClientCliSupport;
import org.apache.sshd.cli.client.helper.SftpFileTransferProgressOutputStream;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.mac.MacFactory;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.config.SshServerConfigFileReader;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpClientHolder;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHStatExtensionInfo;
import org.apache.sshd.sftp.client.extensions.openssh.OpenSSHStatPathExtension;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.common.SftpException;
import org.apache.sshd.sftp.common.extensions.ParserUtils;
import org.slf4j.Logger;

public class SftpCommandMain
extends SshClientCliSupport
implements SftpClientHolder,
Channel {
    public static final String SFTP_PORT_OPTION = "-P";
    private final SftpClient client;
    private final Map<String, SftpCommandExecutor> commandsMap;
    private String cwdRemote;
    private String cwdLocal;
    private boolean showProgress = true;

    public SftpCommandMain(SftpClient client) {
        this.client = Objects.requireNonNull(client, "No client");
        TreeMap<String, SftpCommandExecutor> map = new TreeMap<String, SftpCommandExecutor>(String.CASE_INSENSITIVE_ORDER);
        for (SftpCommandExecutor e : Arrays.asList(new ExitCommandExecutor(), new PwdCommandExecutor(), new InfoCommandExecutor(), new SessionCommandExecutor(), new KexCommandExecutor(), new ClientCommandExecutor(), new VersionCommandExecutor(), new CdCommandExecutor(), new LcdCommandExecutor(), new MkdirCommandExecutor(), new LsCommandExecutor(), new LlsCommandExecutor(), new LStatCommandExecutor(), new ReadLinkCommandExecutor(), new RmCommandExecutor(), new RmdirCommandExecutor(), new RenameCommandExecutor(), new StatVfsCommandExecutor(), new GetCommandExecutor(), new PutCommandExecutor(), new ProgressCommandExecutor(), new HelpCommandExecutor())) {
            String name = e.getName();
            ValidateUtils.checkTrue((map.put(name, e) == null ? 1 : 0) != 0, (String)"Multiple commands named '%s'", (Object)name);
        }
        this.commandsMap = Collections.unmodifiableMap(map);
        this.cwdLocal = System.getProperty("user.dir");
    }

    public final SftpClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInteractive(BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
        SftpClient sftp = this.getClient();
        this.setCurrentRemoteDirectory(sftp.canonicalPath("."));
        while (true) {
            String args;
            String cmd;
            stdout.append(this.getCurrentRemoteDirectory()).append(" > ").flush();
            String line = stdin.readLine();
            if (line == null) break;
            if (GenericUtils.isEmpty((CharSequence)(line = GenericUtils.replaceWhitespaceAndTrim((String)line)))) continue;
            int pos = line.indexOf(32);
            if (pos > 0) {
                cmd = line.substring(0, pos);
                args = line.substring(pos + 1).trim();
            } else {
                cmd = line;
                args = "";
            }
            SftpCommandExecutor exec = this.commandsMap.get(cmd);
            try {
                if (exec == null) {
                    stderr.append("Unknown command: ").println(line);
                    continue;
                }
                try {
                    if (!exec.executeCommand(args, stdin, stdout, stderr)) continue;
                }
                catch (Exception e) {
                    stderr.append(e.getClass().getSimpleName()).append(": ").println(e.getMessage());
                    continue;
                }
                finally {
                    stdout.flush();
                    continue;
                }
            }
            finally {
                stderr.flush();
                continue;
            }
            break;
        }
    }

    protected String resolveLocalPath(String pathArg) {
        String cwd = this.getCurrentLocalDirectory();
        if (GenericUtils.isEmpty((CharSequence)pathArg)) {
            return cwd;
        }
        if (OsUtils.isWin32() ? pathArg.length() >= 2 && pathArg.charAt(1) == ':' : pathArg.charAt(0) == '/') {
            return pathArg;
        }
        return cwd + File.separator + pathArg.replace('/', File.separatorChar);
    }

    protected String resolveRemotePath(String pathArg) {
        String cwd = this.getCurrentRemoteDirectory();
        if (GenericUtils.isEmpty((CharSequence)pathArg)) {
            return cwd;
        }
        if (pathArg.charAt(0) == '/') {
            return pathArg;
        }
        return cwd + "/" + pathArg;
    }

    protected <A extends Appendable> A appendFileAttributes(A stdout, SftpClient sftp, String path, SftpClient.Attributes attrs) throws IOException {
        stdout.append("    ").append(Long.toString(attrs.getSize())).append("    ").append(SftpFileSystemProvider.getRWXPermissions((int)attrs.getPermissions()));
        if (attrs.isSymbolicLink()) {
            String linkValue = sftp.readLink(path);
            stdout.append(" => ").append('(').append(attrs.isDirectory() ? "dir" : "file").append(')').append(' ').append(linkValue);
        }
        return stdout;
    }

    public String getCurrentRemoteDirectory() {
        return this.cwdRemote;
    }

    public void setCurrentRemoteDirectory(String path) {
        this.cwdRemote = path;
    }

    public String getCurrentLocalDirectory() {
        return this.cwdLocal;
    }

    public void setCurrentLocalDirectory(String path) {
        this.cwdLocal = path;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    @Override
    public boolean isOpen() {
        return this.client.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.client.close();
        }
    }

    public static <A extends Appendable> A appendInfoValue(A sb, CharSequence name, Object value) throws IOException {
        sb.append("    ").append(name).append(": ").append(Objects.toString(value));
        return sb;
    }

    public static SftpClientFactory resolveSftpClientFactory(ClientSession session) {
        ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(SftpClientFactory.class);
        String factoryName = session.getString(SftpClientFactory.class.getSimpleName());
        if (GenericUtils.isNotEmpty((CharSequence)factoryName)) {
            try {
                Class<?> clazz = cl.loadClass(factoryName);
                return (SftpClientFactory)ReflectionUtils.newInstance(clazz, SftpClientFactory.class);
            }
            catch (Throwable t) {
                System.err.append("Failed (").append(t.getClass().getSimpleName()).append(')').append(" to instantiate ").append(factoryName).append(": ").println(t.getMessage());
                System.err.flush();
                throw ExceptionUtils.toRuntimeException((Throwable)t, (boolean)true);
            }
        }
        ServiceLoader<SftpClientFactory> loader = ServiceLoader.load(SftpClientFactory.class, cl);
        SftpClientFactory factory = null;
        for (SftpClientFactory f : loader) {
            ValidateUtils.checkState((factory == null ? 1 : 0) != 0, (String)"Multiple factories detected - select one");
            factory = f;
        }
        if (factory != null) {
            return factory;
        }
        return SftpClientFactory.instance();
    }

    public static SftpVersionSelector.NamedVersionSelector resolveVersionSelector(ClientSession session) {
        String selector = session.getString(SshServerConfigFileReader.SFTP_FORCED_VERSION_PROP.getName());
        return SftpVersionSelector.resolveVersionSelector((String)selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        OutputStream logStream = stderr;
        try (BufferedReader stdin = new BufferedReader(new InputStreamReader((InputStream)new NoCloseInputStream(System.in)));){
            ClientSession session;
            Level level = CliLogger.resolveLoggingVerbosity(args);
            logStream = SftpCommandMain.resolveLoggingTargetStream(stdout, stderr, args);
            if (logStream != null) {
                SftpCommandMain.setupLogging(level, stdout, stderr, logStream);
            }
            ClientSession clientSession = session = logStream == null ? null : SftpCommandMain.setupClientSession(SFTP_PORT_OPTION, stdin, level, stdout, stderr, args);
            if (session == null) {
                System.err.println("usage: sftp [-v[v][v]] [-E logoutput] [-i identity] [-io nio2|mina|netty] [-J proxyJump] [-l login] [-P port] [-o option=value] [-w password] [-c cipherlist] [-m maclist] [-C] hostname/user@host");
                System.exit(-1);
                return;
            }
            try {
                Logger logger;
                SftpClientFactory clientFactory = SftpCommandMain.resolveSftpClientFactory(session);
                Logger logger2 = logStream != null ? CliLogger.getLogger(SftpCommandMain.class, level, logStream instanceof PrintStream ? (PrintStream)logStream : new PrintStream(logStream)) : (logger = CliLogger.resolveSystemLogger(SftpCommandMain.class, level));
                if (logger.isInfoEnabled()) {
                    logger.info("Using factory={}", (Object)clientFactory.getClass().getSimpleName());
                }
                SftpVersionSelector.NamedVersionSelector versionSelector = SftpCommandMain.resolveVersionSelector(session);
                if (logger.isInfoEnabled()) {
                    logger.info("Using version selector={}", (Object)versionSelector);
                }
                try (SftpClient sftpClient = clientFactory.createSftpClient(session, (SftpVersionSelector)versionSelector);
                     SftpCommandMain sftp = new SftpCommandMain(sftpClient);){
                    sftp.doInteractive(stdin, stdout, stderr);
                }
            }
            finally {
                session.close();
            }
        }
        finally {
            if (logStream != stdout && logStream != stderr) {
                logStream.close();
            }
        }
    }

    private class ProgressCommandExecutor
    implements SftpCommandExecutor {
        ProgressCommandExecutor() {
        }

        public String getName() {
            return "progress";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            int numArgs = GenericUtils.length((Object[])comps);
            if (numArgs <= 0) {
                stdout.append("    ").append(this.getName()).append(' ').println(SftpCommandMain.this.isShowProgress() ? "on" : "off");
            } else {
                ValidateUtils.checkTrue((numArgs == 1 ? 1 : 0) != 0, (String)"Invalid arguments count: %d", (long)numArgs);
                Object argVal = comps[0];
                if ("on".equalsIgnoreCase((String)argVal)) {
                    SftpCommandMain.this.setShowProgress(true);
                } else if ("off".equalsIgnoreCase((String)argVal)) {
                    SftpCommandMain.this.setShowProgress(false);
                } else {
                    throw new IllegalArgumentException("Unknown value: " + (String)argVal);
                }
            }
            return false;
        }
    }

    private class PutCommandExecutor
    extends TransferCommandExecutor {
        PutCommandExecutor() {
        }

        public String getName() {
            return "put";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            this.executeCommand(args, true, stdout);
            return false;
        }
    }

    private class GetCommandExecutor
    extends TransferCommandExecutor {
        GetCommandExecutor() {
        }

        public String getName() {
            return "get";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            this.executeCommand(args, false, stdout);
            return false;
        }
    }

    private abstract class TransferCommandExecutor
    implements SftpCommandExecutor {
        protected TransferCommandExecutor() {
        }

        protected void createDirectories(SftpClient sftp, String remotePath, PrintStream stdout, boolean verbose) throws IOException {
            try {
                SftpClient.Attributes attrs = sftp.stat(remotePath);
                ValidateUtils.checkTrue((boolean)attrs.isDirectory(), (String)"Remote path already exists but is not a directory: %s", (Object)remotePath);
                return;
            }
            catch (SftpException e) {
                int status = e.getStatus();
                ValidateUtils.checkTrue((status == 2 ? 1 : 0) != 0, (String)"Failed to get status of %s: %s", (Object[])new Object[]{remotePath, e.getMessage()});
                int pos = remotePath.lastIndexOf(47);
                ValidateUtils.checkTrue((pos > 0 ? 1 : 0) != 0, (String)"No more parents for %s", (Object)remotePath);
                this.createDirectories(sftp, remotePath.substring(0, pos), stdout, verbose);
                return;
            }
        }

        protected void transferFile(SftpClient sftp, Path localPath, String remotePath, boolean upload, PrintStream stdout, boolean verbose) throws IOException {
            long copySize;
            if (upload) {
                int pos = remotePath.lastIndexOf(47);
                ValidateUtils.checkTrue((pos > 0 ? 1 : 0) != 0, (String)"Missing full remote file path: %s", (Object)remotePath);
                this.createDirectories(sftp, remotePath.substring(0, pos), stdout, verbose);
                if (verbose) {
                    stdout.append("    Uploading ").append(Long.toString(Files.size(localPath))).append(" bytes from ").append(localPath.toString()).append(" to ").println(remotePath);
                }
            } else {
                Files.createDirectories(localPath.getParent(), new FileAttribute[0]);
                if (verbose) {
                    SftpClient.Attributes attrs = sftp.stat(remotePath);
                    stdout.append("    Downloading ").append(Long.toString(attrs.getSize())).append(" bytes from ").append(remotePath).append(" to ").println(localPath);
                }
            }
            boolean withProgress = SftpCommandMain.this.isShowProgress();
            long startTime = System.currentTimeMillis();
            try (InputStream input = upload ? Files.newInputStream(localPath, new OpenOption[0]) : sftp.read(remotePath);
                 OutputStream target = upload ? sftp.write(remotePath) : Files.newOutputStream(localPath, new OpenOption[0]);
                 OutputStream output = withProgress ? new SftpFileTransferProgressOutputStream(target, stdout) : target;){
                if (withProgress) {
                    stdout.println();
                }
                copySize = IoUtils.copy((InputStream)input, (OutputStream)output, (int)32768);
                if (withProgress) {
                    stdout.println();
                }
            }
            if (verbose) {
                stdout.append("    Copied ").append(Long.toString(copySize)).append(" bytes").append(" in ").append(Long.toString(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime))).append(" seconds from ").append(upload ? localPath.toString() : remotePath).append(" to ").println(upload ? remotePath : localPath.toString());
            }
        }

        protected void transferRemoteDir(SftpClient sftp, Path localPath, String remotePath, SftpClient.Attributes attrs, PrintStream stdout, boolean verbose) throws IOException {
            if (attrs.isDirectory()) {
                for (SftpClient.DirEntry entry : sftp.readDir(remotePath)) {
                    String name = entry.getFilename();
                    if (".".equals(name) || "..".equals(name)) continue;
                    this.transferRemoteDir(sftp, localPath.resolve(name), remotePath + "/" + name, entry.getAttributes(), stdout, verbose);
                }
            } else if (attrs.isRegularFile()) {
                this.transferFile(sftp, localPath, remotePath, false, stdout, verbose);
            } else if (verbose) {
                stdout.append("    ").append("Skip remote special file ").println(remotePath);
            }
        }

        protected void transferLocalDir(SftpClient sftp, Path localPath, String remotePath, PrintStream stdout, boolean verbose) throws IOException {
            if (Files.isDirectory(localPath, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(localPath);){
                    for (Path entry : ds) {
                        Path fileName = entry.getFileName();
                        String name = fileName.toString();
                        this.transferLocalDir(sftp, localPath.resolve(name), remotePath + "/" + name, stdout, verbose);
                    }
                }
            } else if (Files.isRegularFile(localPath, new LinkOption[0])) {
                this.transferFile(sftp, localPath, remotePath, true, stdout, verbose);
            } else if (verbose) {
                stdout.append("    ").append("Skip local special file ").println(localPath);
            }
        }

        protected void executeCommand(String args, boolean upload, PrintStream stdout) throws IOException {
            Object remotePath;
            Object localPath;
            Object tgt;
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            int numArgs = GenericUtils.length((Object[])comps);
            ValidateUtils.checkTrue((numArgs >= 1 && numArgs <= 3 ? 1 : 0) != 0, (String)"Invalid number of arguments: %s", (Object)args);
            Object src = comps[0];
            boolean recursive = false;
            boolean verbose = false;
            int tgtIndex = 1;
            if (((String)src).charAt(0) == '-') {
                ValidateUtils.checkTrue((((String)src).length() > 1 ? 1 : 0) != 0, (String)"Missing flags specification: %s", (Object)args);
                ValidateUtils.checkTrue((numArgs >= 2 ? 1 : 0) != 0, (String)"Missing source specification: %s", (Object)args);
                block4: for (int index = 1; index < ((String)src).length(); ++index) {
                    char ch = ((String)src).charAt(index);
                    switch (ch) {
                        case 'r': {
                            recursive = true;
                            continue block4;
                        }
                        case 'v': {
                            verbose = true;
                            continue block4;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown flag (" + Character.toString(ch) + ")");
                        }
                    }
                }
                src = comps[1];
                ++tgtIndex;
            }
            Object object = tgt = tgtIndex < numArgs ? comps[tgtIndex] : null;
            if (upload) {
                localPath = src;
                remotePath = GenericUtils.isEmpty((CharSequence)tgt) ? src : tgt;
            } else {
                localPath = GenericUtils.isEmpty((CharSequence)tgt) ? SftpCommandMain.this.getCurrentLocalDirectory() : tgt;
                remotePath = src;
            }
            SftpClient sftp = SftpCommandMain.this.getClient();
            Path local = Paths.get(SftpCommandMain.this.resolveLocalPath((String)localPath), new String[0]).normalize().toAbsolutePath();
            String remote = SftpCommandMain.this.resolveRemotePath((String)remotePath);
            if (recursive) {
                if (upload) {
                    ValidateUtils.checkTrue((boolean)Files.isDirectory(local, new LinkOption[0]), (String)"Local path not a directory or does not exist: %s", (Object)local);
                    this.transferLocalDir(sftp, local, remote, stdout, verbose);
                } else {
                    SftpClient.Attributes attrs = sftp.stat(remote);
                    ValidateUtils.checkTrue((boolean)attrs.isDirectory(), (String)"Remote path not a directory: %s", (Object)remote);
                    this.transferRemoteDir(sftp, local, remote, attrs, stdout, verbose);
                }
            } else {
                if (Files.exists(local, new LinkOption[0]) && Files.isDirectory(local, new LinkOption[0])) {
                    int pos = remote.lastIndexOf(47);
                    String name = pos >= 0 ? remote.substring(pos + 1) : remote;
                    local = local.resolve(name);
                }
                this.transferFile(sftp, local, remote, upload, stdout, verbose);
            }
        }
    }

    private class HelpCommandExecutor
    implements SftpCommandExecutor {
        HelpCommandExecutor() {
        }

        public String getName() {
            return "help";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            for (String cmd : SftpCommandMain.this.commandsMap.keySet()) {
                stdout.append("    ").println(cmd);
            }
            return false;
        }
    }

    private class ReadLinkCommandExecutor
    implements SftpCommandExecutor {
        ReadLinkCommandExecutor() {
        }

        public String getName() {
            return "readlink";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            ValidateUtils.checkTrue((GenericUtils.length((Object[])comps) <= 1 ? 1 : 0) != 0, (String)"Invalid number of arguments: %s", (Object)args);
            String path = GenericUtils.trimToEmpty((String)SftpCommandMain.this.resolveRemotePath(args));
            SftpClient client = SftpCommandMain.this.getClient();
            String linkData = client.readLink(path);
            stdout.append("    ").println(linkData);
            return false;
        }
    }

    private class LStatCommandExecutor
    implements SftpCommandExecutor {
        LStatCommandExecutor() {
        }

        public String getName() {
            return "lstat";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            ValidateUtils.checkTrue((GenericUtils.length((Object[])comps) <= 1 ? 1 : 0) != 0, (String)"Invalid number of arguments: %s", (Object)args);
            String path = GenericUtils.trimToEmpty((String)SftpCommandMain.this.resolveRemotePath(args));
            SftpClient client = SftpCommandMain.this.getClient();
            SftpClient.Attributes attrs = client.lstat(path);
            SftpCommandMain.this.appendFileAttributes(stdout, client, path, attrs).println();
            return false;
        }
    }

    private class StatVfsCommandExecutor
    implements SftpCommandExecutor {
        StatVfsCommandExecutor() {
        }

        public String getName() {
            return "statvfs@openssh.com";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Field[] fields;
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            int numArgs = GenericUtils.length((Object[])comps);
            ValidateUtils.checkTrue((numArgs <= 1 ? 1 : 0) != 0, (String)"Invalid number of arguments: %s", (Object)args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            OpenSSHStatPathExtension ext = (OpenSSHStatPathExtension)sftp.getExtension(OpenSSHStatPathExtension.class);
            ValidateUtils.checkTrue((boolean)ext.isSupported(), (String)"Extension not supported by server: %s", (Object)ext.getName());
            String remPath = SftpCommandMain.this.resolveRemotePath(numArgs >= 1 ? GenericUtils.trimToEmpty((String)comps[0]) : GenericUtils.trimToEmpty((String)args));
            OpenSSHStatExtensionInfo info = ext.stat(remPath);
            for (Field f : fields = info.getClass().getFields()) {
                String name = f.getName();
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod)) continue;
                Object value = f.get(info);
                stdout.append("    ").append(name).append(": ").println(value);
            }
            return false;
        }
    }

    private class RenameCommandExecutor
    implements SftpCommandExecutor {
        RenameCommandExecutor() {
        }

        public String getName() {
            return "rename";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            ValidateUtils.checkTrue((GenericUtils.length((Object[])comps) == 2 ? 1 : 0) != 0, (String)"Invalid number of arguments: %s", (Object)args);
            String oldPath = SftpCommandMain.this.resolveRemotePath(GenericUtils.trimToEmpty((String)comps[0]));
            String newPath = SftpCommandMain.this.resolveRemotePath(GenericUtils.trimToEmpty((String)comps[1]));
            SftpClient sftp = SftpCommandMain.this.getClient();
            sftp.rename(oldPath, newPath);
            return false;
        }
    }

    private class RmdirCommandExecutor
    implements SftpCommandExecutor {
        RmdirCommandExecutor() {
        }

        public String getName() {
            return "rmdir";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty((String)args, (String)"No remote directory specified");
            String path = SftpCommandMain.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            sftp.rmdir(path);
            return false;
        }
    }

    private class RmCommandExecutor
    implements SftpCommandExecutor {
        RmCommandExecutor() {
        }

        public String getName() {
            return "rm";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            int numArgs = GenericUtils.length((Object[])comps);
            ValidateUtils.checkTrue((numArgs >= 1 ? 1 : 0) != 0, (String)"No arguments");
            ValidateUtils.checkTrue((numArgs <= 2 ? 1 : 0) != 0, (String)"Too many arguments: %s", (Object)args);
            Object remotePath = comps[0];
            boolean recursive = false;
            boolean verbose = false;
            if (((String)remotePath).charAt(0) == '-') {
                ValidateUtils.checkTrue((((String)remotePath).length() > 1 ? 1 : 0) != 0, (String)"Missing flags specification: %s", (Object)args);
                ValidateUtils.checkTrue((numArgs == 2 ? 1 : 0) != 0, (String)"Missing remote directory: %s", (Object)args);
                block4: for (int index = 1; index < ((String)remotePath).length(); ++index) {
                    char ch = ((String)remotePath).charAt(index);
                    switch (ch) {
                        case 'r': {
                            recursive = true;
                            continue block4;
                        }
                        case 'v': {
                            verbose = true;
                            continue block4;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown flag (" + Character.toString(ch) + ")");
                        }
                    }
                }
                remotePath = comps[1];
            }
            String path = SftpCommandMain.this.resolveRemotePath((String)remotePath);
            SftpClient sftp = SftpCommandMain.this.getClient();
            if (recursive) {
                SftpClient.Attributes attrs = sftp.stat(path);
                ValidateUtils.checkTrue((boolean)attrs.isDirectory(), (String)"Remote path not a directory: %s", (Object)args);
                this.removeRecursive(sftp, path, attrs, stdout, verbose);
            } else {
                sftp.remove(path);
                if (verbose) {
                    stdout.append("    ").append("Removed ").println(path);
                }
            }
            return false;
        }

        private void removeRecursive(SftpClient sftp, String path, SftpClient.Attributes attrs, PrintStream stdout, boolean verbose) throws IOException {
            if (attrs.isDirectory()) {
                for (SftpClient.DirEntry entry : sftp.readDir(path)) {
                    String name = entry.getFilename();
                    if (".".equals(name) || "..".equals(name)) continue;
                    this.removeRecursive(sftp, path + "/" + name, entry.getAttributes(), stdout, verbose);
                }
                sftp.rmdir(path);
            } else if (attrs.isRegularFile()) {
                sftp.remove(path);
            } else if (verbose) {
                stdout.append("    ").append("Skip special file ").println(path);
                return;
            }
            if (verbose) {
                stdout.append("    ").append("Removed ").println(path);
            }
        }
    }

    private class LlsCommandExecutor
    implements SftpCommandExecutor {
        LlsCommandExecutor() {
        }

        public String getName() {
            return "lls";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Path local;
            String flags;
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            int numComps = GenericUtils.length((Object[])comps);
            String pathArg = numComps <= 0 ? null : GenericUtils.trimToEmpty((String)comps[numComps - 1]);
            String string = flags = numComps >= 2 ? GenericUtils.trimToEmpty((String)comps[0]) : null;
            if (GenericUtils.length((CharSequence)pathArg) > 0 && pathArg.charAt(0) == '-') {
                flags = pathArg;
                pathArg = null;
            }
            if (Files.notExists(local = Paths.get(SftpCommandMain.this.resolveLocalPath(pathArg), new String[0]).normalize().toAbsolutePath(), new LinkOption[0])) {
                stderr.println("File/Folder not found");
            } else if (Files.isDirectory(local, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(local);){
                    for (Path path : ds) {
                        this.displayLocalPathInfo(path, stdout);
                    }
                }
            } else if (Files.isRegularFile(local, new LinkOption[0])) {
                this.displayLocalPathInfo(local, stdout);
            } else {
                stderr.println("Unsupported special file");
            }
            return false;
        }

        protected void displayLocalPathInfo(Path path, PrintStream stdout) throws IOException {
            stdout.append('\t').append(Objects.toString(path.getFileName()));
            if (Files.isRegularFile(path, new LinkOption[0])) {
                stdout.append(' ').append(Long.toString(Files.size(path)));
            } else {
                stdout.append('/');
            }
            stdout.println();
        }
    }

    private class LsCommandExecutor
    implements SftpCommandExecutor {
        LsCommandExecutor() {
        }

        public String getName() {
            return "ls";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String flags;
            Object[] comps = GenericUtils.split((String)args, (char)' ');
            int numComps = GenericUtils.length((Object[])comps);
            String pathArg = numComps <= 0 ? null : GenericUtils.trimToEmpty((String)comps[numComps - 1]);
            String string = flags = numComps >= 2 ? GenericUtils.trimToEmpty((String)comps[0]) : null;
            if (GenericUtils.length((CharSequence)pathArg) > 0 && pathArg.charAt(0) == '-') {
                flags = pathArg;
                pathArg = null;
            }
            String path = SftpCommandMain.this.resolveRemotePath(pathArg);
            SftpClient sftp = SftpCommandMain.this.getClient();
            int version = sftp.getVersion();
            boolean showLongName = version == 3 && GenericUtils.length((CharSequence)flags) > 1 && flags.indexOf(108) > 0;
            for (SftpClient.DirEntry entry : sftp.readDir(path)) {
                String fileName = entry.getFilename();
                SftpClient.Attributes attrs = entry.getAttributes();
                SftpCommandMain.this.appendFileAttributes(stdout.append("    ").append(fileName), sftp, path + "/" + fileName, attrs).println();
                if (!showLongName) continue;
                stdout.append("\t\tlong-name: ").println(entry.getLongFilename());
            }
            return false;
        }
    }

    private class MkdirCommandExecutor
    implements SftpCommandExecutor {
        MkdirCommandExecutor() {
        }

        public String getName() {
            return "mkdir";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty((String)args, (String)"No remote directory specified");
            String path = SftpCommandMain.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            sftp.mkdir(path);
            return false;
        }
    }

    private class LcdCommandExecutor
    extends PwdCommandExecutor {
        LcdCommandExecutor() {
        }

        @Override
        public String getName() {
            return "lcd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            if (GenericUtils.isEmpty((CharSequence)args)) {
                SftpCommandMain.this.setCurrentLocalDirectory(System.getProperty("user.home"));
            } else {
                Path path = Paths.get(SftpCommandMain.this.resolveLocalPath(args), new String[0]).normalize().toAbsolutePath();
                ValidateUtils.checkTrue((boolean)Files.exists(path, new LinkOption[0]), (String)"No such local directory: %s", (Object)path);
                ValidateUtils.checkTrue((boolean)Files.isDirectory(path, new LinkOption[0]), (String)"Path is not a directory: %s", (Object)path);
                SftpCommandMain.this.setCurrentLocalDirectory(path.toString());
            }
            return super.executeCommand("", stdin, stdout, stderr);
        }
    }

    private class CdCommandExecutor
    extends PwdCommandExecutor {
        CdCommandExecutor() {
        }

        @Override
        public String getName() {
            return "cd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty((String)args, (String)"No remote directory specified");
            String newPath = SftpCommandMain.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            SftpCommandMain.this.setCurrentRemoteDirectory(sftp.canonicalPath(newPath));
            return super.executeCommand("", stdin, stdout, stderr);
        }
    }

    private class VersionCommandExecutor
    implements SftpCommandExecutor {
        VersionCommandExecutor() {
        }

        public String getName() {
            return "version";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            stdout.append("    ").println(sftp.getVersion());
            return false;
        }
    }

    private class InfoCommandExecutor
    implements SftpCommandExecutor {
        InfoCommandExecutor() {
        }

        public String getName() {
            return "info";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            ClientSession session = sftp.getSession();
            stdout.append("    ").println(session.getServerVersion());
            NavigableMap extensions = sftp.getServerExtensions();
            Map parsed = ParserUtils.parse((Map)extensions);
            if (MapEntryUtils.size((Map)extensions) > 0) {
                stdout.println();
            }
            extensions.forEach((name, value) -> {
                Object info = parsed.get(name);
                stdout.append("    ").append((CharSequence)name).append(": ");
                if (info == null) {
                    stdout.println(BufferUtils.toHex((byte[])value));
                } else {
                    stdout.println(info);
                }
            });
            return false;
        }
    }

    private class ClientCommandExecutor
    implements SftpCommandExecutor {
        ClientCommandExecutor() {
        }

        public String getName() {
            return "client";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            ClientSession session = sftp.getSession();
            ClientFactoryManager manager = session.getFactoryManager();
            SftpCommandMain.appendInfoValue(stdout, IoServiceFactory.class.getSimpleName(), manager.getIoServiceFactory().getClass().getSimpleName()).println();
            SftpCommandMain.appendInfoValue(stdout, CipherFactory.class.getSimpleName(), NamedResource.getNames((Collection)manager.getCipherFactories())).println();
            SftpCommandMain.appendInfoValue(stdout, KeyExchange.class.getSimpleName(), NamedResource.getNames((Collection)manager.getKeyExchangeFactories())).println();
            SftpCommandMain.appendInfoValue(stdout, SignatureFactory.class.getSimpleName(), NamedResource.getNames((Collection)manager.getSignatureFactories())).println();
            SftpCommandMain.appendInfoValue(stdout, MacFactory.class.getSimpleName(), NamedResource.getNames((Collection)manager.getMacFactories())).println();
            SftpCommandMain.appendInfoValue(stdout, CompressionFactory.class.getSimpleName(), NamedResource.getNames((Collection)manager.getCompressionFactories())).println();
            SftpCommandMain.appendInfoValue(stdout, ChannelFactory.class.getSimpleName(), NamedResource.getNames((Collection)manager.getChannelFactories())).println();
            SftpCommandMain.appendInfoValue(stdout, ServiceFactory.class.getSimpleName(), NamedResource.getNames((Collection)manager.getServiceFactories())).println();
            return false;
        }
    }

    private class KexCommandExecutor
    implements SftpCommandExecutor {
        KexCommandExecutor() {
        }

        public String getName() {
            return "kex";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            ClientSession session = sftp.getSession();
            Map clientProposals = session.getClientKexProposals();
            Map serverProposals = session.getServerKexProposals();
            Map negotiated = session.getKexNegotiationResult();
            for (KexProposalOption option : KexProposalOption.VALUES) {
                String description = option.getDescription();
                SftpCommandMain.appendInfoValue(stdout, description + "[client]", clientProposals.get(option)).println();
                SftpCommandMain.appendInfoValue(stdout, description + "[server]", serverProposals.get(option)).println();
                SftpCommandMain.appendInfoValue(stdout, description + "[negotiated]", negotiated.get(option)).println();
            }
            return false;
        }
    }

    private class SessionCommandExecutor
    implements SftpCommandExecutor {
        SessionCommandExecutor() {
        }

        public String getName() {
            return "session";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommandMain.this.getClient();
            ClientSession session = sftp.getSession();
            SftpCommandMain.appendInfoValue(stdout, "Session ID", BufferUtils.toHex((byte[])session.getSessionId())).println();
            SftpCommandMain.appendInfoValue(stdout, "Connect address", session.getConnectAddress()).println();
            IoSession ioSession = session.getIoSession();
            SftpCommandMain.appendInfoValue(stdout, "Local address", ioSession.getLocalAddress()).println();
            SftpCommandMain.appendInfoValue(stdout, "Remote address", ioSession.getRemoteAddress()).println();
            SftpCommandMain.appendInfoValue(stdout, "Client version", session.getClientVersion()).println();
            SftpCommandMain.appendInfoValue(stdout, "Server version", session.getServerVersion()).println();
            return false;
        }
    }

    private class PwdCommandExecutor
    implements SftpCommandExecutor {
        protected PwdCommandExecutor() {
        }

        public String getName() {
            return "pwd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            stdout.append("    ").append("Remote: ").println(SftpCommandMain.this.getCurrentRemoteDirectory());
            stdout.append("    ").append("Local: ").println(SftpCommandMain.this.getCurrentLocalDirectory());
            return false;
        }
    }

    private static class ExitCommandExecutor
    implements SftpCommandExecutor {
        ExitCommandExecutor() {
        }

        public String getName() {
            return "exit";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((CharSequence)args), (String)"Unexpected arguments: %s", (Object)args);
            stdout.println("Exiting");
            return true;
        }
    }
}

