/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.server;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ManagedExecutorServiceSupplier;
import org.apache.sshd.scp.common.ScpFileOpener;
import org.apache.sshd.scp.common.ScpFileOpenerHolder;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.server.ScpCommand;
import org.apache.sshd.scp.server.ScpShell;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.AbstractDelegatingCommandFactory;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.shell.ShellFactorySelector;

public class ScpCommandFactory
extends AbstractDelegatingCommandFactory
implements ManagedExecutorServiceSupplier,
ScpFileOpenerHolder,
Cloneable,
ShellFactory,
ShellFactorySelector {
    public static final String SCP_FACTORY_NAME = "scp";
    private Supplier<? extends CloseableExecutorService> executorsProvider;
    private ScpFileOpener fileOpener;
    private ShellFactory delegateShellFactory = InteractiveProcessShellFactory.INSTANCE;
    private int sendBufferSize = 8192;
    private int receiveBufferSize = 8192;
    private Collection<ScpTransferEventListener> listeners = new CopyOnWriteArraySet<ScpTransferEventListener>();
    private ScpTransferEventListener listenerProxy = (ScpTransferEventListener)EventListenerUtils.proxyWrapper(ScpTransferEventListener.class, this.listeners);

    public ScpCommandFactory() {
        super(SCP_FACTORY_NAME);
    }

    @Override
    public ScpFileOpener getScpFileOpener() {
        return this.fileOpener;
    }

    @Override
    public void setScpFileOpener(ScpFileOpener fileOpener) {
        this.fileOpener = fileOpener;
    }

    public Supplier<? extends CloseableExecutorService> getExecutorServiceProvider() {
        return this.executorsProvider;
    }

    public void setExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider) {
        this.executorsProvider = provider;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendSize) {
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveSize) {
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() receive buffer size (" + receiveSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
    }

    public boolean addEventListener(ScpTransferEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No listener instance");
        }
        return this.listeners.add(listener);
    }

    public boolean removeEventListener(ScpTransferEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No listener instance");
        }
        return this.listeners.remove(listener);
    }

    public boolean isSupportedCommand(String command) {
        if (GenericUtils.isEmpty((CharSequence)command)) {
            return false;
        }
        return command.startsWith(SCP_FACTORY_NAME);
    }

    protected Command executeSupportedCommand(String command) {
        return new ScpCommand(command, this.resolveExecutorService(command), this.getSendBufferSize(), this.getReceiveBufferSize(), this.getScpFileOpener(), this.listenerProxy);
    }

    public ShellFactory getDelegateShellFactory() {
        return this.delegateShellFactory;
    }

    public void setDelegateShellFactory(ShellFactory delegateShellFactory) {
        this.delegateShellFactory = delegateShellFactory;
    }

    public ShellFactory selectShellFactory(ChannelSession channelSession) throws IOException {
        SessionContext session = channelSession.getSessionContext();
        String clientVersion = session.getClientVersion();
        if (clientVersion.contains("WinSCP")) {
            return this;
        }
        return this.delegateShellFactory;
    }

    public Command createShell(ChannelSession channel) throws IOException {
        ShellFactory factory = this.selectShellFactory(channel);
        if (factory == this || factory == null) {
            return new ScpShell(channel, this.resolveExecutorService(), this.getSendBufferSize(), this.getReceiveBufferSize(), this.getScpFileOpener(), this.listenerProxy);
        }
        return factory.createShell(channel);
    }

    protected CloseableExecutorService resolveExecutorService(String command) {
        return this.resolveExecutorService();
    }

    public ScpCommandFactory clone() {
        try {
            ScpCommandFactory other = (ScpCommandFactory)this.getClass().cast(super.clone());
            other.listeners = new CopyOnWriteArraySet<ScpTransferEventListener>(this.listeners);
            other.listenerProxy = (ScpTransferEventListener)EventListenerUtils.proxyWrapper(ScpTransferEventListener.class, other.listeners);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    implements ObjectBuilder<ScpCommandFactory> {
        private final ScpCommandFactory factory = new ScpCommandFactory();

        public Builder withFileOpener(ScpFileOpener opener) {
            this.factory.setScpFileOpener(opener);
            return this;
        }

        public Builder withDelegate(CommandFactory delegate) {
            this.factory.setDelegateCommandFactory(delegate);
            return this;
        }

        public Builder withExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider) {
            this.factory.setExecutorServiceProvider(provider);
            return this;
        }

        public Builder withSendBufferSize(int sendSize) {
            this.factory.setSendBufferSize(sendSize);
            return this;
        }

        public Builder withReceiveBufferSize(int receiveSize) {
            this.factory.setReceiveBufferSize(receiveSize);
            return this;
        }

        public Builder addEventListener(ScpTransferEventListener listener) {
            this.factory.addEventListener(listener);
            return this;
        }

        public Builder removeEventListener(ScpTransferEventListener listener) {
            this.factory.removeEventListener(listener);
            return this;
        }

        public Builder withDelegateShellFactory(ShellFactory shellFactory) {
            this.factory.setDelegateShellFactory(shellFactory);
            return this;
        }

        public ScpCommandFactory build() {
            return this.factory.clone();
        }
    }
}

