/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common.helpers;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.scp.common.ScpException;
import org.apache.sshd.scp.common.helpers.ScpIoUtils;

public class ScpAckInfo {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private final int statusCode;
    private final String line;

    public ScpAckInfo(int statusCode) {
        this(statusCode, null);
    }

    public ScpAckInfo(int statusCode, String line) {
        ValidateUtils.checkTrue((statusCode >= 0 ? 1 : 0) != 0, (String)"Invalid status code: %d", (long)statusCode);
        this.statusCode = statusCode;
        this.line = line;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getLine() {
        return this.line;
    }

    public <O extends OutputStream> O send(O out) throws IOException {
        return ScpAckInfo.sendAck(out, this.getStatusCode(), this.getLine());
    }

    public void validateCommandStatusCode(String command, Object location) throws IOException {
        int code = this.getStatusCode();
        if (code != 0 && code != 1) {
            throw new ScpException("Bad reply code (" + code + ") for command='" + command + "' at " + location + ": " + this.getLine(), (Integer)code);
        }
    }

    public String toString() {
        int code = this.getStatusCode();
        String l = this.getLine();
        if (code == 0 || GenericUtils.isEmpty((CharSequence)l)) {
            return Integer.toString(code);
        }
        return code + ": " + l;
    }

    public static ScpAckInfo readAck(InputStream in, boolean canEof) throws IOException {
        int statusCode = in.read();
        if (statusCode == -1) {
            if (canEof) {
                return null;
            }
            throw new EOFException("readAck - EOF before ACK");
        }
        if (statusCode == 0) {
            return new ScpAckInfo(statusCode);
        }
        String line = ScpIoUtils.readLine(in);
        return new ScpAckInfo(statusCode, line);
    }

    public static void sendOk(OutputStream out) throws IOException {
        ScpAckInfo.sendAck(out, 0, null);
    }

    public static <O extends OutputStream> O sendWarning(O out, String message) throws IOException {
        return ScpAckInfo.sendAck(out, 1, message == null ? "" : message);
    }

    public static <O extends OutputStream> O sendError(O out, String message) throws IOException {
        return ScpAckInfo.sendAck(out, 2, message == null ? "" : message);
    }

    public static <O extends OutputStream> O sendAck(O out, int level, String message) throws IOException {
        out.write(level);
        if (level != 0) {
            ScpIoUtils.writeLine(out, message);
        } else {
            out.flush();
        }
        return out;
    }
}

