/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server.helper;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.cli.server.helper.ServerEventListenerHelper;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.SftpEventListener;

public class SftpServerSubSystemEventListener
extends ServerEventListenerHelper
implements SftpEventListener {
    public SftpServerSubSystemEventListener(Appendable stdout, Appendable stderr) {
        super("sftp", stdout, stderr);
    }

    public void initialized(ServerSession session, int version) throws IOException {
        this.outputDebugMessage("Session %s initialized - version=%d", session, version);
    }

    public void destroying(ServerSession session) throws IOException {
        this.outputDebugMessage("Session destroyed: %s", session);
    }

    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (thrown == null) {
            this.outputDebugMessage("Session %s created directory %s with attributes=%s", session, path, attrs);
        } else {
            this.outputErrorMessage("Failed (%s) to create directory %s in session %s: %s", thrown.getClass().getSimpleName(), path, session, thrown.getMessage());
        }
    }

    public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) throws IOException {
        if (thrown == null) {
            this.outputDebugMessage("Session %s moved %s to %s with options=%s", session, srcPath, dstPath, opts);
        } else {
            this.outputErrorMessage("Failed (%s) to move %s to %s using options=%s in session %s: %s", thrown.getClass().getSimpleName(), srcPath, dstPath, opts, session, thrown.getMessage());
        }
    }

    public void removed(ServerSession session, Path path, boolean isDirectory, Throwable thrown) throws IOException {
        if (thrown == null) {
            this.outputDebugMessage("Session %s removed %s", session, path);
        } else {
            this.outputErrorMessage("Failed (%s) to remove %s in session %s: %s", thrown.getClass().getSimpleName(), path, session, thrown.getMessage());
        }
    }
}

