/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server.helper;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.sshd.cli.server.helper.ServerEventListenerHelper;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.scp.common.ScpTransferEventListener;

public class ScpCommandTransferEventListener
extends ServerEventListenerHelper
implements ScpTransferEventListener {
    public ScpCommandTransferEventListener(Appendable stdout, Appendable stderr) {
        super("scp", stdout, stderr);
    }

    public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) throws IOException {
        this.outputDebugMessage("startFileEvent(%s)[%s] len=%d, perms=%s: %s", session, op, length, perms, file);
    }

    public void endFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, Throwable thrown) throws IOException {
        if (thrown != null) {
            this.outputErrorMessage("endFileEvent(%s)[%s] failed (%s) len=%d, perms=%s [%s]: %s", session, op, thrown.getClass().getSimpleName(), length, perms, file, thrown.getMessage());
        } else {
            this.outputDebugMessage("endFileEvent(%s)[%s] len=%d, perms=%s: %s", session, op, length, perms, file);
        }
    }

    public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) throws IOException {
        this.outputDebugMessage("startFolderEvent(%s)[%s] perms=%s: %s", session, op, perms, file);
    }

    public void endFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms, Throwable thrown) throws IOException {
        if (thrown != null) {
            this.outputErrorMessage("endFolderEvent(%s)[%s] failed (%s) perms=%s [%s]: %s", session, op, thrown.getClass().getSimpleName(), perms, file, thrown.getMessage());
        } else {
            this.outputDebugMessage("endFolderEvent(%s)[%s] lperms=%s: %s", session, op, perms, file);
        }
    }
}

