/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyPair;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sshd.cli.CliSupport;
import org.apache.sshd.cli.client.CliClientModuleProperties;
import org.apache.sshd.cli.client.SshClientCliSupport;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import org.apache.sshd.scp.client.ScpRemote2RemoteTransferHelper;
import org.apache.sshd.scp.client.ScpRemote2RemoteTransferListener;
import org.apache.sshd.scp.common.ScpLocation;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.scp.common.helpers.ScpAckInfo;
import org.apache.sshd.scp.common.helpers.ScpReceiveDirCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpReceiveFileCommandDetails;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;

public class ScpCommandMain
extends SshClientCliSupport {
    public static final String SCP_PORT_OPTION = "-P";
    public static final String SCP_REMOTE_TO_REMOTE_OPTION = "-3";

    public static String[] normalizeCommandArguments(PrintStream stdout, PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length((Object[])args);
        if (numArgs <= 0) {
            return args;
        }
        ArrayList<String> effective = new ArrayList<String>(numArgs);
        boolean error = false;
        boolean threeWay = false;
        for (int index = 0; index < numArgs && !error; ++index) {
            String argName = args[index];
            if (ScpCommandMain.isArgumentedOption(SCP_PORT_OPTION, argName) || "-creator".equals(argName)) {
                if (++index >= numArgs) {
                    error = ScpCommandMain.showError(stderr, "option requires an argument: " + argName);
                    break;
                }
                effective.add(argName);
                effective.add(args[index]);
                continue;
            }
            if ("-r".equals(argName) || "-p".equals(argName) || "-q".equals(argName) || "-C".equals(argName) || "-v".equals(argName) || "-vv".equals(argName) || "-vvv".equals(argName)) {
                effective.add(argName);
                continue;
            }
            if (SCP_REMOTE_TO_REMOTE_OPTION.equals(argName)) {
                threeWay = true;
                effective.add(argName);
                continue;
            }
            if (argName.charAt(0) == '-') {
                error = ScpCommandMain.showError(stderr, "Unknown option: " + argName);
                break;
            }
            if (++index >= numArgs) {
                error = ScpCommandMain.showError(stderr, "Not enough arguments");
                break;
            }
            ScpLocation source = new ScpLocation(argName);
            ScpLocation target = new ScpLocation(args[index]);
            if (index < numArgs - 1) {
                error = ScpCommandMain.showError(stderr, "Unexpected extra arguments");
                break;
            }
            if (threeWay) {
                if (source.isLocal() || target.isLocal()) {
                    error = ScpCommandMain.showError(stderr, "Both targets must be remote for the 3-way copy option");
                    break;
                }
                ScpCommandMain.adjustRemoteTargetArguments(source, source, target, effective);
                break;
            }
            if (source.isLocal() == target.isLocal()) {
                error = ScpCommandMain.showError(stderr, "Both targets are either remote or local");
                break;
            }
            ScpLocation remote = source.isLocal() ? target : source;
            ScpCommandMain.adjustRemoteTargetArguments(remote, source, target, effective);
            break;
        }
        if (error) {
            return null;
        }
        return effective.toArray(new String[effective.size()]);
    }

    private static void adjustRemoteTargetArguments(ScpLocation remote, ScpLocation source, ScpLocation target, Collection<String> effective) {
        int port = remote.resolvePort();
        if (port != 22) {
            effective.add(SCP_PORT_OPTION);
            effective.add(Integer.toString(port));
        }
        effective.add(remote.resolveUsername() + "@" + remote.getHost());
        effective.add(source.toString());
        effective.add(target.toString());
    }

    public static ScpClientCreator resolveScpClientCreator(PrintStream stderr, String ... args) {
        String className = null;
        int numArgs = GenericUtils.length((Object[])args);
        for (int index = 0; index < numArgs; ++index) {
            String argName = args[index];
            if (!"-creator".equals(argName)) continue;
            if (++index >= numArgs) {
                ScpCommandMain.showError(stderr, "option requires an argument: " + argName);
                return null;
            }
            className = args[index];
        }
        if (GenericUtils.isEmpty(className)) {
            className = System.getProperty(ScpClientCreator.class.getName());
        }
        if (GenericUtils.isEmpty(className)) {
            return ScpClientCreator.instance();
        }
        try {
            ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(ScpClientCreator.class);
            Class<?> clazz = cl.loadClass(className);
            return (ScpClientCreator)ScpClientCreator.class.cast(clazz.newInstance());
        }
        catch (Exception e) {
            stderr.append("WARNING: Failed (").append(e.getClass().getSimpleName()).append(')').append(" to instantiate ").append(className).append(": ").println(e.getMessage());
            stderr.flush();
            return null;
        }
    }

    public static Set<ScpClient.Option> parseCopyOptions(String[] args) {
        if (GenericUtils.isEmpty((Object[])args)) {
            return Collections.emptySet();
        }
        EnumSet<ScpClient.Option> options = EnumSet.noneOf(ScpClient.Option.class);
        for (String argName : args) {
            if ("-r".equals(argName)) {
                options.add(ScpClient.Option.TargetIsDirectory);
                options.add(ScpClient.Option.Recursive);
                continue;
            }
            if (!"-p".equals(argName)) continue;
            options.add(ScpClient.Option.PreserveAttributes);
        }
        return options;
    }

    public static void showUsageMessage(PrintStream stderr) {
        stderr.println("usage: scp [-P port] [-i identity] [-io nio2|mina|netty] [-3] [" + ScpClient.Option.Recursive.getOptionValue() + "] [" + ScpClient.Option.PreserveAttributes.getOptionValue() + "] [-v[v][v]] [-E logoutput] [-q] [-o option=value] [-o creator=class name] [-c cipherlist] [-m maclist] [-J proxyJump] [-w password] [-C] <source> <target>");
        stderr.println();
        stderr.println("Where <source> or <target> are either 'user@host:file' or a local file path");
        stderr.println("NOTE: exactly ONE of the source or target must be remote and the other one local");
        stderr.println("    or both remote if -3 specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xferLocalToRemote(BufferedReader stdin, final PrintStream stdout, final PrintStream stderr, String[] args, ScpLocation source, ScpLocation target, Collection<ScpClient.Option> options, OutputStream logStream, Level level, boolean quiet) throws Exception {
        ClientSession session;
        ScpClientCreator creator = ScpCommandMain.resolveScpClientCreator(stderr, args);
        ClientSession clientSession = session = logStream == null || creator == null || GenericUtils.isEmpty((Object[])args) ? null : ScpCommandMain.setupClientSession(SCP_PORT_OPTION, stdin, level, stdout, stderr, args);
        if (session == null) {
            ScpCommandMain.showUsageMessage(stderr);
            System.exit(-1);
            return;
        }
        try {
            if (!quiet) {
                creator.setScpTransferEventListener(new ScpTransferEventListener(){

                    public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) {
                        this.logEvent("startFolderEvent", session, op, file, -1L, perms, null);
                    }

                    public void endFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms, Throwable thrown) {
                        this.logEvent("endFolderEvent", session, op, file, -1L, perms, thrown);
                    }

                    public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) {
                        this.logEvent("startFileEvent", session, op, file, length, perms, null);
                    }

                    public void endFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, Throwable thrown) {
                        this.logEvent("endFileEvent", session, op, file, length, perms, thrown);
                    }

                    public void handleFileEventAckInfo(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms, ScpAckInfo ackInfo) throws IOException {
                        this.logEvent("ackInfo(" + ackInfo + ")", session, op, file, length, perms, null);
                    }

                    private void logEvent(String name, Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Collection<PosixFilePermission> perms, Throwable thrown) {
                        PrintStream ps = thrown == null ? stdout : stderr;
                        ps.append("    ").append(name).append('[').append(session.toString()).append(']').append('[').append(op.name()).append(']').append(' ').append(file.toString());
                        if (length > 0L) {
                            ps.append(' ').append("length=").append(Long.toString(length));
                        }
                        ps.append(' ').append(String.valueOf(perms));
                        if (thrown != null) {
                            ps.append(" - ").append(thrown.getClass().getSimpleName()).append(": ").append(thrown.getMessage());
                        }
                        ps.println();
                    }
                });
            }
            ScpClient client = creator.createScpClient(session);
            if (source.isLocal()) {
                client.upload(source.getPath(), target.getPath(), options);
            } else {
                client.download(source.getPath(), target.getPath(), options);
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xferRemoteToRemote(BufferedReader stdin, final PrintStream stdout, final PrintStream stderr, String[] args, ScpLocation source, ScpLocation target, Collection<ScpClient.Option> options, OutputStream logStream, Level level, boolean quiet) throws Exception {
        ClientSession srcSession;
        ClientSession clientSession = srcSession = logStream == null || GenericUtils.isEmpty((Object[])args) ? null : ScpCommandMain.setupClientSession(SCP_PORT_OPTION, stdin, level, stdout, stderr, args);
        if (srcSession == null) {
            ScpCommandMain.showUsageMessage(stderr);
            System.exit(-1);
            return;
        }
        try {
            ClientFactoryManager manager = srcSession.getFactoryManager();
            HostConfigEntry entry = ScpCommandMain.resolveHost(manager, target.resolveUsername(), target.getHost(), target.resolvePort(), null);
            try (ClientSession dstSession = (ClientSession)((ConnectFuture)manager.connect(entry, null, null).verify((Duration)CliClientModuleProperties.CONECT_TIMEOUT.getRequired((PropertyResolver)srcSession))).getSession();){
                boolean preserveAttributes;
                Iterator iter;
                AuthenticationIdentitiesProvider provider = srcSession.getRegisteredIdentities();
                Iterable ids = provider == null ? null : provider.loadIdentities();
                Iterator iterator = iter = ids == null ? null : ids.iterator();
                while (iter != null && iter.hasNext()) {
                    Object v = iter.next();
                    if (v instanceof String) {
                        dstSession.addPasswordIdentity((String)v);
                        continue;
                    }
                    if (v instanceof KeyPair) {
                        dstSession.addPublicKeyIdentity((KeyPair)v);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unsupported source identity: " + v);
                }
                dstSession.auth().verify((Duration)CliClientModuleProperties.AUTH_TIMEOUT.getRequired((PropertyResolver)dstSession));
                ScpRemote2RemoteTransferListener listener = quiet ? null : new ScpRemote2RemoteTransferListener(){

                    public void startDirectFileTransfer(ClientSession srcSession, String source, ClientSession dstSession, String destination, ScpTimestampCommandDetails timestamp, ScpReceiveFileCommandDetails details) throws IOException {
                        this.logEvent("FILE-START: ", source, destination, null);
                    }

                    public void startDirectDirectoryTransfer(ClientSession srcSession, String source, ClientSession dstSession, String destination, ScpTimestampCommandDetails timestamp, ScpReceiveDirCommandDetails details) throws IOException {
                        this.logEvent("DIR-START: ", source, destination, null);
                    }

                    public void endDirectFileTransfer(ClientSession srcSession, String source, ClientSession dstSession, String destination, ScpTimestampCommandDetails timestamp, ScpReceiveFileCommandDetails details, long xferSize, Throwable thrown) throws IOException {
                        this.logEvent("FILE-END: ", source, destination, thrown);
                    }

                    public void endDirectDirectoryTransfer(ClientSession srcSession, String source, ClientSession dstSession, String destination, ScpTimestampCommandDetails timestamp, ScpReceiveDirCommandDetails details, Throwable thrown) throws IOException {
                        this.logEvent("DIR-END: ", source, destination, thrown);
                    }

                    private void logEvent(String event, String src, String dst, Throwable thrown) {
                        PrintStream ps = thrown == null ? stdout : stderr;
                        ps.append("    ").append(event).append(' ').append(src).append(" ==> ").append(dst);
                        if (thrown != null) {
                            ps.append(" - ").append(thrown.getClass().getSimpleName()).append(": ").append(thrown.getMessage());
                        }
                        ps.println();
                    }
                };
                ScpRemote2RemoteTransferHelper helper = new ScpRemote2RemoteTransferHelper(srcSession, dstSession, listener);
                boolean bl = preserveAttributes = GenericUtils.isNotEmpty(options) && options.contains(ScpClient.Option.PreserveAttributes);
                if (GenericUtils.isNotEmpty(options) && (options.contains(ScpClient.Option.Recursive) || options.contains(ScpClient.Option.TargetIsDirectory))) {
                    helper.transferDirectory(source.getPath(), target.getPath(), preserveAttributes);
                } else {
                    helper.transferFile(source.getPath(), target.getPath(), preserveAttributes);
                }
            }
        }
        finally {
            srcSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        OutputStream logStream = stdout;
        try (BufferedReader stdin = new BufferedReader(new InputStreamReader((InputStream)new NoCloseInputStream(System.in), Charset.defaultCharset()));){
            args = ScpCommandMain.normalizeCommandArguments(stdout, stderr, args);
            Level level = Level.SEVERE;
            int numArgs = GenericUtils.length((Object[])args);
            if (numArgs >= 2) {
                level = CliSupport.resolveLoggingVerbosity(args, numArgs - 2);
                logStream = ScpCommandMain.resolveLoggingTargetStream(stdout, stderr, args, numArgs - 2);
                if (logStream != null) {
                    ScpCommandMain.setupLogging(level, stdout, stderr, logStream);
                }
            }
            ScpLocation source = numArgs >= 2 ? new ScpLocation(args[numArgs - 2]) : null;
            ScpLocation target = numArgs >= 2 ? new ScpLocation(args[numArgs - 1]) : null;
            Set<ScpClient.Option> options = ScpCommandMain.parseCopyOptions(args);
            boolean quiet = false;
            boolean threeWay = false;
            for (int index = 0; index < numArgs; ++index) {
                String argName = args[index];
                if ("-q".equals(argName)) {
                    quiet = true;
                    continue;
                }
                if (!SCP_REMOTE_TO_REMOTE_OPTION.equals(argName)) continue;
                threeWay = true;
            }
            if (threeWay) {
                ScpCommandMain.xferRemoteToRemote(stdin, stdout, stderr, args, source, target, options, logStream, level, quiet);
            } else {
                ScpCommandMain.xferLocalToRemote(stdin, stdout, stderr, args, source, target, options, logStream, level, quiet);
            }
        }
        finally {
            if (logStream != stdout && logStream != stderr) {
                logStream.close();
            }
        }
    }
}

