/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.auth.UserAuthFactoriesManager;
import org.apache.sshd.common.auth.UserAuthInstance;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.config.LogLevelValue;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;

public abstract class CliSupport {
    public static final BuiltinIoServiceFactoryFactories DEFAULT_IO_SERVICE_FACTORY = BuiltinIoServiceFactoryFactories.NIO2;

    protected CliSupport() {
    }

    public static boolean showError(PrintStream stderr, String message) {
        stderr.append("ERROR: ").println(message);
        return true;
    }

    public static boolean isEnabledVerbosityLogging(Level level) {
        return level != null && !Level.OFF.equals(level) && !Level.CONFIG.equals(level) && !Level.SEVERE.equals(level) && !Level.WARNING.equals(level);
    }

    public static <S extends SessionContext, M extends UserAuthInstance<S>, F extends UserAuthMethodFactory<S, M>, I extends UserAuthFactoriesManager<S, M, F>> void setupUserAuthFactories(I manager, PropertyResolver options) {
        String methods = options.getString("PreferredAuthentications");
        if (GenericUtils.isNotEmpty((CharSequence)methods)) {
            manager.setUserAuthFactoriesNameList(methods);
            return;
        }
    }

    public static BuiltinIoServiceFactoryFactories resolveIoServiceFactory(PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length((Object[])args);
        BuiltinIoServiceFactoryFactories factory = null;
        for (int index = 0; index < numArgs; ++index) {
            String argName = args[index];
            if (!"-io".equals(argName)) continue;
            if (factory != null) {
                stderr.println("I/O factory re-specified - already set as " + factory);
                return null;
            }
            if (++index >= numArgs) {
                stderr.println("option requires an argument: " + argName);
                return null;
            }
            String provider = args[index];
            factory = CliSupport.resolveBuiltinIoServiceFactory(stderr, argName, provider);
            if (factory != null) continue;
            return null;
        }
        if (factory == null) {
            factory = DEFAULT_IO_SERVICE_FACTORY;
        }
        System.setProperty(IoServiceFactoryFactory.class.getName(), factory.getFactoryClassName());
        return factory;
    }

    public static BuiltinIoServiceFactoryFactories resolveBuiltinIoServiceFactory(PrintStream stderr, String argName, String provider) {
        BuiltinIoServiceFactoryFactories factory = BuiltinIoServiceFactoryFactories.fromFactoryName((String)provider);
        if (factory == null) {
            System.err.println(argName + " - unknown provider (" + provider + ") should be one of " + BuiltinIoServiceFactoryFactories.VALUES);
        }
        return factory;
    }

    public static <M extends AbstractFactoryManager> M setupIoServiceFactory(M manager, PropertyResolver resolver, Level level, PrintStream stdout, PrintStream stderr, String ... args) {
        BuiltinIoServiceFactoryFactories factory = CliSupport.resolveIoServiceFactory(stderr, args);
        if (factory == null) {
            return null;
        }
        manager.setIoServiceFactoryFactory(factory.create());
        if (!CliSupport.isEnabledVerbosityLogging(level)) {
            return manager;
        }
        PrintStream out = Level.INFO.equals(level) ? stderr : stdout;
        manager.setIoServiceEventListener(CliSupport.createLoggingIoServiceEventListener(out));
        manager.addSessionListener(CliSupport.createLoggingSessionListener(out));
        return manager;
    }

    public static void printStackTrace(Appendable out, Throwable reason) {
        if (reason == null || out == null) {
            return;
        }
        if (out instanceof PrintStream) {
            reason.printStackTrace((PrintStream)out);
        } else if (out instanceof PrintWriter) {
            reason.printStackTrace((PrintWriter)out);
        }
    }

    public static IoServiceEventListener createLoggingIoServiceEventListener(final Appendable out) {
        return new IoServiceEventListener(){

            public void connectionEstablished(IoConnector connector, SocketAddress local, AttributeRepository context, SocketAddress remote) throws IOException {
                out.append("Connection established via ").append(Objects.toString(connector)).append("- local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(System.lineSeparator());
            }

            public void abortEstablishedConnection(IoConnector connector, SocketAddress local, AttributeRepository context, SocketAddress remote, Throwable reason) throws IOException {
                out.append("Abort established connection ").append(Objects.toString(connector)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(": (").append(reason.getClass().getSimpleName()).append(')').append(' ').append(reason.getMessage()).append(System.lineSeparator());
                CliSupport.printStackTrace(out, reason);
            }

            public void connectionAccepted(IoAcceptor acceptor, SocketAddress local, SocketAddress remote, SocketAddress service) throws IOException {
                out.append("Connection accepted via ").append(Objects.toString(acceptor)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(", service=").append(Objects.toString(service)).append(System.lineSeparator());
            }

            public void abortAcceptedConnection(IoAcceptor acceptor, SocketAddress local, SocketAddress remote, SocketAddress service, Throwable reason) throws IOException {
                out.append("Abort accepted connection ").append(Objects.toString(acceptor)).append(" - local=").append(Objects.toString(local)).append(", remote=").append(Objects.toString(remote)).append(", service=").append(Objects.toString(service)).append(": (").append(reason.getClass().getSimpleName()).append(')').append(' ').append(reason.getMessage()).append(System.lineSeparator());
                CliSupport.printStackTrace(out, reason);
            }
        };
    }

    public static SessionListener createLoggingSessionListener(final Appendable out) {
        return new SessionListener(){

            public void sessionPeerIdentificationReceived(Session session, String version, List<String> extraLines) {
                try {
                    out.append(Objects.toString(session)).append(" peer identification=").append(version).append(System.lineSeparator());
                    if (GenericUtils.isNotEmpty(extraLines)) {
                        for (String l : extraLines) {
                            out.append("    => ").append(l).append(System.lineSeparator());
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void sessionNegotiationEnd(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal, Map<KexProposalOption, String> negotiatedOptions, Throwable reason) {
                if (reason != null) {
                    return;
                }
                try {
                    out.append(Objects.toString(session)).append(" KEX negotiation results:").append(System.lineSeparator());
                    for (KexProposalOption opt : KexProposalOption.VALUES) {
                        String value = negotiatedOptions.get(opt);
                        out.append("    ").append(opt.getDescription()).append(": ").append(value).append(System.lineSeparator());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void sessionException(Session session, Throwable t) {
                try {
                    out.append(Objects.toString(session)).append(' ').append(t.getClass().getSimpleName()).append(": ").append(t.getMessage()).append(System.lineSeparator());
                    CliSupport.printStackTrace(out, t);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void sessionClosed(Session session) {
                try {
                    out.append(Objects.toString(session)).append(" closed").append(System.lineSeparator());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    public static Level resolveLoggingVerbosity(String ... args) {
        return CliSupport.resolveLoggingVerbosity(args, GenericUtils.length((Object[])args));
    }

    public static Level resolveLoggingVerbosity(String[] args, int maxIndex) {
        for (int index = 0; index < maxIndex; ++index) {
            String argName = args[index];
            if ("-v".equals(argName)) {
                return Level.INFO;
            }
            if ("-vv".equals(argName)) {
                return Level.FINE;
            }
            if (!"-vvv".equals(argName)) continue;
            return Level.FINEST;
        }
        return Level.CONFIG;
    }

    public static Level resolveLoggingVerbosity(PropertyResolver resolver, String ... args) {
        String levelValue = PropertyResolverUtils.getString((PropertyResolver)resolver, (String)"LogLevel");
        if (GenericUtils.isEmpty((CharSequence)levelValue)) {
            return CliSupport.resolveLoggingVerbosity(args);
        }
        LogLevelValue level = LogLevelValue.fromName((String)levelValue);
        if (level == null) {
            throw new IllegalArgumentException("Unknown LogLevel option value: " + levelValue);
        }
        return level.getLoggingLevel();
    }

    public static List<NamedFactory<Compression>> setupCompressions(PropertyResolver options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString((PropertyResolver)options, (String)"Compression");
        if (GenericUtils.isEmpty((CharSequence)argVal)) {
            return Collections.emptyList();
        }
        CompressionConfigValue value = CompressionConfigValue.fromName((String)argVal);
        if (value == null) {
            CliSupport.showError(stderr, "Unknown compression configuration value: " + argVal);
            return null;
        }
        return Collections.singletonList(value);
    }

    public static List<NamedFactory<Compression>> setupCompressions(String argName, String argVal, List<NamedFactory<Compression>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            CliSupport.showError(stderr, argName + " option value re-specified: " + NamedResource.getNames(current));
            return null;
        }
        BuiltinCompressions.ParseResult result = BuiltinCompressions.parseCompressionsList((String)argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty((Collection)available)) {
            CliSupport.showError(stderr, "No known compressions in " + argVal);
            return null;
        }
        List unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size((Collection)unsupported) > 0) {
            stderr.append("WARNING: Ignored unsupported compressions: ").println(GenericUtils.join((Iterable)unsupported, (char)','));
        }
        return new ArrayList<NamedFactory<Compression>>(available);
    }

    public static List<NamedFactory<Mac>> setupMacs(PropertyResolver options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString((PropertyResolver)options, (String)"MACs");
        return GenericUtils.isEmpty((CharSequence)argVal) ? Collections.emptyList() : CliSupport.setupMacs("MACs", argVal, null, stderr);
    }

    public static List<NamedFactory<Mac>> setupMacs(String argName, String argVal, List<NamedFactory<Mac>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            CliSupport.showError(stderr, argName + " option value re-specified: " + NamedResource.getNames(current));
            return null;
        }
        BuiltinMacs.ParseResult result = BuiltinMacs.parseMacsList((String)argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty((Collection)available)) {
            CliSupport.showError(stderr, "No known MACs in " + argVal);
            return null;
        }
        List unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size((Collection)unsupported) > 0) {
            stderr.append("WARNING: Ignored unsupported MACs: ").println(GenericUtils.join((Iterable)unsupported, (char)','));
        }
        return new ArrayList<NamedFactory<Mac>>(available);
    }

    public static List<NamedFactory<Cipher>> setupCiphers(PropertyResolver options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString((PropertyResolver)options, (String)"Ciphers");
        return GenericUtils.isEmpty((CharSequence)argVal) ? Collections.emptyList() : CliSupport.setupCiphers("Ciphers", argVal, null, stderr);
    }

    public static List<NamedFactory<Cipher>> setupCiphers(String argName, String argVal, List<NamedFactory<Cipher>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            CliSupport.showError(stderr, argName + " option value re-specified: " + NamedResource.getNames(current));
            return null;
        }
        BuiltinCiphers.ParseResult result = BuiltinCiphers.parseCiphersList((String)argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty((Collection)available)) {
            CliSupport.showError(stderr, "WARNING: No known ciphers in " + argVal);
            return null;
        }
        List unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size((Collection)unsupported) > 0) {
            stderr.append("WARNING: Ignored unsupported ciphers: ").println(GenericUtils.join((Iterable)unsupported, (char)','));
        }
        return new ArrayList<NamedFactory<Cipher>>(available);
    }
}

