/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.mina;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;
import org.apache.sshd.mina.MinaService;
import org.apache.sshd.mina.MinaSupport;

public class MinaSession
extends AbstractInnerCloseable
implements IoSession {
    public static final Field NIO_SESSION_CHANNEL_FIELD = Stream.of(NioSession.class.getDeclaredFields()).filter(f -> "channel".equals(f.getName())).map(f -> {
        f.setAccessible(true);
        return f;
    }).findFirst().orElse(null);
    private final MinaService service;
    private final org.apache.mina.core.session.IoSession session;
    private final Object sessionWriteId;
    private final SocketAddress acceptanceAddress;

    public MinaSession(MinaService service, org.apache.mina.core.session.IoSession session, SocketAddress acceptanceAddress) {
        this.service = service;
        this.session = session;
        this.sessionWriteId = Objects.toString(session);
        this.acceptanceAddress = acceptanceAddress;
    }

    public org.apache.mina.core.session.IoSession getSession() {
        return this.session;
    }

    public void suspend() {
        this.session.suspendRead();
        this.session.suspendWrite();
    }

    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.session.setAttribute(key, value);
    }

    public Object setAttributeIfAbsent(Object key, Object value) {
        return this.session.setAttributeIfAbsent(key, value);
    }

    public Object removeAttribute(Object key) {
        return this.session.removeAttribute(key);
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public long getId() {
        return this.session.getId();
    }

    protected Closeable getInnerCloseable() {
        return new IoBaseCloseable(){
            private final DefaultCloseFuture future;
            {
                this.future = new DefaultCloseFuture((Object)MinaSession.this.toString(), MinaSession.this.futureLock);
            }

            public boolean isClosing() {
                return MinaSession.this.session.isClosing();
            }

            public boolean isClosed() {
                return !MinaSession.this.session.isConnected();
            }

            public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
                this.future.addListener(listener);
            }

            public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
                this.future.removeListener(listener);
            }

            public CloseFuture close(boolean immediately) {
                org.apache.mina.core.future.CloseFuture cf = immediately ? MinaSession.this.session.closeNow() : MinaSession.this.session.closeOnFlush();
                cf.addListener(f -> this.future.setValue((Object)Boolean.TRUE));
                return this.future;
            }
        };
    }

    public IoWriteFuture write(byte[] data) {
        return this.write(data, 0, NumberUtils.length((byte[])data));
    }

    public IoWriteFuture write(byte[] data, int offset, int len) {
        return this.write(IoBuffer.wrap((byte[])data, (int)offset, (int)len));
    }

    public IoWriteFuture writeBuffer(Buffer buffer) {
        return this.write(MinaSupport.asIoBuffer(buffer));
    }

    public IoWriteFuture write(IoBuffer buffer) {
        Future future = new Future(this.sessionWriteId, null);
        this.session.write((Object)buffer).addListener(cf -> {
            Throwable t = cf.getException();
            if (t != null) {
                future.setException(t);
            } else {
                future.setWritten();
            }
        });
        return future;
    }

    public IoService getService() {
        return this.service;
    }

    public void shutdownOutputStream() throws IOException {
        Channel channel;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!(this.session instanceof NioSession)) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({}) not a NioSession: {}", (Object)this.session, this.session == null ? null : this.session.getClass().getSimpleName());
            }
            return;
        }
        if (NIO_SESSION_CHANNEL_FIELD == null) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({}) missing channel field", (Object)this.session, this.session == null ? null : this.session.getClass().getSimpleName());
            }
            return;
        }
        try {
            channel = (Channel)NIO_SESSION_CHANNEL_FIELD.get(this.session);
        }
        catch (Exception t) {
            Throwable e = GenericUtils.peelException((Throwable)t);
            this.log.warn("shudownOutputStream({}) failed ({}) to retrieve embedded channel: {}", new Object[]{this.session, e.getClass().getSimpleName(), e.getMessage()});
            return;
        }
        if (!(channel instanceof SocketChannel)) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({}) not a SocketChannel: {}", (Object)this.session, channel == null ? null : channel.getClass().getSimpleName());
            }
            return;
        }
        Socket socket = ((SocketChannel)channel).socket();
        if (socket.isConnected() && !socket.isClosed()) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({})", (Object)this.session);
            }
            socket.shutdownOutput();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[local=" + this.session.getLocalAddress() + ", remote=" + this.session.getRemoteAddress() + "]";
    }

    public static class Future
    extends AbstractIoWriteFuture {
        public Future(Object id, Object lock) {
            super(id, lock);
        }

        public void setWritten() {
            this.setValue(Boolean.TRUE);
        }

        public void setException(Throwable exception) {
            this.setValue(Objects.requireNonNull(exception, "No exception specified"));
        }
    }
}

