/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.lang.Nullable;

public class AcceptOnceFileListFilter<F>
extends AbstractFileListFilter<F>
implements ReversibleFileListFilter<F>,
ResettableFileListFilter<F> {
    @Nullable
    private final Queue<F> seen;
    private final Set<F> seenSet = new HashSet<F>();
    private final Object monitor = new Object();

    public AcceptOnceFileListFilter(int maxCapacity) {
        this.seen = new LinkedBlockingQueue<F>(maxCapacity);
    }

    public AcceptOnceFileListFilter() {
        this.seen = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(F file) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.seenSet.contains(file)) {
                return false;
            }
            if (this.seen != null && !this.seen.offer(file)) {
                F removed = this.seen.poll();
                this.seenSet.remove(removed);
                this.seen.add(file);
            }
            this.seenSet.add(file);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(F file, List<F> files) {
        Object object = this.monitor;
        synchronized (object) {
            boolean rollingBack = false;
            for (F fileToRollback : files) {
                if (fileToRollback.equals(file)) {
                    rollingBack = true;
                }
                if (!rollingBack) continue;
                this.remove(fileToRollback);
            }
        }
    }

    @Override
    public boolean remove(F fileToRemove) {
        boolean removed = this.seenSet.remove(fileToRemove);
        if (this.seen != null) {
            this.seen.remove(fileToRemove);
        }
        return removed;
    }
}

