/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.config.AllowTcpForwardingValue;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;

public final class SshServerConfigFileReader {
    public static final Property<String> ALLOW_TCP_FORWARDING_CONFIG_PROP = Property.string((String)"AllowTcpForwarding", (String)"yes");
    public static final Property<String> ALLOW_AGENT_FORWARDING_CONFIG_PROP = Property.string((String)"AllowAgentForwarding", (String)"yes");
    public static final Property<String> ALLOW_X11_FORWARDING_CONFIG_PROP = Property.string((String)"X11Forwarding", (String)"no");
    public static final Property<String> BANNER_CONFIG_PROP = Property.string((String)"Banner");
    public static final Property<String> VISUAL_HOST_KEY = Property.string((String)"VisualHostKey", (String)"no");
    public static final Property<Duration> SERVER_ALIVE_INTERVAL_PROP = Property.duration((String)"ServerAliveInterval");
    public static final Property<Integer> SFTP_FORCED_VERSION_PROP = Property.integer((String)"sftp-version");

    private SshServerConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static <S extends ServerFactoryManager> S setupServerHeartbeat(S server, PropertyResolver props) {
        if (server == null || props == null) {
            return server;
        }
        Duration interval = (Duration)SERVER_ALIVE_INTERVAL_PROP.getOrNull(props);
        if (interval == null || GenericUtils.isNegativeOrNull((Duration)interval)) {
            return server;
        }
        server.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, interval);
        return server;
    }

    public static <S extends ServerFactoryManager> S setupServerHeartbeat(S server, Map<String, ?> options) {
        if (server == null || GenericUtils.isEmpty(options)) {
            return server;
        }
        return SshServerConfigFileReader.setupServerHeartbeat(server, PropertyResolverUtils.toPropertyResolver(options));
    }

    public static <S extends ServerFactoryManager> S setupSftpSubsystem(S server, PropertyResolver props) {
        if (server == null || props == null) {
            return server;
        }
        Integer version = (Integer)SFTP_FORCED_VERSION_PROP.getOrNull(props);
        if (version != null && version >= 0) {
            SFTP_FORCED_VERSION_PROP.set(server, (Object)version);
        }
        return server;
    }

    public static <S extends SshServer> S configure(S server, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configure(server, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureKeyExchanges(server, props, lenient, ServerBuilder.DH2KEX, ignoreUnsupported);
        SshServerConfigFileReader.setupServerHeartbeat(server, props);
        return server;
    }

    public static ForwardingFilter resolveServerForwarding(PropertyResolver options) {
        if (GenericUtils.isEmpty((Object[])new PropertyResolver[]{options})) {
            return AcceptAllForwardingFilter.INSTANCE;
        }
        AgentForwardingFilter agentFilter = SshServerConfigFileReader.resolveAgentForwardingFilter(options);
        TcpForwardingFilter tcpFilter = SshServerConfigFileReader.resolveTcpForwardingFilter(options);
        X11ForwardingFilter x11Filter = SshServerConfigFileReader.resolveX11ForwardingFilter(options);
        return ForwardingFilter.asForwardingFilter(agentFilter, x11Filter, tcpFilter);
    }

    public static AgentForwardingFilter resolveAgentForwardingFilter(PropertyResolver options) {
        String value = (String)ALLOW_AGENT_FORWARDING_CONFIG_PROP.getRequired(options);
        return AgentForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue((String)value));
    }

    public static TcpForwardingFilter resolveTcpForwardingFilter(PropertyResolver options) {
        String value = (String)ALLOW_TCP_FORWARDING_CONFIG_PROP.getRequired(options);
        AllowTcpForwardingValue filter = AllowTcpForwardingValue.fromString(value);
        ValidateUtils.checkNotNull((Object)filter, (String)"Unknown %s value: %s", (Object[])new Object[]{ALLOW_TCP_FORWARDING_CONFIG_PROP, value});
        return filter;
    }

    public static X11ForwardingFilter resolveX11ForwardingFilter(PropertyResolver options) {
        String value = (String)ALLOW_X11_FORWARDING_CONFIG_PROP.getRequired(options);
        return X11ForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue((String)value));
    }

    public static Object resolveBanner(PropertyResolver options) {
        String bannerOption = (String)BANNER_CONFIG_PROP.getOrNull(options);
        if (GenericUtils.isEmpty((CharSequence)bannerOption)) {
            bannerOption = (String)VISUAL_HOST_KEY.getRequired(options);
            bannerOption = ConfigFileReaderSupport.parseBooleanValue((String)bannerOption) ? "#auto-welcome-banner" : null;
        }
        if (GenericUtils.isEmpty((CharSequence)bannerOption)) {
            return "Welcome to SSHD\n";
        }
        if (PropertyResolverUtils.isNoneValue((String)bannerOption)) {
            return null;
        }
        if ("#auto-welcome-banner".equalsIgnoreCase(bannerOption)) {
            return bannerOption;
        }
        if (bannerOption != null) {
            return Paths.get(bannerOption, new String[0]);
        }
        return null;
    }
}

