/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.security.KeyPair;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.BuiltinUserAuthFactories;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.auth.UserAuthFactoriesManager;
import org.apache.sshd.common.keyprovider.KeyIdentityProviderHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface ClientAuthenticationManager
extends UserAuthFactoriesManager<ClientSession, UserAuth, UserAuthFactory>,
KeyIdentityProviderHolder {
    public AuthenticationIdentitiesProvider getRegisteredIdentities();

    public PasswordIdentityProvider getPasswordIdentityProvider();

    public void setPasswordIdentityProvider(PasswordIdentityProvider var1);

    public void addPasswordIdentity(String var1);

    public String removePasswordIdentity(String var1);

    public void addPublicKeyIdentity(KeyPair var1);

    public KeyPair removePublicKeyIdentity(KeyPair var1);

    public ServerKeyVerifier getServerKeyVerifier();

    public void setServerKeyVerifier(ServerKeyVerifier var1);

    public UserInteraction getUserInteraction();

    public void setUserInteraction(UserInteraction var1);

    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List factories = (List)ValidateUtils.checkNotNullAndNotEmpty((Collection)result.getParsedFactories(), (String)"No supported user authentication factories: %s", (Object[])new Object[]{names});
        List unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue((boolean)GenericUtils.isEmpty((Collection)unsupported), (String)"Unsupported user authentication factories found: %s", (Object)unsupported);
        this.setUserAuthFactories(factories);
    }
}

