/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.ExposedBufferByteArrayOutputStream;

public class DeflatingInputStream
extends InputStream {
    private ExposedBufferByteArrayOutputStream baos;
    private int readPos;
    private InputStream inputStream;
    private OutputStream compressor;
    private final byte[] readBuf = new byte[8192];
    private final byte[] oneByte = new byte[1];

    public DeflatingInputStream(InputStream inputStream, ExposedBufferByteArrayOutputStream baos, OutputStream compressor) {
        this.inputStream = Objects.requireNonNull(inputStream, "No initial input stream");
        this.baos = Objects.requireNonNull(baos, "No buffering output stream");
        this.compressor = Objects.requireNonNull(compressor, "No compressor stream");
    }

    @Override
    public int read() throws IOException {
        int readLen = this.read(this.oneByte);
        if (readLen < 0) {
            return -1;
        }
        return this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int curOffset = off;
        int maxOffset = off + len;
        int remainLen = len;
        while (remainLen > 0 && curOffset < maxOffset) {
            int count = this.baos.size();
            int available = count - this.readPos;
            int copyLen = Math.min(available, remainLen);
            if (copyLen > 0) {
                byte[] compressedData = this.baos.getBuffer();
                System.arraycopy(compressedData, this.readPos, buf, curOffset, copyLen);
                this.readPos += copyLen;
                curOffset += copyLen;
                remainLen -= copyLen;
                continue;
            }
            int readLen = this.fillCompressedBuffer();
            if (readLen >= 0) continue;
            if (curOffset > off) break;
            return -1;
        }
        return curOffset - off;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new StreamCorruptedException("Not possible to skip compressed stream " + n + " bytes");
    }

    @Override
    public int available() throws IOException {
        int readLen;
        do {
            int count;
            int available;
            if ((available = (count = this.baos.size()) - this.readPos) <= 0) continue;
            return available;
        } while ((readLen = this.fillCompressedBuffer()) >= 0);
        return 0;
    }

    protected int fillCompressedBuffer() throws IOException {
        int readLen = this.inputStream.read(this.readBuf);
        this.baos.reset();
        this.readPos = 0;
        if (readLen < 0) {
            this.compressor.flush();
            this.compressor.close();
            int count = this.baos.size();
            if (count > 0) {
                return count;
            }
            return -1;
        }
        this.compressor.write(this.readBuf, 0, readLen);
        return readLen;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark(" + readlimit + ") N/A");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new StreamCorruptedException("Not possible to reset compressed stream");
    }

    @Override
    public void close() throws IOException {
        IOException err = null;
        try {
            this.compressor.close();
        }
        catch (IOException e) {
            err = (IOException)GenericUtils.accumulateException(err, (Throwable)e);
        }
        try {
            this.baos.close();
        }
        catch (IOException e) {
            err = (IOException)GenericUtils.accumulateException((Throwable)err, (Throwable)e);
        }
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            err = (IOException)GenericUtils.accumulateException((Throwable)err, (Throwable)e);
        }
        try {
            super.close();
        }
        catch (IOException e) {
            err = (IOException)GenericUtils.accumulateException((Throwable)err, (Throwable)e);
        }
        if (err != null) {
            throw err;
        }
    }
}

