/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.openpgp.PGPKeyLoader;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.bouncycastle.openpgp.PGPException;
import org.c02e.jpgpj.Key;

public class PGPPublicKeyFileWatcher
extends ModifiableFileWatcher {
    protected final AtomicReference<Key> keyHolder = new AtomicReference<Object>(null);

    public PGPPublicKeyFileWatcher(Path file) {
        this(file, IoUtils.getLinkOptions((boolean)false));
    }

    public PGPPublicKeyFileWatcher(Path file, LinkOption ... options) {
        super(file, options);
    }

    public Key loadPublicKey(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException, PGPException {
        Key key = this.keyHolder.get();
        if (key == null || this.checkReloadRequired()) {
            this.keyHolder.set(null);
            if (!this.exists()) {
                return null;
            }
            Path path = this.getPath();
            key = this.reloadPublicKey(session, (IoResource<?>)new PathResource(path), passwordProvider);
            if (key != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("loadPublicKey({})[{}] loaded from {}: {}", new Object[]{session, resourceKey, path, key});
                }
                this.keyHolder.set(key);
                this.updateReloadAttributes();
            }
        }
        return key;
    }

    protected Key reloadPublicKey(SessionContext session, IoResource<?> resourceKey, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException, PGPException {
        Key key;
        String password = passwordProvider == null ? null : passwordProvider.getPassword(session, resourceKey, 0);
        try (InputStream input = resourceKey.openInputStream();){
            key = PGPKeyLoader.loadPGPKey(input, password);
        }
        return key == null ? null : key.toPublicKey();
    }
}

