/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.splitter;

import java.util.Collection;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

abstract class AbstractMessageProcessingSplitter
extends AbstractMessageSplitter
implements Lifecycle {
    private final MessageProcessor<Collection<?>> messageProcessor;

    protected AbstractMessageProcessingSplitter(MessageProcessor<Collection<?>> expressionEvaluatingMessageProcessor) {
        Assert.notNull(expressionEvaluatingMessageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = expressionEvaluatingMessageProcessor;
    }

    @Override
    protected void doInit() {
        ConversionService conversionService = this.getConversionService();
        if (conversionService != null && this.messageProcessor instanceof AbstractMessageProcessor) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(conversionService);
        }
        if (this.messageProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(this.getBeanFactory());
        }
    }

    @Override
    protected final Object splitMessage(Message<?> message) {
        return this.messageProcessor.processMessage(message);
    }

    public void start() {
        if (this.messageProcessor instanceof Lifecycle) {
            ((Lifecycle)this.messageProcessor).start();
        }
    }

    public void stop() {
        if (this.messageProcessor instanceof Lifecycle) {
            ((Lifecycle)this.messageProcessor).stop();
        }
    }

    public boolean isRunning() {
        return !(this.messageProcessor instanceof Lifecycle) || ((Lifecycle)this.messageProcessor).isRunning();
    }
}

