/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.integration.IntegrationPattern;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.support.management.AbstractMessageHandlerMetrics;
import org.springframework.integration.support.management.ConfigurableMetricsAware;
import org.springframework.integration.support.management.DefaultMessageHandlerMetrics;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.integration.support.management.IntegrationManagement;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.Statistics;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.integration.support.management.metrics.MeterFacade;
import org.springframework.integration.support.management.metrics.MetricsCaptor;
import org.springframework.integration.support.management.metrics.TimerFacade;
import org.springframework.util.Assert;

@IntegrationManagedResource
public abstract class MessageHandlerSupport
extends IntegrationObjectSupport
implements MessageHandlerMetrics,
ConfigurableMetricsAware<AbstractMessageHandlerMetrics>,
TrackableComponent,
Orderable,
IntegrationPattern {
    private final IntegrationManagement.ManagementOverrides managementOverrides = new IntegrationManagement.ManagementOverrides();
    private final Set<TimerFacade> timers = ConcurrentHashMap.newKeySet();
    private boolean shouldTrack = false;
    private AbstractMessageHandlerMetrics handlerMetrics = new DefaultMessageHandlerMetrics();
    private boolean countsEnabled;
    private boolean loggingEnabled = true;
    private MetricsCaptor metricsCaptor;
    private int order = Integer.MAX_VALUE;
    private boolean statsEnabled;
    private String managedName;
    private String managedType;
    private TimerFacade successTimer;

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        this.managementOverrides.loggingConfigured = true;
    }

    @Override
    public void registerMetricsCaptor(MetricsCaptor metricsCaptorToRegister) {
        this.metricsCaptor = metricsCaptorToRegister;
    }

    @Deprecated
    protected AbstractMessageHandlerMetrics getHandlerMetrics() {
        return this.handlerMetrics;
    }

    protected MetricsCaptor getMetricsCaptor() {
        return this.metricsCaptor;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public String getComponentType() {
        return "message-handler";
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    protected boolean shouldTrack() {
        return this.shouldTrack;
    }

    @Override
    @Deprecated
    public void configureMetrics(AbstractMessageHandlerMetrics metrics) {
        Assert.notNull((Object)metrics, (String)"'metrics' must not be null");
        this.handlerMetrics = metrics;
        this.managementOverrides.metricsConfigured = true;
    }

    @Override
    public IntegrationManagement.ManagementOverrides getOverrides() {
        return this.managementOverrides;
    }

    @Override
    public IntegrationPatternType getIntegrationPatternType() {
        return IntegrationPatternType.outbound_channel_adapter;
    }

    @Override
    protected void onInit() {
        if (this.statsEnabled) {
            this.handlerMetrics.setFullStatsEnabled(true);
        }
    }

    protected TimerFacade sendTimer() {
        if (this.successTimer == null) {
            this.successTimer = this.buildSendTimer(true, "none");
        }
        return this.successTimer;
    }

    protected TimerFacade buildSendTimer(boolean success, String exception) {
        TimerFacade timer = this.metricsCaptor.timerBuilder("spring.integration.send").tag("type", "handler").tag("name", this.getComponentName() == null ? "unknown" : this.getComponentName()).tag("result", success ? "success" : "failure").tag("exception", exception).description("Send processing time").build();
        this.timers.add(timer);
        return timer;
    }

    @Override
    @Deprecated
    public void reset() {
        this.handlerMetrics.reset();
    }

    @Override
    @Deprecated
    public long getHandleCountLong() {
        return this.handlerMetrics.getHandleCountLong();
    }

    @Override
    @Deprecated
    public int getHandleCount() {
        return this.handlerMetrics.getHandleCount();
    }

    @Override
    @Deprecated
    public int getErrorCount() {
        return this.handlerMetrics.getErrorCount();
    }

    @Override
    @Deprecated
    public long getErrorCountLong() {
        return this.handlerMetrics.getErrorCountLong();
    }

    @Override
    @Deprecated
    public double getMeanDuration() {
        return this.handlerMetrics.getMeanDuration();
    }

    @Override
    @Deprecated
    public double getMinDuration() {
        return this.handlerMetrics.getMinDuration();
    }

    @Override
    @Deprecated
    public double getMaxDuration() {
        return this.handlerMetrics.getMaxDuration();
    }

    @Override
    @Deprecated
    public double getStandardDeviationDuration() {
        return this.handlerMetrics.getStandardDeviationDuration();
    }

    @Override
    @Deprecated
    public int getActiveCount() {
        return this.handlerMetrics.getActiveCount();
    }

    @Override
    @Deprecated
    public long getActiveCountLong() {
        return this.handlerMetrics.getActiveCountLong();
    }

    @Override
    @Deprecated
    public Statistics getDuration() {
        return this.handlerMetrics.getDuration();
    }

    @Override
    @Deprecated
    public void setStatsEnabled(boolean statsEnabled) {
        if (statsEnabled) {
            this.countsEnabled = true;
            this.managementOverrides.countsConfigured = true;
        }
        this.statsEnabled = statsEnabled;
        if (this.handlerMetrics != null) {
            this.handlerMetrics.setFullStatsEnabled(statsEnabled);
        }
        this.managementOverrides.statsConfigured = true;
    }

    @Override
    @Deprecated
    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    @Override
    @Deprecated
    public void setCountsEnabled(boolean countsEnabled) {
        this.countsEnabled = countsEnabled;
        this.managementOverrides.countsConfigured = true;
        if (!countsEnabled) {
            this.statsEnabled = false;
            this.managementOverrides.statsConfigured = true;
        }
    }

    @Override
    @Deprecated
    public boolean isCountsEnabled() {
        return this.countsEnabled;
    }

    @Override
    public void setManagedName(String managedName) {
        this.managedName = managedName;
    }

    @Override
    public String getManagedName() {
        return this.managedName;
    }

    @Override
    public void setManagedType(String managedType) {
        this.managedType = managedType;
    }

    @Override
    public String getManagedType() {
        return this.managedType;
    }

    @Override
    public void destroy() {
        this.timers.forEach(MeterFacade::remove);
        this.timers.clear();
    }
}

