/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.putty;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class PuttyKeyReader
implements Closeable {
    private final DataInputStream di;

    public PuttyKeyReader(InputStream s) {
        this.di = new DataInputStream(s);
    }

    public void skip() throws IOException {
        int effectiveSkip;
        int skipSize = this.di.readInt();
        if (skipSize != (effectiveSkip = this.di.skipBytes(skipSize))) {
            throw new StreamCorruptedException("Mismatched skip size: expected" + skipSize + ", actual=" + effectiveSkip);
        }
    }

    public String readString() throws IOException {
        return this.readString(StandardCharsets.UTF_8);
    }

    public String readString(Charset cs) throws IOException {
        byte[] data = this.read(Short.MAX_VALUE);
        return new String(data, cs);
    }

    public BigInteger readInt() throws IOException {
        byte[] bytes = this.read(Short.MAX_VALUE);
        return new BigInteger(bytes);
    }

    public byte[] read(int maxAllowed) throws IOException {
        int len = this.di.readInt();
        if (len > maxAllowed) {
            throw new StreamCorruptedException("Requested block length (" + len + ") exceeds max. allowed (" + maxAllowed + ")");
        }
        if (len < 0) {
            throw new StreamCorruptedException("Negative block length requested: " + len);
        }
        byte[] r = new byte[len];
        this.di.readFully(r);
        return r;
    }

    @Override
    public void close() throws IOException {
        this.di.close();
    }
}

