/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Strings;
import org.c02e.jpgpj.CompressionAlgorithm;
import org.c02e.jpgpj.EncryptionAlgorithm;
import org.c02e.jpgpj.FileMetadata;
import org.c02e.jpgpj.HashingAlgorithm;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.Ring;
import org.c02e.jpgpj.Subkey;
import org.c02e.jpgpj.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encryptor {
    protected boolean asciiArmored;
    protected int compressionLevel = 6;
    protected CompressionAlgorithm compressionAlgorithm;
    protected EncryptionAlgorithm encryptionAlgorithm;
    protected HashingAlgorithm signingAlgorithm;
    protected char[] symmetricPassphraseChars;
    protected String symmetricPassphrase;
    protected HashingAlgorithm keyDerivationAlgorithm;
    protected int keyDerivationWorkFactor;
    protected int maxFileBufferSize = 0x100000;
    protected Ring ring;
    protected Logger log = LoggerFactory.getLogger((String)Encryptor.class.getName());

    public Encryptor() {
        this.compressionAlgorithm = CompressionAlgorithm.ZLIB;
        this.encryptionAlgorithm = EncryptionAlgorithm.AES128;
        this.signingAlgorithm = HashingAlgorithm.SHA256;
        this.setSymmetricPassphraseChars(null);
        this.keyDerivationAlgorithm = HashingAlgorithm.SHA512;
        this.keyDerivationWorkFactor = 255;
        this.ring = new Ring();
    }

    public Encryptor(Ring ring) {
        this();
        this.setRing(ring);
    }

    public Encryptor(Key ... keys) {
        this(new Ring(keys));
    }

    public boolean isAsciiArmored() {
        return this.asciiArmored;
    }

    public void setAsciiArmored(boolean x) {
        this.asciiArmored = x;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int x) {
        this.compressionLevel = x;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(CompressionAlgorithm x) {
        this.compressionAlgorithm = x != null ? x : CompressionAlgorithm.Uncompressed;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm x) {
        this.encryptionAlgorithm = x != null ? x : EncryptionAlgorithm.Unencrypted;
    }

    public HashingAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(HashingAlgorithm x) {
        this.signingAlgorithm = x != null ? x : HashingAlgorithm.Unsigned;
    }

    public char[] getSymmetricPassphraseChars() {
        return this.symmetricPassphraseChars;
    }

    public void setSymmetricPassphraseChars(char[] x) {
        if (x == null) {
            x = new char[]{};
        }
        if (!Arrays.equals(x, this.symmetricPassphraseChars)) {
            this.symmetricPassphraseChars = x;
            this.symmetricPassphrase = null;
        }
    }

    public String getSymmetricPassphrase() {
        if (this.symmetricPassphrase == null) {
            this.symmetricPassphrase = new String(this.symmetricPassphraseChars);
        }
        return this.symmetricPassphrase;
    }

    public void setSymmetricPassphrase(String x) {
        this.setSymmetricPassphraseChars(x != null ? x.toCharArray() : null);
        this.symmetricPassphrase = x;
    }

    public HashingAlgorithm getKeyDeriviationAlgorithm() {
        return this.keyDerivationAlgorithm;
    }

    public void setKeyDeriviationAlgorithm(HashingAlgorithm x) {
        this.keyDerivationAlgorithm = x != null ? x : HashingAlgorithm.Unsigned;
    }

    public int getKeyDeriviationWorkFactor() {
        return this.keyDerivationWorkFactor;
    }

    public void setKeyDeriviationWorkFactor(int x) {
        this.keyDerivationWorkFactor = x;
    }

    public int getMaxFileBufferSize() {
        return this.maxFileBufferSize;
    }

    public void setMaxFileBufferSize(int maxFileBufferSize) {
        this.maxFileBufferSize = maxFileBufferSize;
    }

    public Ring getRing() {
        return this.ring;
    }

    protected void setRing(Ring x) {
        this.ring = x != null ? x : new Ring();
    }

    public void clearSecrets() {
        this.ring.clearSecrets();
        Arrays.fill(this.symmetricPassphraseChars, '\u0000');
        this.symmetricPassphraseChars = new char[0];
        this.symmetricPassphrase = null;
    }

    public void encrypt(File plaintext, File ciphertext) throws IOException, PGPException {
        if (plaintext.equals(ciphertext)) {
            throw new IOException("cannot encrypt " + plaintext + " over itself");
        }
        ciphertext.delete();
        InputStream input = null;
        OutputStream output = null;
        try {
            int bestFileBufferSize = Util.bestFileBufferSize(plaintext.length(), this.maxFileBufferSize);
            input = new BufferedInputStream(new FileInputStream(plaintext), bestFileBufferSize);
            output = new BufferedOutputStream(new FileOutputStream(ciphertext), this.estimateOutFileSize(plaintext.length()));
            this.encrypt(input, output, new FileMetadata(plaintext));
        }
        catch (Exception e) {
            if (output != null) {
                try {
                    output.close();
                    ciphertext.delete();
                }
                catch (Exception ee) {
                    this.log.error("failed to delete bad output file {}", (Object)plaintext, (Object)ee);
                }
            }
            throw e;
        }
        finally {
            try {
                output.close();
            }
            catch (Exception exception) {}
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public void encrypt(InputStream plaintext, OutputStream ciphertext) throws IOException, PGPException {
        this.encrypt(plaintext, ciphertext, null);
    }

    public void encrypt(InputStream plaintext, OutputStream ciphertext, FileMetadata meta) throws IOException, PGPException {
        if (meta == null) {
            meta = new FileMetadata();
        }
        ArrayList<OutputStream> stack = new ArrayList<OutputStream>(6);
        stack.add(ciphertext);
        ciphertext = this.pipeline(this.armor(ciphertext), stack);
        ciphertext = this.pipeline(this.encrypt(ciphertext, meta), stack);
        ciphertext = this.pipeline(this.compress(ciphertext, meta), stack);
        SigningOutputStream signingstream = this.sign(ciphertext, meta);
        ciphertext = this.pipeline(signingstream, stack);
        ciphertext = this.pipeline(this.packet(ciphertext, meta), stack);
        this.copy(plaintext, ciphertext, signingstream, meta);
        for (int i = stack.size() - 1; i > 0; --i) {
            stack.get(i).close();
        }
    }

    protected OutputStream pipeline(OutputStream out, List<OutputStream> stack) {
        if (out == null) {
            return stack.get(stack.size() - 1);
        }
        stack.add(out);
        return out;
    }

    protected OutputStream armor(OutputStream out) {
        if (this.asciiArmored) {
            return new ArmoredOutputStream(out);
        }
        return null;
    }

    protected OutputStream encrypt(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        this.log.trace("using encryption algorithm {}", (Object)this.encryptionAlgorithm);
        if (this.encryptionAlgorithm == EncryptionAlgorithm.Unencrypted) {
            return null;
        }
        List<Key> keys = this.ring.getEncryptionKeys();
        if (Util.isEmpty(keys) && Util.isEmpty(this.symmetricPassphraseChars)) {
            throw new PGPException("no suitable encryption key found");
        }
        PGPEncryptedDataGenerator generator = this.buildEncryptor();
        for (Key key : keys) {
            generator.addMethod((PGPKeyEncryptionMethodGenerator)this.buildPublicKeyEncryptor(key));
        }
        if (!Util.isEmpty(this.symmetricPassphraseChars)) {
            generator.addMethod((PGPKeyEncryptionMethodGenerator)this.buildSymmetricKeyEncryptor());
        }
        return generator.open(out, this.getEncryptionBuffer(meta));
    }

    protected OutputStream compress(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        this.log.trace("using compression algorithm {} - {}", (Object)this.compressionAlgorithm, (Object)this.compressionLevel);
        if (this.compressionAlgorithm == CompressionAlgorithm.Uncompressed || this.compressionLevel < 1 || this.compressionLevel > 9) {
            return null;
        }
        int algo = this.compressionAlgorithm.ordinal();
        int level = this.compressionLevel;
        byte[] buf = this.getCompressionBuffer(meta);
        return new PGPCompressedDataGenerator(algo, level).open(out, buf);
    }

    protected OutputStream packet(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        char format = meta.getFormat().getCode();
        String name = meta.getName();
        Date date = meta.getLastModifiedDate();
        byte[] buf = this.getLiteralBuffer(meta);
        return new PGPLiteralDataGenerator().open(out, format, name, date, buf);
    }

    protected SigningOutputStream sign(OutputStream out, FileMetadata meta) throws IOException, PGPException {
        this.log.trace("using signing algorithm {}", (Object)this.signingAlgorithm);
        if (this.signingAlgorithm == HashingAlgorithm.Unsigned) {
            return null;
        }
        List<Key> signers = this.ring.getSigningKeys();
        for (int i = signers.size() - 1; i >= 0; --i) {
            Subkey subkey = signers.get(i).getSigning();
            if (this.isUsableForSigning(subkey)) continue;
            this.log.info("not using signing key {}", (Object)subkey);
            signers.remove(i);
        }
        if (Util.isEmpty(signers)) {
            throw new PGPException("no suitable signing key found");
        }
        return new SigningOutputStream(out, signers, meta);
    }

    protected void copy(InputStream i, OutputStream o, SigningOutputStream s, FileMetadata meta) throws IOException, PGPException {
        byte[] buf = this.getCopyBuffer(meta);
        int len = i.read(buf);
        while (len != -1) {
            if (s != null) {
                s.update(buf, 0, len);
            }
            o.write(buf, 0, len);
            len = i.read(buf);
        }
    }

    protected PGPEncryptedDataGenerator buildEncryptor() {
        int algo = this.encryptionAlgorithm.ordinal();
        BcPGPDataEncryptorBuilder builder = new BcPGPDataEncryptorBuilder(algo);
        builder.setWithIntegrityPacket(true);
        return new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)builder);
    }

    protected PublicKeyKeyEncryptionMethodGenerator buildPublicKeyEncryptor(Key key) {
        this.log.info("using encryption key {}", (Object)key.getEncryption());
        PGPPublicKey publicKey = key.getEncryption().getPublicKey();
        return new BcPublicKeyKeyEncryptionMethodGenerator(publicKey);
    }

    protected PBEKeyEncryptionMethodGenerator buildSymmetricKeyEncryptor() throws PGPException {
        this.log.info("using symmetric encryption with {} hash, work factor {}", (Object)this.keyDerivationAlgorithm, (Object)this.keyDerivationWorkFactor);
        int algo = this.keyDerivationAlgorithm.ordinal();
        return new BcPBEKeyEncryptionMethodGenerator(this.symmetricPassphraseChars, new BcPGPDigestCalculatorProvider().get(algo), this.keyDerivationWorkFactor);
    }

    protected boolean isUsableForSigning(Subkey subkey) {
        return subkey != null && subkey.isForSigning() && (subkey.isUnlocked() || !Util.isEmpty(subkey.passphraseChars));
    }

    protected PGPSignatureGenerator buildSigner(Key key, FileMetadata meta) throws PGPException {
        Subkey subkey = key.getSigning();
        this.log.info("using signing key {}", (Object)subkey);
        PGPContentSignerBuilder builder = this.buildSignerBuilder(subkey.getPublicKey().getAlgorithm(), this.signingAlgorithm.ordinal());
        PGPSignatureGenerator generator = new PGPSignatureGenerator(builder);
        generator.init(meta.getSignatureType(), subkey.getPrivateKey());
        String uid = key.getSigningUid();
        if (!Util.isEmpty(uid)) {
            this.log.debug("using signing uid {}", (Object)uid);
            PGPSignatureSubpacketGenerator signer = new PGPSignatureSubpacketGenerator();
            signer.setSignerUserID(false, uid);
            generator.setHashedSubpackets(signer.generate());
        }
        return generator;
    }

    protected PGPContentSignerBuilder buildSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        return new BcPGPContentSignerBuilder(keyAlgorithm, hashAlgorithm);
    }

    protected byte[] getEncryptionBuffer(FileMetadata meta) {
        return new byte[this.bestPacketSize(meta)];
    }

    protected byte[] getCompressionBuffer(FileMetadata meta) {
        return new byte[this.bestPacketSize(meta)];
    }

    protected byte[] getLiteralBuffer(FileMetadata meta) {
        return new byte[this.bestPacketSize(meta)];
    }

    protected byte[] getCopyBuffer(FileMetadata meta) {
        int len = (int)meta.getLength();
        if (len <= 0 || len > 65536) {
            len = 65536;
        }
        return new byte[len];
    }

    protected int bestPacketSize(FileMetadata meta) {
        int len = (int)meta.getLength();
        if (len > 0) {
            len += 300;
            len = 1 << 32 - Integer.numberOfLeadingZeros(len);
        }
        if (len <= 0 || len > 65536) {
            len = 65536;
        }
        return len;
    }

    protected int estimateOutFileSize(long inFileSize) {
        if (inFileSize >= (long)this.maxFileBufferSize) {
            return this.maxFileBufferSize;
        }
        long outFileSize = inFileSize;
        outFileSize += (long)((this.getRing().getEncryptionKeys().size() + this.getRing().getSigningKeys().size() + 1) * 512);
        if (this.asciiArmored) {
            outFileSize = (long)((float)outFileSize * (1.3333334f * ((64.0f + (float)Strings.lineSeparator().length()) / 64.0f)));
            outFileSize += 80L;
        }
        return (int)Math.min(outFileSize, (long)this.maxFileBufferSize);
    }

    protected class SigningOutputStream
    extends FilterOutputStream {
        protected FileMetadata meta;
        protected List<PGPSignatureGenerator> sigs;

        public SigningOutputStream(OutputStream out, List<Key> keys, FileMetadata meta) throws IOException, PGPException {
            super(out);
            this.meta = meta;
            this.init(keys);
        }

        @Override
        public void close() throws IOException {
            this.flush();
            try {
                this.finish();
            }
            catch (PGPException e) {
                throw new IOException(e);
            }
        }

        public void update(byte[] b, int off, int len) {
            for (PGPSignatureGenerator sig : this.sigs) {
                sig.update(b, off, len);
            }
        }

        protected void init(List<Key> keys) throws IOException, PGPException {
            this.sigs = new ArrayList<PGPSignatureGenerator>(keys.size());
            for (Key key : keys) {
                this.sigs.add(Encryptor.this.buildSigner(key, this.meta));
            }
            for (int i = 0; i < this.sigs.size(); ++i) {
                boolean nested = i != this.sigs.size() - 1;
                this.sigs.get(i).generateOnePassVersion(nested).encode(this.out);
            }
        }

        protected void finish() throws IOException, PGPException {
            for (int i = this.sigs.size() - 1; i >= 0; --i) {
                this.sigs.get(i).generate().encode(this.out);
            }
        }
    }
}

