/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.PacketWriter;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensions;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.SessionWorkBuffer;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.session.helpers.MultipleAttachedSessionException;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.session.helpers.SessionHelper;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public abstract class AbstractSession
extends SessionHelper {
    public static final String SESSION = "org.apache.sshd.session";
    protected final Random random;
    protected final Collection<SessionListener> sessionListeners = new CopyOnWriteArraySet<SessionListener>();
    protected final SessionListener sessionListenerProxy;
    protected final Collection<ChannelListener> channelListeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final ChannelListener channelListenerProxy;
    protected final Collection<PortForwardingEventListener> tunnelListeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    protected final PortForwardingEventListener tunnelListenerProxy;
    protected byte[] sessionId;
    protected String serverVersion;
    protected String clientVersion;
    protected final Map<KexProposalOption, String> serverProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> unmodServerProposal = Collections.unmodifiableMap(this.serverProposal);
    protected final Map<KexProposalOption, String> clientProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> unmodClientProposal = Collections.unmodifiableMap(this.clientProposal);
    protected final Map<KexProposalOption, String> negotiationResult = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> unmodNegotiationResult = Collections.unmodifiableMap(this.negotiationResult);
    protected KeyExchange kex;
    protected Boolean firstKexPacketFollows;
    protected final AtomicReference<KexState> kexState = new AtomicReference<KexState>(KexState.UNKNOWN);
    protected final AtomicReference<DefaultKeyExchangeFuture> kexFutureHolder = new AtomicReference<Object>(null);
    protected Cipher outCipher;
    protected Cipher inCipher;
    protected int outCipherSize = 8;
    protected int inCipherSize = 8;
    protected Mac outMac;
    protected Mac inMac;
    protected int outMacSize;
    protected int inMacSize;
    protected byte[] inMacResult;
    protected Compression outCompression;
    protected Compression inCompression;
    protected long seqi;
    protected long seqo;
    protected SessionWorkBuffer uncompressBuffer;
    protected final SessionWorkBuffer decoderBuffer;
    protected int decoderState;
    protected int decoderLength;
    protected final Object encodeLock = new Object();
    protected final Object decodeLock = new Object();
    protected final Object requestLock = new Object();
    protected final AtomicLong inPacketsCount = new AtomicLong(0L);
    protected final AtomicLong outPacketsCount = new AtomicLong(0L);
    protected final AtomicLong inBytesCount = new AtomicLong(0L);
    protected final AtomicLong outBytesCount = new AtomicLong(0L);
    protected final AtomicLong inBlocksCount = new AtomicLong(0L);
    protected final AtomicLong outBlocksCount = new AtomicLong(0L);
    protected final AtomicLong lastKeyTimeValue = new AtomicLong(0L);
    protected long maxRekyPackets = 0x80000000L;
    protected long maxRekeyBytes = 0x40000000L;
    protected long maxRekeyInterval = 3600000L;
    protected final Queue<PendingWriteFuture> pendingPackets = new LinkedList<PendingWriteFuture>();
    protected Service currentService;
    protected final AtomicLong globalRequestSeqo = new AtomicLong(-1L);
    protected final AtomicReference<String> pendingGlobalRequest = new AtomicReference();
    protected int ignorePacketDataLength = 16;
    protected long ignorePacketsFrequency = 1024L;
    protected int ignorePacketsVariance = 32;
    protected final AtomicLong maxRekeyBlocks = new AtomicLong(0x4000000L);
    protected final AtomicLong ignorePacketsCount = new AtomicLong(1024L);
    private final AtomicReference<Object> requestResult = new AtomicReference();
    private byte[] clientKexData;
    private byte[] serverKexData;

    protected AbstractSession(boolean serverSession, FactoryManager factoryManager, IoSession ioSession) {
        super(serverSession, factoryManager, ioSession);
        this.decoderBuffer = new SessionWorkBuffer(this);
        AbstractSession.attachSession(ioSession, this);
        Factory factory = (Factory)ValidateUtils.checkNotNull(factoryManager.getRandomFactory(), (String)"No random factory for %s", (Object)ioSession);
        this.random = (Random)ValidateUtils.checkNotNull((Object)factory.create(), (String)"No randomizer instance for %s", (Object)ioSession);
        this.refreshConfiguration();
        this.sessionListenerProxy = (SessionListener)EventListenerUtils.proxyWrapper(SessionListener.class, this.sessionListeners);
        this.channelListenerProxy = (ChannelListener)EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.tunnelListenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.tunnelListeners);
        try {
            this.signalSessionEstablished(ioSession);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeSshException((Throwable)e);
        }
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public Map<KexProposalOption, String> getServerKexProposals() {
        return this.unmodServerProposal;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public Map<KexProposalOption, String> getClientKexProposals() {
        return this.unmodClientProposal;
    }

    @Override
    public KeyExchange getKex() {
        return this.kex;
    }

    public KexState getKexState() {
        return this.kexState.get();
    }

    public byte[] getSessionId() {
        return NumberUtils.isEmpty((byte[])this.sessionId) ? this.sessionId : (byte[])this.sessionId.clone();
    }

    public Map<KexProposalOption, String> getKexNegotiationResult() {
        return this.unmodNegotiationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNegotiatedKexParameter(KexProposalOption paramType) {
        if (paramType == null) {
            return null;
        }
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            return this.negotiationResult.get(paramType);
        }
    }

    public CipherInformation getCipherInformation(boolean incoming) {
        return incoming ? this.inCipher : this.outCipher;
    }

    public CompressionInformation getCompressionInformation(boolean incoming) {
        return incoming ? this.inCompression : this.outCompression;
    }

    public MacInformation getMacInformation(boolean incoming) {
        return incoming ? this.inMac : this.outMac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Readable buffer) throws Exception {
        Object object = this.decodeLock;
        synchronized (object) {
            this.decoderBuffer.putBuffer(buffer);
            if (this.clientVersion == null || this.serverVersion == null) {
                if (this.readIdentification((Buffer)this.decoderBuffer)) {
                    this.decoderBuffer.compact();
                } else {
                    return;
                }
            }
            this.decode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshConfiguration() {
        Random random = this.random;
        synchronized (random) {
            this.maxRekeyBytes = this.getLongProperty("rekey-bytes-limit", this.maxRekeyBytes);
            this.maxRekeyInterval = this.getLongProperty("rekey-time-limit", this.maxRekeyInterval);
            this.maxRekyPackets = this.getLongProperty("rekey-packets-limit", this.maxRekyPackets);
            this.ignorePacketDataLength = this.getIntProperty("ignore-message-size", 16);
            this.ignorePacketsFrequency = this.getLongProperty("ignore-message-frequency", 1024L);
            this.ignorePacketsVariance = this.getIntProperty("ignore-message-variance", 32);
            if ((long)this.ignorePacketsVariance >= this.ignorePacketsFrequency) {
                this.ignorePacketsVariance = 0;
            }
            long countValue = this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance);
            this.ignorePacketsCount.set(countValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(Buffer buffer) throws Exception {
        try {
            Object object = this.sessionLock;
            synchronized (object) {
                this.doHandleMessage(buffer);
            }
        }
        catch (Throwable e) {
            DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
            if (kexFuture != null) {
                DefaultKeyExchangeFuture defaultKeyExchangeFuture = kexFuture;
                synchronized (defaultKeyExchangeFuture) {
                    Object value = kexFuture.getValue();
                    if (value == null) {
                        kexFuture.setValue(e);
                    }
                }
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doHandleMessage(Buffer buffer) throws Exception {
        cmd = buffer.getUByte();
        if (this.log.isTraceEnabled()) {
            this.log.trace("doHandleMessage({}) process {}", (Object)this, (Object)SshConstants.getCommandMessageName((int)cmd));
        }
        switch (cmd) {
            case 1: {
                this.handleDisconnect(buffer);
                break;
            }
            case 2: {
                this.handleIgnore(buffer);
                break;
            }
            case 3: {
                this.handleUnimplemented(buffer);
                break;
            }
            case 4: {
                this.handleDebug(buffer);
                break;
            }
            case 5: {
                this.handleServiceRequest(buffer);
                break;
            }
            case 6: {
                this.handleServiceAccept(buffer);
                break;
            }
            case 20: {
                this.handleKexInit(buffer);
                break;
            }
            case 21: {
                this.handleNewKeys(cmd, buffer);
                break;
            }
            case 7: {
                this.handleKexExtension(cmd, buffer);
                break;
            }
            case 8: {
                this.handleNewCompression(cmd, buffer);
                break;
            }
            default: {
                if (cmd < 30 || cmd > 49) ** GOTO lbl47
                if (this.firstKexPacketFollows != null) {
                    try {
                        if (!this.handleFirstKexPacketFollows(cmd, buffer, this.firstKexPacketFollows)) {
                            break;
                        }
                    }
                    finally {
                        this.firstKexPacketFollows = null;
                    }
                }
                this.handleKexMessage(cmd, buffer);
                break;
lbl47:
                // 1 sources

                if (this.currentService != null) {
                    this.currentService.process(cmd, buffer);
                    this.resetIdleTimeout();
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Unsupported command: {}", (Object)this, (Object)SshConstants.getCommandMessageName((int)cmd));
                }
                this.notImplemented(cmd, buffer);
            }
        }
        this.checkRekey();
    }

    protected boolean handleFirstKexPacketFollows(int cmd, Buffer buffer, boolean followFlag) {
        if (!followFlag) {
            return true;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        for (KexProposalOption option : KexProposalOption.FIRST_KEX_PACKET_GUESS_MATCHES) {
            Map.Entry<String, String> result = this.comparePreferredKexProposalOption(option);
            if (result == null) continue;
            if (debugEnabled) {
                this.log.debug("handleFirstKexPacketFollows({})[{}] 1st follow KEX packet {} option mismatch: client={}, server={}", new Object[]{this, SshConstants.getCommandMessageName((int)cmd), option, result.getKey(), result.getValue()});
            }
            return false;
        }
        return true;
    }

    protected Map.Entry<String, String> comparePreferredKexProposalOption(KexProposalOption option) {
        Object serverValue;
        Object[] clientPreferences = GenericUtils.split((String)this.clientProposal.get(option), (char)',');
        Object clientValue = GenericUtils.isEmpty((Object[])clientPreferences) ? null : clientPreferences[0];
        Object[] serverPreferences = GenericUtils.split((String)this.serverProposal.get(option), (char)',');
        Object object = serverValue = GenericUtils.isEmpty((Object[])serverPreferences) ? null : serverPreferences[0];
        if (GenericUtils.isEmpty((CharSequence)clientValue) || GenericUtils.isEmpty((CharSequence)serverValue) || !Objects.equals(clientValue, serverValue)) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(clientValue, serverValue);
        }
        return null;
    }

    protected IoWriteFuture sendNewKeys() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendNewKeys({}) Send SSH_MSG_NEWKEYS", (Object)this);
        }
        Buffer buffer = this.createBuffer((byte)21, 8);
        IoWriteFuture future = this.writePacket(buffer);
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler == null || !extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.NEWKEYS)) {
            return future;
        }
        extHandler.sendKexExtensions(this, KexExtensionHandler.KexPhase.NEWKEYS);
        return future;
    }

    protected void handleKexMessage(int cmd, Buffer buffer) throws Exception {
        this.validateKexState(cmd, KexState.RUN);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.kex.next(cmd, buffer)) {
            if (debugEnabled) {
                this.log.debug("handleKexMessage({})[{}] KEX processing complete after cmd={}", new Object[]{this, this.kex.getName(), cmd});
            }
            this.checkKeys();
            this.sendNewKeys();
            this.kexState.set(KexState.KEYS);
        } else if (debugEnabled) {
            this.log.debug("handleKexMessage({})[{}] more KEX packets expected after cmd={}", new Object[]{this, this.kex.getName(), cmd});
        }
    }

    protected void handleKexExtension(int cmd, Buffer buffer) throws Exception {
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        int startPos = buffer.rpos();
        if (extHandler != null && extHandler.handleKexExtensionsMessage(this, buffer)) {
            return;
        }
        buffer.rpos(startPos);
        this.notImplemented(cmd, buffer);
    }

    protected void handleNewCompression(int cmd, Buffer buffer) throws Exception {
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        int startPos = buffer.rpos();
        if (extHandler != null && extHandler.handleKexCompressionMessage(this, buffer)) {
            return;
        }
        buffer.rpos(startPos);
        this.notImplemented(cmd, buffer);
    }

    protected void handleServiceRequest(Buffer buffer) throws Exception {
        String serviceName = buffer.getString();
        this.handleServiceRequest(serviceName, buffer);
    }

    protected boolean handleServiceRequest(String serviceName, Buffer buffer) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleServiceRequest({}) SSH_MSG_SERVICE_REQUEST '{}'", (Object)this, (Object)serviceName);
        }
        this.validateKexState(5, KexState.DONE);
        try {
            this.startService(serviceName, buffer);
        }
        catch (Throwable e) {
            this.log.warn("handleServiceRequest({}) Service {} rejected: {} = {}", new Object[]{this, serviceName, e.getClass().getSimpleName(), e.getMessage()});
            if (debugEnabled) {
                this.log.warn("handleServiceRequest(" + this + ") service=" + serviceName + " rejection details", e);
            }
            this.disconnect(7, "Bad service request: " + serviceName);
            return false;
        }
        if (debugEnabled) {
            this.log.debug("handleServiceRequest({}) Accepted service {}", (Object)this, (Object)serviceName);
        }
        Buffer response = this.createBuffer((byte)6, 8 + GenericUtils.length((CharSequence)serviceName));
        response.putString(serviceName);
        this.writePacket(response);
        return true;
    }

    protected void handleServiceAccept(Buffer buffer) throws Exception {
        this.handleServiceAccept(buffer.getString(), buffer);
    }

    protected void handleServiceAccept(String serviceName, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServiceAccept({}) SSH_MSG_SERVICE_ACCEPT service={}", (Object)this, (Object)serviceName);
        }
        this.validateKexState(6, KexState.DONE);
    }

    protected void handleKexInit(Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleKexInit({}) SSH_MSG_KEXINIT", (Object)this);
        }
        this.receiveKexInit(buffer);
        this.doKexNegotiation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doKexNegotiation() throws Exception {
        byte[] i_c;
        byte[] i_s;
        if (this.kexState.compareAndSet(KexState.DONE, KexState.RUN)) {
            this.sendKexInit();
        } else if (!this.kexState.compareAndSet(KexState.INIT, KexState.RUN)) {
            throw new IllegalStateException("Received SSH_MSG_KEXINIT while key exchange is running");
        }
        Map<KexProposalOption, String> result = this.negotiate();
        String kexAlgorithm = result.get(KexProposalOption.ALGORITHMS);
        List<KeyExchangeFactory> kexFactories = this.getKeyExchangeFactories();
        KeyExchangeFactory kexFactory = (KeyExchangeFactory)NamedResource.findByName((String)kexAlgorithm, (Comparator)String.CASE_INSENSITIVE_ORDER, kexFactories);
        ValidateUtils.checkNotNull((Object)kexFactory, (String)"Unknown negotiated KEX algorithm: %s", (Object)kexAlgorithm);
        Queue<PendingWriteFuture> queue = this.pendingPackets;
        synchronized (queue) {
            this.kex = kexFactory.createKeyExchange(this);
        }
        byte[] v_s = this.serverVersion.getBytes(StandardCharsets.UTF_8);
        byte[] v_c = this.clientVersion.getBytes(StandardCharsets.UTF_8);
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            i_s = this.getServerKexData();
            i_c = this.getClientKexData();
        }
        this.kex.init(v_s, v_c, i_s, i_c);
        this.signalSessionEvent(SessionListener.Event.KexCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewKeys(int cmd, Buffer buffer) throws Exception {
        List<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> pendingWrites;
        Object value;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleNewKeys({}) SSH_MSG_NEWKEYS command={}", (Object)this, (Object)SshConstants.getCommandMessageName((int)cmd));
        }
        this.validateKexState(cmd, KexState.KEYS);
        this.receiveNewKeys();
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
        if (kexFuture != null) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = kexFuture;
            synchronized (defaultKeyExchangeFuture) {
                value = kexFuture.getValue();
                if (value == null) {
                    kexFuture.setValue(Boolean.TRUE);
                }
            }
        }
        this.signalSessionEvent(SessionListener.Event.KeyEstablished);
        value = this.pendingPackets;
        synchronized (value) {
            pendingWrites = this.sendPendingPackets(this.pendingPackets);
            this.kex = null;
            this.kexState.set(KexState.DONE);
        }
        int pendingCount = pendingWrites.size();
        if (pendingCount > 0) {
            if (debugEnabled) {
                this.log.debug("handleNewKeys({}) sent {} pending packets", (Object)this, (Object)pendingCount);
            }
            for (Map.Entry entry : pendingWrites) {
                SshFutureListener listener = (SshFutureListener)entry.getKey();
                IoWriteFuture future = (IoWriteFuture)entry.getValue();
                if (listener == null) continue;
                future.addListener(listener);
            }
        }
        Iterator iterator = this.futureLock;
        synchronized (iterator) {
            this.futureLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> sendPendingPackets(Queue<PendingWriteFuture> packetsQueue) throws IOException {
        if (GenericUtils.isEmpty(packetsQueue)) {
            return Collections.emptyList();
        }
        int numPending = packetsQueue.size();
        ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>> pendingWrites = new ArrayList<AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>>(numPending);
        Object object = this.encodeLock;
        synchronized (object) {
            PendingWriteFuture future = packetsQueue.poll();
            while (future != null) {
                IoWriteFuture writeFuture = this.doWritePacket(future.getBuffer());
                pendingWrites.add(new AbstractMap.SimpleImmutableEntry<PendingWriteFuture, IoWriteFuture>(future, writeFuture));
                future = packetsQueue.poll();
            }
        }
        return pendingWrites;
    }

    protected void validateKexState(int cmd, KexState expected) {
        KexState actual = this.kexState.get();
        if (!expected.equals((Object)actual)) {
            throw new IllegalStateException("Received KEX command=" + SshConstants.getCommandMessageName((int)cmd) + " while in state=" + actual + " instead of " + expected);
        }
    }

    protected Closeable getInnerCloseable() {
        Closeable closer = this.builder().parallel((Object)this.toString(), this.getServices()).close((Closeable)this.getIoSession()).build();
        closer.addCloseFutureListener(future -> this.clearAttributes());
        return closer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preClose() {
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
        if (kexFuture != null) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = kexFuture;
            synchronized (defaultKeyExchangeFuture) {
                Object value = kexFuture.getValue();
                if (value == null) {
                    kexFuture.setValue((Object)new SshException("Session closing while KEX in progress"));
                }
            }
        }
        this.signalRequestFailure();
        try {
            this.signalSessionClosed();
        }
        finally {
            this.sessionListeners.clear();
            this.channelListeners.clear();
            this.tunnelListeners.clear();
        }
        super.preClose();
    }

    protected List<Service> getServices() {
        return this.currentService != null ? Collections.singletonList(this.currentService) : Collections.emptyList();
    }

    @Override
    public <T extends Service> T getService(Class<T> clazz) {
        List<Service> registeredServices = this.getServices();
        ValidateUtils.checkState((boolean)GenericUtils.isNotEmpty(registeredServices), (String)"No registered services to look for %s", (Object)clazz.getSimpleName());
        for (Service s : registeredServices) {
            if (!clazz.isInstance(s)) continue;
            return (T)((Service)clazz.cast(s));
        }
        throw new IllegalStateException("Attempted to access unknown service " + clazz.getSimpleName());
    }

    @Override
    protected Buffer preProcessEncodeBuffer(int cmd, Buffer buffer) throws IOException {
        buffer = super.preProcessEncodeBuffer(cmd, buffer);
        if (cmd == 80) {
            long prev = this.globalRequestSeqo.getAndSet(this.seqo);
            if (this.log.isDebugEnabled()) {
                this.log.debug("preProcessEncodeBuffer({}) outgoing SSH_MSG_GLOBAL_REQUEST seqNo={} => {}", new Object[]{this, prev, this.globalRequestSeqo});
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        IoWriteFuture ioWriteFuture;
        PendingWriteFuture future = this.enqueuePendingPacket(buffer);
        if (future != null) {
            return future;
        }
        try {
            ioWriteFuture = this.doWritePacket(buffer);
        }
        catch (Throwable throwable) {
            this.resetIdleTimeout();
            try {
                this.checkRekey();
            }
            catch (GeneralSecurityException e) {
                this.log.warn("writePacket({}) failed ({}) to check re-key: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
                if (this.log.isDebugEnabled()) {
                    this.log.warn("writePacket(" + this + ") rekey security exception details", (Throwable)e);
                }
                throw (ProtocolException)ValidateUtils.initializeExceptionCause((Throwable)new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to check re-key necessity: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        this.resetIdleTimeout();
        try {
            this.checkRekey();
        }
        catch (GeneralSecurityException e) {
            this.log.warn("writePacket({}) failed ({}) to check re-key: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.warn("writePacket(" + this + ") rekey security exception details", (Throwable)e);
            }
            throw (ProtocolException)ValidateUtils.initializeExceptionCause((Throwable)new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to check re-key necessity: " + e.getMessage()), (Throwable)e);
        }
        return ioWriteFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PendingWriteFuture enqueuePendingPacket(Buffer buffer) {
        int numPending;
        PendingWriteFuture future;
        if (KexState.DONE.equals((Object)this.kexState.get())) {
            return null;
        }
        byte[] bufData = buffer.array();
        int cmd = bufData[buffer.rpos()] & 0xFF;
        if (cmd <= 49) {
            return null;
        }
        String cmdName = SshConstants.getCommandMessageName((int)cmd);
        Queue<PendingWriteFuture> queue = this.pendingPackets;
        synchronized (queue) {
            if (KexState.DONE.equals((Object)this.kexState.get())) {
                return null;
            }
            future = new PendingWriteFuture(cmdName, buffer);
            this.pendingPackets.add(future);
            numPending = this.pendingPackets.size();
        }
        if (this.log.isDebugEnabled()) {
            if (numPending == 1) {
                this.log.debug("enqueuePendingPacket({})[{}] Start flagging packets as pending until key exchange is done", (Object)this, (Object)cmdName);
            } else {
                this.log.debug("enqueuePendingPacket({})[{}] enqueued until key exchange is done (pending={})", new Object[]{this, cmdName, numPending});
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer resolveOutputPacket(Buffer buffer) throws IOException {
        Buffer ignoreBuf = null;
        int ignoreDataLen = this.resolveIgnoreBufferDataLength();
        if (ignoreDataLen > 0) {
            ignoreBuf = this.createBuffer((byte)2, ignoreDataLen + 8);
            ignoreBuf.putInt((long)ignoreDataLen);
            int wpos = ignoreBuf.wpos();
            Random random = this.random;
            synchronized (random) {
                this.random.fill(ignoreBuf.array(), wpos, ignoreDataLen);
            }
            ignoreBuf.wpos(wpos + ignoreDataLen);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveOutputPacket({}) append SSH_MSG_IGNORE message", (Object)this);
            }
        }
        int curPos = buffer.rpos();
        byte[] data = buffer.array();
        int cmd = data[curPos] & 0xFF;
        buffer = this.validateTargetBuffer(cmd, buffer);
        if (ignoreBuf != null) {
            ignoreBuf = this.encode(ignoreBuf);
            IoSession networkSession = this.getIoSession();
            networkSession.writePacket(ignoreBuf);
        }
        return this.encode(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture doWritePacket(Buffer buffer) throws IOException {
        Object object = this.encodeLock;
        synchronized (object) {
            Buffer packet = this.resolveOutputPacket(buffer);
            IoSession networkSession = this.getIoSession();
            IoWriteFuture future = networkSession.writePacket(packet);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int resolveIgnoreBufferDataLength() {
        if (this.ignorePacketDataLength <= 0 || this.ignorePacketsFrequency <= 0L || this.ignorePacketsVariance < 0) {
            return 0;
        }
        long count = this.ignorePacketsCount.decrementAndGet();
        if (count > 0L) {
            return 0;
        }
        Random random = this.random;
        synchronized (random) {
            count = this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance);
            this.ignorePacketsCount.set(count);
            return this.ignorePacketDataLength + this.random.random(this.ignorePacketDataLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer request(String request, Buffer buffer, long maxWaitMillis) throws IOException {
        Object result;
        if (maxWaitMillis <= 0L) {
            throw new IllegalArgumentException("Requested timeout for " + request + " below 1 msec: " + maxWaitMillis);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("request({}) request={}, timeout={}ms", new Object[]{this, request, maxWaitMillis});
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        long prevGlobalReqSeqNo = -1L;
        Object object = this.requestLock;
        synchronized (object) {
            try {
                this.writePacket(buffer);
                if (traceEnabled) {
                    this.log.debug("request({})[{}] sent with seqNo={}", new Object[]{this, request, this.globalRequestSeqo});
                }
                AtomicReference<Object> atomicReference = this.requestResult;
                synchronized (atomicReference) {
                    this.pendingGlobalRequest.set(request);
                    while (this.isOpen() && maxWaitMillis > 0L && this.requestResult.get() == null) {
                        if (traceEnabled) {
                            this.log.trace("request({})[{}] remaining wait={}", new Object[]{this, request, maxWaitMillis});
                        }
                        long waitStart = System.nanoTime();
                        this.requestResult.wait(maxWaitMillis);
                        long waitEnd = System.nanoTime();
                        long waitDuration = waitEnd - waitStart;
                        long waitMillis = TimeUnit.NANOSECONDS.toMillis(waitDuration);
                        if (waitMillis > 0L) {
                            maxWaitMillis -= waitMillis;
                            continue;
                        }
                        --maxWaitMillis;
                    }
                    result = this.requestResult.getAndSet(null);
                    prevGlobalReqSeqNo = this.globalRequestSeqo.getAndSet(-1L);
                    this.pendingGlobalRequest.set(null);
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted while waiting for request=" + request + " result").initCause(e);
            }
        }
        if (!this.isOpen()) {
            throw new IOException("Session is closed or closing while awaiting reply for request=" + request);
        }
        if (debugEnabled) {
            this.log.debug("request({}) request={}, timeout={}ms, requestSeqNo={}, result received={}", new Object[]{this, request, maxWaitMillis, prevGlobalReqSeqNo, result != null});
        }
        if (result == null) {
            throw new SocketTimeoutException("No response received after " + maxWaitMillis + "ms for request=" + request);
        }
        if (result instanceof Buffer) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doInvokeUnimplementedMessageHandler(int cmd, Buffer buffer) throws Exception {
        long reqSeqNo = -1L;
        long msgSeqNo = -1L;
        String reqGlobal = null;
        boolean propagateCall = true;
        if (cmd == 3 && this.globalRequestSeqo.get() >= 0L) {
            int rpos = buffer.rpos();
            msgSeqNo = buffer.rawUInt(rpos);
            AtomicReference<Object> atomicReference = this.requestResult;
            synchronized (atomicReference) {
                reqSeqNo = this.globalRequestSeqo.get();
                if (reqSeqNo == msgSeqNo) {
                    reqGlobal = this.pendingGlobalRequest.get();
                    propagateCall = false;
                    this.signalRequestFailure();
                }
            }
        }
        if (propagateCall) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("doInvokeUnimplementedMessageHandler({}) reqSeqNo={}, msgSeqNo={}, reqGlobal={}", new Object[]{this, reqSeqNo, msgSeqNo, reqGlobal});
            }
            return super.doInvokeUnimplementedMessageHandler(cmd, buffer);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("doInvokeUnimplementedMessageHandler({}) report global request={} failure for seqNo={}", new Object[]{this, reqGlobal, reqSeqNo});
        }
        return true;
    }

    @Override
    public Buffer createBuffer(byte cmd, int len) {
        if (len <= 0) {
            return this.prepareBuffer(cmd, (Buffer)new ByteArrayBuffer());
        }
        boolean etmMode = this.outMac == null ? false : this.outMac.isEncryptThenMac();
        int pad = PacketWriter.calculatePadLength((int)len, (int)this.outCipherSize, (boolean)etmMode);
        len = 5 + len + pad + 1;
        if (this.outMac != null) {
            len += this.outMacSize;
        }
        return this.prepareBuffer(cmd, (Buffer)new ByteArrayBuffer(new byte[len + 8], false));
    }

    @Override
    public Buffer prepareBuffer(byte cmd, Buffer buffer) {
        buffer = this.validateTargetBuffer(cmd & 0xFF, buffer);
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd);
        return buffer;
    }

    protected <B extends Buffer> B validateTargetBuffer(int cmd, B buffer) {
        ValidateUtils.checkNotNull(buffer, (String)"No target buffer to examine for command=%d", (long)cmd);
        ValidateUtils.checkTrue((buffer != this.decoderBuffer ? 1 : 0) != 0, (String)"Not allowed to use the internal decoder buffer for command=%d", (long)cmd);
        ValidateUtils.checkTrue((buffer != this.uncompressBuffer ? 1 : 0) != 0, (String)"Not allowed to use the internal uncompress buffer for command=%d", (long)cmd);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer encode(Buffer buffer) throws IOException {
        try {
            int newCmd;
            int curPos = buffer.rpos();
            int cmd = buffer.rawByte(curPos) & 0xFF;
            Buffer nb = this.preProcessEncodeBuffer(cmd, buffer);
            if (nb != buffer && cmd != (newCmd = (buffer = nb).rawByte(curPos = buffer.rpos()) & 0xFF)) {
                this.log.warn("encode({}) - command changed from {}[{}] to {}[{}] by pre-processor", new Object[]{this, cmd, SshConstants.getCommandMessageName((int)cmd), newCmd, SshConstants.getCommandMessageName((int)newCmd)});
                cmd = newCmd;
            }
            int len = buffer.available();
            if (this.log.isDebugEnabled()) {
                this.log.debug("encode({}) packet #{} sending command={}[{}] len={}", new Object[]{this, this.seqo, cmd, SshConstants.getCommandMessageName((int)cmd), len});
            }
            int off = curPos - 5;
            boolean traceEnabled = this.log.isTraceEnabled();
            if (traceEnabled) {
                buffer.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "encode(" + this + ") packet #" + this.seqo, (PropertyResolver)this);
            }
            if (this.outCompression != null && this.outCompression.isCompressionExecuted() && (this.isAuthenticated() || !this.outCompression.isDelayed())) {
                int oldLen = len;
                this.outCompression.compress(buffer);
                len = buffer.available();
                if (traceEnabled) {
                    this.log.trace("encode({}) packet #{} command={}[{}] compressed {} -> {}", new Object[]{this, this.seqo, cmd, SshConstants.getCommandMessageName((int)cmd), oldLen, len});
                }
            }
            boolean etmMode = this.outMac == null ? false : this.outMac.isEncryptThenMac();
            int pad = PacketWriter.calculatePadLength((int)len, (int)this.outCipherSize, (boolean)etmMode);
            int oldLen = len;
            len = len + pad + 1;
            if (traceEnabled) {
                this.log.trace("encode({}) packet #{} command={}[{}] len={}, pad={}, mac={}", new Object[]{this, this.seqo, cmd, SshConstants.getCommandMessageName((int)cmd), len, pad, this.outMac});
            }
            buffer.wpos(off);
            buffer.putInt((long)len);
            buffer.putByte((byte)pad);
            buffer.wpos(off + oldLen + 5 + pad);
            Random random = this.random;
            synchronized (random) {
                this.random.fill(buffer.array(), buffer.wpos() - pad, pad);
            }
            if (etmMode) {
                this.encryptOutgoingBuffer(buffer, off + 4, len);
                this.appendOutgoingMac(buffer, off, len);
            } else {
                this.appendOutgoingMac(buffer, off, len);
                this.encryptOutgoingBuffer(buffer, off, len + 4);
            }
            this.seqo = this.seqo + 1L & 0xFFFFFFFFL;
            this.outPacketsCount.incrementAndGet();
            this.outBytesCount.addAndGet(len);
            buffer.rpos(off);
            return buffer;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException((Throwable)e);
        }
    }

    protected void appendOutgoingMac(Buffer buf, int offset, int len) throws Exception {
        if (this.outMac == null) {
            return;
        }
        int l = buf.wpos();
        buf.wpos(l + this.outMacSize);
        this.outMac.updateUInt(this.seqo);
        this.outMac.update(buf.array(), offset, len + 4);
        this.outMac.doFinal(buf.array(), l);
    }

    protected void encryptOutgoingBuffer(Buffer buf, int offset, int len) throws Exception {
        if (this.outCipher == null) {
            return;
        }
        this.outCipher.update(buf.array(), offset, len);
        int blocksCount = len / this.outCipherSize;
        this.outBlocksCount.addAndGet(Math.max(1, blocksCount));
    }

    protected void decode() throws Exception {
        while (true) {
            SessionWorkBuffer packet;
            int macSize;
            boolean etmMode;
            boolean bl = etmMode = this.inMac == null ? false : this.inMac.isEncryptThenMac();
            if (this.decoderState == 0) {
                int minBufLen;
                assert (this.decoderBuffer.rpos() == 0);
                int n = minBufLen = etmMode ? 4 : this.inCipherSize;
                if (this.decoderBuffer.available() <= minBufLen) break;
                if (this.inCipher != null && !etmMode) {
                    this.inCipher.update(this.decoderBuffer.array(), 0, this.inCipherSize);
                    int blocksCount = this.inCipherSize / this.inCipher.getCipherBlockSize();
                    this.inBlocksCount.addAndGet(Math.max(1, blocksCount));
                }
                this.decoderLength = this.decoderBuffer.getInt();
                if (this.decoderLength < 5 || this.decoderLength > 262144) {
                    this.log.warn("decode({}) Error decoding packet(invalid length): {}", (Object)this, (Object)this.decoderLength);
                    this.decoderBuffer.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "decode(" + this + ") invalid length packet", (PropertyResolver)this);
                    throw new SshException(2, "Invalid packet length: " + this.decoderLength);
                }
                this.decoderState = 1;
                continue;
            }
            if (this.decoderState != 1) continue;
            assert (this.decoderBuffer.rpos() == 4);
            int n = macSize = this.inMac != null ? this.inMacSize : 0;
            if (this.decoderBuffer.available() < this.decoderLength + macSize) break;
            byte[] data = this.decoderBuffer.array();
            if (etmMode) {
                this.validateIncomingMac(data, 0, this.decoderLength + 4);
                if (this.inCipher != null) {
                    this.inCipher.update(data, 4, this.decoderLength);
                    int blocksCount = this.decoderLength / this.inCipherSize;
                    this.inBlocksCount.addAndGet(Math.max(1, blocksCount));
                }
            } else {
                if (this.inCipher != null) {
                    int updateLen = this.decoderLength + 4 - this.inCipherSize;
                    this.inCipher.update(data, this.inCipherSize, updateLen);
                    int blocksCount = updateLen / this.inCipherSize;
                    this.inBlocksCount.addAndGet(Math.max(1, blocksCount));
                }
                this.validateIncomingMac(data, 0, this.decoderLength + 4);
            }
            this.seqi = this.seqi + 1L & 0xFFFFFFFFL;
            int pad = this.decoderBuffer.getUByte();
            int wpos = this.decoderBuffer.wpos();
            if (this.inCompression != null && this.inCompression.isCompressionExecuted() && (this.isAuthenticated() || !this.inCompression.isDelayed())) {
                if (this.uncompressBuffer == null) {
                    this.uncompressBuffer = new SessionWorkBuffer(this);
                } else {
                    this.uncompressBuffer.forceClear(true);
                }
                this.decoderBuffer.wpos(this.decoderBuffer.rpos() + this.decoderLength - 1 - pad);
                this.inCompression.uncompress((Buffer)this.decoderBuffer, (Buffer)this.uncompressBuffer);
                packet = this.uncompressBuffer;
            } else {
                this.decoderBuffer.wpos(this.decoderLength + 4 - pad);
                packet = this.decoderBuffer;
            }
            if (this.log.isTraceEnabled()) {
                packet.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "decode(" + this + ") packet #" + this.seqi, (PropertyResolver)this);
            }
            this.inPacketsCount.incrementAndGet();
            this.inBytesCount.addAndGet(packet.available());
            this.handleMessage((Buffer)packet);
            this.decoderBuffer.rpos(this.decoderLength + 4 + macSize);
            this.decoderBuffer.wpos(wpos);
            this.decoderBuffer.compact();
            this.decoderState = 0;
        }
    }

    protected void validateIncomingMac(byte[] data, int offset, int len) throws Exception {
        if (this.inMac == null) {
            return;
        }
        this.inMac.updateUInt(this.seqi);
        this.inMac.update(data, offset, len);
        this.inMac.doFinal(this.inMacResult, 0);
        if (!BufferUtils.equals((byte[])this.inMacResult, (int)0, (byte[])data, (int)(offset + len), (int)this.inMacSize)) {
            throw new SshException(5, "MAC Error");
        }
    }

    protected abstract boolean readIdentification(Buffer var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendKexInit({}) Send SSH_MSG_KEXINIT", (Object)this);
        }
        Buffer buffer = this.createBuffer((byte)20);
        int p = buffer.wpos();
        buffer.wpos(p + 16);
        Random random = this.random;
        synchronized (random) {
            this.random.fill(buffer.array(), p, 16);
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("sendKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex((byte[])buffer.array(), (int)p, (int)16, (char)':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            String s = proposal.get(paramType);
            if (traceEnabled) {
                this.log.trace("sendKexInit({})[{}] {}", new Object[]{this, paramType.getDescription(), s});
            }
            buffer.putString(GenericUtils.trimToEmpty((String)s));
        }
        buffer.putBoolean(false);
        buffer.putInt(0L);
        byte[] data = buffer.getCompactData();
        this.writePacket(buffer);
        return data;
    }

    protected byte[] receiveKexInit(Buffer buffer, Map<KexProposalOption, String> proposal) throws IOException {
        long reserved;
        byte[] d = buffer.array();
        byte[] data = new byte[buffer.available() + 1];
        data[0] = 20;
        int size = 6;
        int cookieStartPos = buffer.rpos();
        System.arraycopy(d, cookieStartPos, data, 1, data.length - 1);
        buffer.rpos(cookieStartPos + 16);
        size += 16;
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("receiveKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex((byte[])d, (int)cookieStartPos, (int)16, (char)':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            int lastPos = buffer.rpos();
            String value = buffer.getString();
            if (traceEnabled) {
                this.log.trace("receiveKexInit({})[{}] {}", new Object[]{this, paramType.getDescription(), value});
            }
            int curPos = buffer.rpos();
            int readLen = curPos - lastPos;
            proposal.put(paramType, value);
            size += readLen;
        }
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler != null) {
            if (traceEnabled) {
                this.log.trace("receiveKexInit({}) options before handler: {}", (Object)this, proposal);
            }
            extHandler.handleKexInitProposal(this, false, proposal);
            if (traceEnabled) {
                this.log.trace("receiveKexInit({}) options after handler: {}", (Object)this, proposal);
            }
        }
        this.firstKexPacketFollows = buffer.getBoolean();
        if (traceEnabled) {
            this.log.trace("receiveKexInit({}) first kex packet follows: {}", (Object)this, (Object)this.firstKexPacketFollows);
        }
        if ((reserved = buffer.getUInt()) != 0L && traceEnabled) {
            this.log.trace("receiveKexInit({}) non-zero reserved value: {}", (Object)this, (Object)reserved);
        }
        byte[] dataShrinked = new byte[size];
        System.arraycopy(data, 0, dataShrinked, 0, size);
        return dataShrinked;
    }

    protected void receiveNewKeys() throws Exception {
        int j;
        byte[] k = this.kex.getK();
        byte[] h = this.kex.getH();
        Digest hash = this.kex.getHash();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.sessionId == null) {
            this.sessionId = (byte[])h.clone();
            if (debugEnabled) {
                this.log.debug("receiveNewKeys({}) session ID={}", (Object)this, (Object)BufferUtils.toHex((char)':', (byte[])this.sessionId));
            }
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putMPInt(k);
        buffer.putRawBytes(h);
        buffer.putByte((byte)65);
        buffer.putRawBytes(this.sessionId);
        int pos = buffer.available();
        byte[] buf = buffer.array();
        hash.update(buf, 0, pos);
        byte[] iv_c2s = hash.digest();
        int n = j = pos - this.sessionId.length - 1;
        buf[n] = (byte)(buf[n] + 1);
        hash.update(buf, 0, pos);
        byte[] iv_s2c = hash.digest();
        int n2 = j;
        buf[n2] = (byte)(buf[n2] + 1);
        hash.update(buf, 0, pos);
        byte[] e_c2s = hash.digest();
        int n3 = j;
        buf[n3] = (byte)(buf[n3] + 1);
        hash.update(buf, 0, pos);
        byte[] e_s2c = hash.digest();
        int n4 = j;
        buf[n4] = (byte)(buf[n4] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_c2s = hash.digest();
        int n5 = j;
        buf[n5] = (byte)(buf[n5] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_s2c = hash.digest();
        boolean serverSession = this.isServerSession();
        String value = this.getNegotiatedKexParameter(KexProposalOption.S2CENC);
        Cipher s2ccipher = (Cipher)ValidateUtils.checkNotNull((Object)NamedFactory.create(this.getCipherFactories(), (String)value), (String)"Unknown s2c cipher: %s", (Object)value);
        e_s2c = this.resizeKey(e_s2c, s2ccipher.getKdfSize(), hash, k, h);
        s2ccipher.init(serverSession ? Cipher.Mode.Encrypt : Cipher.Mode.Decrypt, e_s2c, iv_s2c);
        value = this.getNegotiatedKexParameter(KexProposalOption.S2CMAC);
        Mac s2cmac = (Mac)NamedFactory.create(this.getMacFactories(), (String)value);
        if (s2cmac == null) {
            throw new SshException(5, "Unknown s2c MAC: " + value);
        }
        mac_s2c = this.resizeKey(mac_s2c, s2cmac.getBlockSize(), hash, k, h);
        s2cmac.init(mac_s2c);
        value = this.getNegotiatedKexParameter(KexProposalOption.S2CCOMP);
        Compression s2ccomp = (Compression)NamedFactory.create(this.getCompressionFactories(), (String)value);
        if (s2ccomp == null) {
            throw new SshException(6, "Unknown s2c compression: " + value);
        }
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SENC);
        Cipher c2scipher = (Cipher)ValidateUtils.checkNotNull((Object)NamedFactory.create(this.getCipherFactories(), (String)value), (String)"Unknown c2s cipher: %s", (Object)value);
        e_c2s = this.resizeKey(e_c2s, c2scipher.getKdfSize(), hash, k, h);
        c2scipher.init(serverSession ? Cipher.Mode.Decrypt : Cipher.Mode.Encrypt, e_c2s, iv_c2s);
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SMAC);
        Mac c2smac = (Mac)NamedFactory.create(this.getMacFactories(), (String)value);
        if (c2smac == null) {
            throw new SshException(5, "Unknown c2s MAC: " + value);
        }
        mac_c2s = this.resizeKey(mac_c2s, c2smac.getBlockSize(), hash, k, h);
        c2smac.init(mac_c2s);
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SCOMP);
        Compression c2scomp = (Compression)NamedFactory.create(this.getCompressionFactories(), (String)value);
        if (c2scomp == null) {
            throw new SshException(6, "Unknown c2s compression: " + value);
        }
        if (serverSession) {
            this.outCipher = s2ccipher;
            this.outMac = s2cmac;
            this.outCompression = s2ccomp;
            this.inCipher = c2scipher;
            this.inMac = c2smac;
            this.inCompression = c2scomp;
        } else {
            this.outCipher = c2scipher;
            this.outMac = c2smac;
            this.outCompression = c2scomp;
            this.inCipher = s2ccipher;
            this.inMac = s2cmac;
            this.inCompression = s2ccomp;
        }
        this.outCipherSize = this.outCipher.getCipherBlockSize();
        this.outMacSize = this.outMac.getBlockSize();
        this.outCompression.init(Compression.Type.Deflater, -1);
        this.inCipherSize = this.inCipher.getCipherBlockSize();
        this.inMacSize = this.inMac.getBlockSize();
        this.inMacResult = new byte[this.inMacSize];
        this.inCompression.init(Compression.Type.Inflater, -1);
        int avgCipherBlockSize = Math.min(this.inCipherSize, this.outCipherSize);
        long recommendedByteRekeyBlocks = 1L << Math.min(avgCipherBlockSize * 8 / 4, 63);
        long effectiveRekyBlocksCount = this.getLongProperty("rekey-blocks-limit", recommendedByteRekeyBlocks);
        this.maxRekeyBlocks.set(effectiveRekyBlocksCount);
        if (debugEnabled) {
            this.log.debug("receiveNewKeys({}) inCipher={}, outCipher={}, recommended blocks limit={}, actual={}", new Object[]{this, this.inCipher, this.outCipher, recommendedByteRekeyBlocks, this.maxRekeyBlocks});
        }
        this.inBytesCount.set(0L);
        this.outBytesCount.set(0L);
        this.inPacketsCount.set(0L);
        this.outPacketsCount.set(0L);
        this.inBlocksCount.set(0L);
        this.outBlocksCount.set(0L);
        this.lastKeyTimeValue.set(System.currentTimeMillis());
        this.firstKexPacketFollows = null;
    }

    protected IoWriteFuture notImplemented(int cmd, Buffer buffer) throws Exception {
        if (this.doInvokeUnimplementedMessageHandler(cmd, buffer)) {
            return null;
        }
        return this.sendNotImplemented(this.seqi - 1L);
    }

    protected Map<KexProposalOption, String> negotiate() throws IOException {
        Map<KexProposalOption, String> negotiatedGuess;
        EnumMap<KexProposalOption, String> guess;
        Map<KexProposalOption, String> s2cOptions;
        Map<KexProposalOption, String> c2sOptions;
        block14: {
            c2sOptions = this.getClientKexProposals();
            s2cOptions = this.getServerKexProposals();
            this.signalNegotiationStart(c2sOptions, s2cOptions);
            guess = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
            negotiatedGuess = Collections.unmodifiableMap(guess);
            try {
                boolean debugEnabled = this.log.isDebugEnabled();
                boolean traceEnabled = this.log.isTraceEnabled();
                SessionDisconnectHandler discHandler = this.getSessionDisconnectHandler();
                KexExtensionHandler extHandler = this.getKexExtensionHandler();
                for (KexProposalOption paramType : KexProposalOption.VALUES) {
                    String serverParamValue;
                    String clientParamValue;
                    block13: {
                        clientParamValue = c2sOptions.get(paramType);
                        serverParamValue = s2cOptions.get(paramType);
                        String[] c = GenericUtils.split((String)clientParamValue, (char)',');
                        String[] s = GenericUtils.split((String)serverParamValue, (char)',');
                        for (String ci : c) {
                            String value;
                            for (String si : s) {
                                if (!ci.equals(si)) continue;
                                guess.put(paramType, ci);
                                break;
                            }
                            if ((value = (String)guess.get(paramType)) != null) break;
                        }
                        String value = (String)guess.get(paramType);
                        if (extHandler != null) {
                            extHandler.handleKexExtensionNegotiation(this, paramType, value, c2sOptions, clientParamValue, s2cOptions, serverParamValue);
                        }
                        if (value != null) {
                            if (!traceEnabled) continue;
                            this.log.trace("negotiate({})[{}] guess={} (client={} / server={})", new Object[]{this, paramType.getDescription(), value, clientParamValue, serverParamValue});
                            continue;
                        }
                        try {
                            if (discHandler != null && discHandler.handleKexDisconnectReason(this, c2sOptions, s2cOptions, negotiatedGuess, paramType)) {
                                if (!debugEnabled) continue;
                                this.log.debug("negotiate({}) ignore missing value for KEX option={}", (Object)this, (Object)paramType);
                                continue;
                            }
                        }
                        catch (IOException | RuntimeException e) {
                            this.log.warn("negotiate({}) failed ({}) to invoke disconnect handler due to mismatched KEX option={}: {}", new Object[]{this, e.getClass().getSimpleName(), paramType, e.getMessage()});
                            if (!debugEnabled) break block13;
                            this.log.warn("negotiate(" + this + ") handler invocation exception details", (Throwable)e);
                        }
                    }
                    String message = "Unable to negotiate key exchange for " + paramType.getDescription() + " (client: " + clientParamValue + " / server: " + serverParamValue + ")";
                    if (KexProposalOption.S2CLANG.equals((Object)paramType) || KexProposalOption.C2SLANG.equals((Object)paramType)) {
                        if (!traceEnabled) continue;
                        this.log.trace("negotiate({}) {}", (Object)this, (Object)message);
                        continue;
                    }
                    throw new SshException(3, message);
                }
                String kexOption = (String)guess.get(KexProposalOption.ALGORITHMS);
                if (!KexExtensions.IS_KEX_EXTENSION_SIGNAL.test(kexOption)) break block14;
                if (discHandler != null && discHandler.handleKexDisconnectReason(this, c2sOptions, s2cOptions, negotiatedGuess, KexProposalOption.ALGORITHMS)) {
                    if (debugEnabled) {
                        this.log.debug("negotiate({}) ignore violating {} KEX option={}", new Object[]{this, KexProposalOption.ALGORITHMS, kexOption});
                    }
                    break block14;
                }
                throw new SshException(3, "Illegal KEX option negotiated: " + kexOption);
            }
            catch (IOException | Error | RuntimeException e) {
                this.signalNegotiationEnd(c2sOptions, s2cOptions, negotiatedGuess, e);
                throw e;
            }
        }
        this.signalNegotiationEnd(c2sOptions, s2cOptions, negotiatedGuess, null);
        return this.setNegotiationResult(guess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> setNegotiationResult(Map<KexProposalOption, String> guess) {
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            if (!this.negotiationResult.isEmpty()) {
                this.negotiationResult.clear();
            }
            this.negotiationResult.putAll(guess);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("setNegotiationResult({}) Kex: server->client {} {} {}", new Object[]{this, guess.get(KexProposalOption.S2CENC), guess.get(KexProposalOption.S2CMAC), guess.get(KexProposalOption.S2CCOMP)});
            this.log.debug("setNegotiationResult({}) Kex: client->server {} {} {}", new Object[]{this, guess.get(KexProposalOption.C2SENC), guess.get(KexProposalOption.C2SMAC), guess.get(KexProposalOption.C2SCOMP)});
        }
        return guess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSuccess(Buffer buffer) throws Exception {
        ByteArrayBuffer resultBuf = ByteArrayBuffer.getCompactClone((byte[])buffer.array(), (int)buffer.rpos(), (int)buffer.available());
        AtomicReference<Object> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(resultBuf);
            this.resetIdleTimeout();
            this.requestResult.notifyAll();
        }
    }

    protected void requestFailure(Buffer buffer) throws Exception {
        this.signalRequestFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalRequestFailure() {
        AtomicReference<Object> atomicReference = this.requestResult;
        synchronized (atomicReference) {
            this.requestResult.set(GenericUtils.NULL);
            this.resetIdleTimeout();
            this.requestResult.notifyAll();
        }
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        SessionListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.sessionListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            return;
        }
        SessionListener.validateListener(listener);
        if (this.sessionListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        ChannelListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.channelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        ChannelListener.validateListener(listener);
        if (this.channelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        PortForwardingEventListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.tunnelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(listener);
        if (this.tunnelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public KeyExchangeFuture reExchangeKeys() throws IOException {
        try {
            this.requestNewKeysExchange();
        }
        catch (GeneralSecurityException e) {
            this.log.warn("reExchangeKeys({}) failed ({}) to request new keys: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.warn("reExchangeKeys(" + this + ") security exception details", (Throwable)e);
            }
            throw (ProtocolException)ValidateUtils.initializeExceptionCause((Throwable)new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to generate keys for exchange: " + e.getMessage()), (Throwable)e);
        }
        return (KeyExchangeFuture)ValidateUtils.checkNotNull((Object)this.kexFutureHolder.get(), (String)"No current KEX future on state=%s", this.kexState);
    }

    protected KeyExchangeFuture checkRekey() throws IOException, GeneralSecurityException {
        return this.isRekeyRequired() ? this.requestNewKeysExchange() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyExchangeFuture requestNewKeysExchange() throws IOException, GeneralSecurityException {
        if (!this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("requestNewKeysExchange({}) KEX state not DONE: {}", (Object)this, this.kexState);
            }
            return null;
        }
        this.log.info("requestNewKeysExchange({}) Initiating key re-exchange", (Object)this);
        this.sendKexInit();
        DefaultKeyExchangeFuture newFuture = new DefaultKeyExchangeFuture(this.toString(), null);
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.getAndSet(newFuture);
        if (kexFuture != null) {
            DefaultKeyExchangeFuture defaultKeyExchangeFuture = kexFuture;
            synchronized (defaultKeyExchangeFuture) {
                Object value = kexFuture.getValue();
                if (value == null) {
                    kexFuture.setValue((Object)new SshException("New KEX started while previous one still ongoing"));
                }
            }
        }
        return newFuture;
    }

    protected boolean isRekeyRequired() {
        if (!this.isOpen() || this.isClosing() || this.isClosed()) {
            return false;
        }
        KexState curState = this.kexState.get();
        if (!KexState.DONE.equals((Object)curState)) {
            return false;
        }
        return this.isRekeyTimeIntervalExceeded() || this.isRekeyPacketCountsExceeded() || this.isRekeyBlocksCountExceeded() || this.isRekeyDataSizeExceeded();
    }

    protected boolean isRekeyTimeIntervalExceeded() {
        boolean rekey;
        if (this.maxRekeyInterval <= 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long rekeyDiff = now - this.lastKeyTimeValue.get();
        boolean bl = rekey = rekeyDiff > this.maxRekeyInterval;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyTimeIntervalExceeded({}) re-keying: last={}, now={}, diff={}, max={}", new Object[]{this, new Date(this.lastKeyTimeValue.get()), new Date(now), rekeyDiff, this.maxRekeyInterval});
        }
        return rekey;
    }

    protected boolean isRekeyPacketCountsExceeded() {
        boolean rekey;
        if (this.maxRekyPackets <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inPacketsCount.get() > this.maxRekyPackets || this.outPacketsCount.get() > this.maxRekyPackets;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyPacketCountsExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inPacketsCount, this.outPacketsCount, this.maxRekyPackets});
        }
        return rekey;
    }

    protected boolean isRekeyDataSizeExceeded() {
        boolean rekey;
        if (this.maxRekeyBytes <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inBytesCount.get() > this.maxRekeyBytes || this.outBytesCount.get() > this.maxRekeyBytes;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyDataSizeExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inBytesCount, this.outBytesCount, this.maxRekeyBytes});
        }
        return rekey;
    }

    protected boolean isRekeyBlocksCountExceeded() {
        boolean rekey;
        long maxBlocks = this.maxRekeyBlocks.get();
        if (maxBlocks <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inBlocksCount.get() > maxBlocks || this.outBlocksCount.get() > maxBlocks;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyBlocksCountExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inBlocksCount, this.outBlocksCount, maxBlocks});
        }
        return rekey;
    }

    @Override
    protected String resolveSessionKexProposal(String hostKeyTypes) throws IOException {
        String extType;
        String proposal = super.resolveSessionKexProposal(hostKeyTypes);
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler == null || !extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.PROPOSAL)) {
            return proposal;
        }
        String string = extType = this.isServerSession() ? "ext-info-s" : "ext-info-c";
        if (GenericUtils.isEmpty((CharSequence)proposal)) {
            return extType;
        }
        return proposal + "," + extType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendKexInit() throws IOException, GeneralSecurityException {
        byte[] seed;
        String resolvedAlgorithms = this.resolveAvailableSignaturesProposal();
        if (GenericUtils.isEmpty((CharSequence)resolvedAlgorithms)) {
            throw new SshException(9, "sendKexInit() no resolved signatures available");
        }
        Map<KexProposalOption, String> proposal = this.createProposal(resolvedAlgorithms);
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        boolean traceEnabled = this.log.isTraceEnabled();
        if (extHandler != null) {
            if (traceEnabled) {
                this.log.trace("sendKexInit({}) options before handler: {}", (Object)this, proposal);
            }
            extHandler.handleKexInitProposal(this, true, proposal);
            if (traceEnabled) {
                this.log.trace("sendKexInit({}) options after handler: {}", (Object)this, proposal);
            }
        }
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            seed = this.sendKexInit(proposal);
            this.setKexSeed(seed);
        }
        if (traceEnabled) {
            this.log.trace("sendKexInit({}) proposal={} seed: {}", new Object[]{this, proposal, BufferUtils.toHex((char)':', (byte[])seed)});
        }
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getClientKexData() {
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            return this.clientKexData == null ? null : (byte[])this.clientKexData.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientKexData(byte[] data) {
        ValidateUtils.checkNotNullAndNotEmpty((byte[])data, (String)"No client KEX seed");
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.clientKexData = (byte[])data.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getServerKexData() {
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            return this.serverKexData == null ? null : (byte[])this.serverKexData.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServerKexData(byte[] data) {
        ValidateUtils.checkNotNullAndNotEmpty((byte[])data, (String)"No server KEX seed");
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.serverKexData = (byte[])data.clone();
        }
    }

    protected abstract void setKexSeed(byte ... var1);

    protected String resolveAvailableSignaturesProposal() throws IOException, GeneralSecurityException {
        return this.resolveAvailableSignaturesProposal(this.getFactoryManager());
    }

    protected abstract String resolveAvailableSignaturesProposal(FactoryManager var1) throws IOException, GeneralSecurityException;

    protected abstract void checkKeys() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] receiveKexInit(Buffer buffer) throws Exception {
        byte[] seed;
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            seed = this.receiveKexInit(buffer, proposal);
            this.receiveKexInit(proposal, seed);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit({}) proposal={} seed: {}", new Object[]{this, proposal, BufferUtils.toHex((char)':', (byte[])seed)});
        }
        return seed;
    }

    protected abstract void receiveKexInit(Map<KexProposalOption, String> var1, byte[] var2) throws IOException;

    public static AbstractSession getSession(IoSession ioSession) throws MissingAttachedSessionException {
        return AbstractSession.getSession(ioSession, false);
    }

    public static void attachSession(IoSession ioSession, AbstractSession session) throws MultipleAttachedSessionException {
        Objects.requireNonNull(ioSession, "No I/O session");
        Objects.requireNonNull(session, "No SSH session");
        Object prev = ioSession.setAttributeIfAbsent((Object)SESSION, (Object)session);
        if (prev != null) {
            throw new MultipleAttachedSessionException("Multiple attached session to " + ioSession + ": " + prev + " and " + session);
        }
    }

    public static AbstractSession getSession(IoSession ioSession, boolean allowNull) throws MissingAttachedSessionException {
        AbstractSession session = (AbstractSession)ioSession.getAttribute((Object)SESSION);
        if (session == null && !allowNull) {
            throw new MissingAttachedSessionException("No session attached to " + ioSession);
        }
        return session;
    }
}

