/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.File;
import java.util.Date;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.c02e.jpgpj.Ring;

public class FileMetadata {
    protected String name;
    protected long length;
    protected long lastModified;
    protected Format format;
    protected Ring verified;

    public FileMetadata() {
        this("");
    }

    public FileMetadata(PGPLiteralData data) {
        this(data.getFileName(), Format.byCode((char)data.getFormat()));
        if (data.getModificationTime() != null) {
            this.setLastModified(data.getModificationTime().getTime());
        }
    }

    public FileMetadata(File file) {
        this();
        this.setFile(file);
    }

    public FileMetadata(String name) {
        this(name, Format.BINARY);
    }

    public FileMetadata(String name, Format format) {
        this.setName(name);
        this.setFormat(format);
        this.verified = new Ring();
    }

    public FileMetadata(String name, Format format, long length, long lastModified) {
        this(name, format);
        this.setLength(length);
        this.setLastModified(lastModified);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String x) {
        this.name = x != null ? x : "";
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long x) {
        this.length = x;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long x) {
        this.lastModified = x;
    }

    public Date getLastModifiedDate() {
        return new Date(this.lastModified);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format x) {
        this.format = x != null ? x : Format.BINARY;
    }

    public Ring getVerified() {
        return this.verified;
    }

    public void setFile(File file) {
        if (file == null) {
            return;
        }
        this.setName(file.getName());
        this.setLength(file.length());
        this.setLastModified(file.lastModified());
    }

    public int getSignatureType() {
        return this.format == Format.TEXT || this.format == Format.UTF8 ? 1 : 0;
    }

    public static enum Format {
        BINARY('b'),
        TEXT('t'),
        UTF8('u');

        protected char code;

        private Format(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        public static Format byCode(char code) {
            switch (code) {
                case 'b': {
                    return BINARY;
                }
                case 't': {
                    return TEXT;
                }
                case 'u': {
                    return UTF8;
                }
            }
            return null;
        }
    }
}

