/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.c02e.jpgpj.DecryptionException;
import org.c02e.jpgpj.FileMetadata;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.PassphraseException;
import org.c02e.jpgpj.Ring;
import org.c02e.jpgpj.Subkey;
import org.c02e.jpgpj.VerificationException;
import org.c02e.jpgpj.util.FileDetection;
import org.c02e.jpgpj.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decryptor {
    protected boolean verificationRequired = true;
    protected char[] symmetricPassphraseChars;
    protected String symmetricPassphrase;
    protected int maxFileBufferSize = 0x100000;
    protected Ring ring;
    protected Logger log = LoggerFactory.getLogger((String)Decryptor.class.getName());

    public Decryptor() {
        this(new Ring());
    }

    public Decryptor(Ring ring) {
        this.setSymmetricPassphraseChars(null);
        this.setRing(ring);
    }

    public Decryptor(Key ... keys) {
        this(new Ring(keys));
    }

    public boolean isVerificationRequired() {
        return this.verificationRequired;
    }

    public void setVerificationRequired(boolean x) {
        this.verificationRequired = x;
    }

    public char[] getSymmetricPassphraseChars() {
        return this.symmetricPassphraseChars;
    }

    public void setSymmetricPassphraseChars(char[] x) {
        if (x == null) {
            x = new char[]{};
        }
        if (!Arrays.equals(x, this.symmetricPassphraseChars)) {
            this.symmetricPassphraseChars = x;
            this.symmetricPassphrase = null;
        }
    }

    public String getSymmetricPassphrase() {
        if (this.symmetricPassphrase == null) {
            this.symmetricPassphrase = new String(this.symmetricPassphraseChars);
        }
        return this.symmetricPassphrase;
    }

    public void setSymmetricPassphrase(String x) {
        this.setSymmetricPassphraseChars(x != null ? x.toCharArray() : null);
        this.symmetricPassphrase = x;
    }

    public int getMaxFileBufferSize() {
        return this.maxFileBufferSize;
    }

    public void setMaxFileBufferSize(int maxFileBufferSize) {
        this.maxFileBufferSize = maxFileBufferSize;
    }

    public Ring getRing() {
        return this.ring;
    }

    protected void setRing(Ring x) {
        this.ring = x != null ? x : new Ring();
    }

    public void clearSecrets() {
        this.ring.clearSecrets();
        Arrays.fill(this.symmetricPassphraseChars, '\u0000');
        this.symmetricPassphraseChars = new char[0];
        this.symmetricPassphrase = null;
    }

    public FileMetadata decrypt(File ciphertext, File plaintext) throws IOException, PGPException {
        if (ciphertext.equals(plaintext)) {
            throw new IOException("cannot decrypt " + ciphertext + " over itself");
        }
        plaintext.delete();
        InputStream input = null;
        OutputStream output = null;
        try {
            int bestBufferSize = Util.bestFileBufferSize(ciphertext.length(), this.maxFileBufferSize);
            input = new BufferedInputStream(new FileInputStream(ciphertext), bestBufferSize);
            output = new BufferedOutputStream(new FileOutputStream(plaintext), bestBufferSize);
            FileMetadata fileMetadata = this.decrypt(input, output);
            return fileMetadata;
        }
        catch (Exception e) {
            if (output != null) {
                try {
                    output.close();
                    plaintext.delete();
                }
                catch (Exception ee) {
                    this.log.error("failed to delete bad output file {}", (Object)plaintext, (Object)ee);
                }
            }
            throw e;
        }
        finally {
            try {
                output.close();
            }
            catch (Exception exception) {}
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public FileMetadata decrypt(InputStream ciphertext, OutputStream plaintext) throws IOException, PGPException {
        List<FileMetadata> meta = this.unpack(this.parse(this.unarmor(ciphertext)), plaintext);
        if (meta.size() > 1) {
            throw new PGPException("content contained more than one file");
        }
        if (meta.size() < 1) {
            return new FileMetadata();
        }
        return meta.get(0);
    }

    protected List<FileMetadata> unpack(Iterator packets, OutputStream plaintext) throws IOException, PGPException {
        ArrayList<FileMetadata> meta = new ArrayList<FileMetadata>();
        List<Verifier> verifiers = new ArrayList<Verifier>();
        while (packets.hasNext()) {
            PGPOnePassSignatureList list;
            Object packet = packets.next();
            this.log.trace("unpack {}", packet.getClass());
            if (packet instanceof PGPMarker) continue;
            if (packet instanceof PGPOnePassSignatureList) {
                list = (PGPOnePassSignatureList)packet;
                verifiers = this.buildVerifiers(list.iterator());
                continue;
            }
            if (packet instanceof PGPSignatureList) {
                list = (PGPSignatureList)packet;
                if (Util.isEmpty(verifiers)) {
                    verifiers = this.buildVerifiers(list.iterator());
                    continue;
                }
                this.matchSignatures(list.iterator(), verifiers);
                continue;
            }
            if (packet instanceof PGPEncryptedDataList) {
                list = (PGPEncryptedDataList)packet;
                meta.addAll(this.unpack(this.parse(this.decrypt(list.iterator())), plaintext));
                continue;
            }
            if (packet instanceof PGPCompressedData) {
                InputStream i = ((PGPCompressedData)packet).getDataStream();
                meta.addAll(this.unpack(this.parse(i), plaintext));
                continue;
            }
            if (packet instanceof PGPLiteralData) {
                PGPLiteralData data = (PGPLiteralData)packet;
                FileMetadata file = new FileMetadata(data);
                InputStream i = data.getDataStream();
                file.setLength(this.copy(i, plaintext, verifiers));
                meta.add(file);
                continue;
            }
            throw new PGPException("unexpected packet: " + packet.getClass());
        }
        this.log.trace("unpacked all");
        this.verify(verifiers, meta);
        return meta;
    }

    protected List<Verifier> buildVerifiers(Iterator signatures) throws PGPException {
        ArrayList<Verifier> verifiers = new ArrayList<Verifier>();
        while (signatures.hasNext()) {
            Verifier verifier = null;
            Object signature = signatures.next();
            if (signature instanceof PGPSignature) {
                verifier = new Verifier((PGPSignature)signature);
            } else if (signature instanceof PGPOnePassSignature) {
                verifier = new Verifier((PGPOnePassSignature)signature);
            }
            if (verifier == null || !verifier.isKeyAvailable()) continue;
            verifiers.add(verifier);
        }
        return verifiers;
    }

    protected void matchSignatures(Iterator<PGPSignature> signatures, List<Verifier> verifiers) {
        while (signatures.hasNext()) {
            PGPSignature signature = signatures.next();
            for (Verifier verifier : verifiers) {
                verifier.match(signature);
            }
        }
    }

    protected InputStream decrypt(Iterator data) throws IOException, PGPException {
        PGPPBEEncryptedData pbe = null;
        while (data.hasNext()) {
            Object o = data.next();
            if (o instanceof PGPPublicKeyEncryptedData) {
                PGPPublicKeyEncryptedData pke = (PGPPublicKeyEncryptedData)o;
                Long id = pke.getKeyID();
                List<Key> keys = this.ring.findAll(id);
                for (Key key : keys) {
                    Subkey subkey = key.findById(id);
                    if (this.isUsableForDecryption(subkey)) {
                        return this.decrypt(pke, subkey);
                    }
                    this.log.info("not using decryption key {}", (Object)subkey);
                }
                if (!Util.isEmpty(keys)) continue;
                this.log.info("not found decryption key {}", (Object)Util.formatKeyId(id));
                continue;
            }
            if (!(o instanceof PGPPBEEncryptedData) || pbe != null) continue;
            pbe = (PGPPBEEncryptedData)o;
        }
        return this.decrypt(pbe);
    }

    protected InputStream decrypt(PGPPublicKeyEncryptedData data, Subkey subkey) throws IOException, PGPException {
        if (data == null || subkey == null) {
            throw new DecryptionException("no suitable decryption key found");
        }
        this.log.info("using decryption key {}", (Object)subkey);
        return data.getDataStream(this.buildPublicKeyDecryptor(subkey));
    }

    protected InputStream decrypt(PGPPBEEncryptedData data) throws IOException, PGPException {
        if (data == null || Util.isEmpty(this.symmetricPassphraseChars)) {
            throw new DecryptionException("no suitable decryption key found");
        }
        try {
            return data.getDataStream(this.buildSymmetricKeyDecryptor(this.symmetricPassphraseChars));
        }
        catch (PGPDataValidationException e) {
            throw new PassphraseException("incorrect passphrase for symmetric key", (Exception)((Object)e));
        }
    }

    protected long copy(InputStream i, OutputStream o, List<Verifier> verifiers) throws IOException, PGPException {
        long total = 0L;
        byte[] buf = this.getCopyBuffer();
        int len = i.read(buf);
        if (this.verificationRequired && Util.isEmpty(verifiers)) {
            throw new VerificationException("content not signed with a required key");
        }
        while (len != -1) {
            total += (long)len;
            if (this.verificationRequired) {
                for (Verifier verifier : verifiers) {
                    if (verifier.sig != null) {
                        verifier.sig.update(buf, 0, len);
                        continue;
                    }
                    verifier.sig1.update(buf, 0, len);
                }
            }
            o.write(buf, 0, len);
            len = i.read(buf);
        }
        return total;
    }

    protected void verify(List<Verifier> verifiers, List<FileMetadata> meta) throws PGPException {
        if (!this.verificationRequired) {
            return;
        }
        for (Verifier verifier : verifiers) {
            if (!verifier.verify()) {
                throw new VerificationException("bad signature for key " + verifier.key);
            }
            this.log.debug("good signature for key {}", (Object)verifier.key);
            Key key = verifier.getSignedBy();
            for (FileMetadata file : meta) {
                file.getVerified().getKeys().add(key);
            }
        }
    }

    protected InputStream unarmor(InputStream stream) throws IOException, PGPException {
        FileDetection.DetectionResult result = FileDetection.detectContainer(stream, this.getMaxFileBufferSize());
        switch (result.type) {
            case ASCII_ARMOR: {
                return new ArmoredInputStream(result.stream);
            }
            case PGP: {
                return result.stream;
            }
        }
        throw new PGPException("not a pgp message");
    }

    protected Iterator parse(InputStream stream) throws IOException, PGPException {
        return new BcPGPObjectFactory(stream).iterator();
    }

    protected PGPContentVerifierBuilderProvider getVerifierProvider() {
        return new BcPGPContentVerifierBuilderProvider();
    }

    protected boolean isUsableForDecryption(Subkey subkey) {
        return subkey != null && subkey.isForDecryption() && (subkey.isUnlocked() || !Util.isEmpty(subkey.passphraseChars));
    }

    protected PublicKeyDataDecryptorFactory buildPublicKeyDecryptor(Subkey subkey) throws PGPException {
        PGPPrivateKey privateKey = subkey.getPrivateKey();
        if (privateKey == null) {
            throw new PGPException("no private key for " + subkey);
        }
        return new BcPublicKeyDataDecryptorFactory(privateKey);
    }

    protected PBEDataDecryptorFactory buildSymmetricKeyDecryptor(char[] passphraseChars) {
        return new BcPBEDataDecryptorFactory(passphraseChars, new BcPGPDigestCalculatorProvider());
    }

    protected byte[] getCopyBuffer() {
        return new byte[16384];
    }

    protected class Verifier {
        public Key key;
        public PGPSignature sig;
        public PGPOnePassSignature sig1;

        public Verifier() {
        }

        public Verifier(PGPSignature s) throws PGPException {
            this();
            this.setSig(s);
        }

        public Verifier(PGPOnePassSignature s) throws PGPException {
            this();
            this.setSig1(s);
        }

        public boolean isKeyAvailable() {
            return this.key != null;
        }

        public void setSig(PGPSignature s) throws PGPException {
            this.sig = s;
            if (this.sig1 != null) {
                return;
            }
            Subkey subkey = this.findVerificationSubkey(s.getKeyID());
            if (subkey != null) {
                s.init(Decryptor.this.getVerifierProvider(), subkey.getPublicKey());
            }
        }

        public void setSig1(PGPOnePassSignature s) throws PGPException {
            this.sig1 = s;
            Subkey subkey = this.findVerificationSubkey(s.getKeyID());
            if (subkey != null) {
                s.init(Decryptor.this.getVerifierProvider(), subkey.getPublicKey());
            }
        }

        public boolean match(PGPSignature s) {
            if (this.sig1 != null && this.sig1.getKeyID() == s.getKeyID()) {
                this.sig = s;
                return true;
            }
            return false;
        }

        public boolean verify() throws PGPException {
            if (this.key == null || this.sig == null) {
                return false;
            }
            return this.sig1 != null ? this.sig1.verify(this.sig) : this.sig.verify();
        }

        public Key getSignedBy() throws PGPException {
            if (this.key == null || this.sig == null) {
                return null;
            }
            String uid = null;
            PGPSignatureSubpacketVector subpackets = this.sig.getHashedSubPackets();
            if (subpackets != null) {
                uid = subpackets.getSignerUserID();
            }
            Key by = this.key.toPublicKey();
            by.setSigningUid(uid != null ? uid : "");
            return by;
        }

        private Subkey findVerificationSubkey(Long id) {
            List<Key> keys = Decryptor.this.ring.findAll(id);
            for (Key key : keys) {
                Subkey subkey = key.findById(id);
                if (subkey != null && subkey.isForVerification()) {
                    Decryptor.this.log.info("using verification key {}", (Object)subkey);
                    this.key = key;
                    return subkey;
                }
                Decryptor.this.log.info("not using verification key {}", (Object)subkey);
            }
            if (Util.isEmpty(keys)) {
                Decryptor.this.log.info("not found verification key {}", (Object)Util.formatKeyId(id));
            }
            return null;
        }
    }
}

