/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.springframework.integration.support.management.Statistics;

@Deprecated
public class ExponentialMovingAverage {
    private volatile long count;
    private volatile double min = Double.MAX_VALUE;
    private volatile double max;
    private final Deque<Double> samples = new ArrayDeque<Double>();
    private final int retention;
    private final int window;
    private final double factor;

    public ExponentialMovingAverage(int window) {
        this(window, 1.0);
    }

    public ExponentialMovingAverage(int window, double factor) {
        this.window = window;
        this.retention = window * 5;
        this.factor = factor;
    }

    public synchronized void reset() {
        this.count = 0L;
        this.min = Double.MAX_VALUE;
        this.max = 0.0;
        this.samples.clear();
    }

    public synchronized void append(double value) {
        if (this.samples.size() == this.retention) {
            this.samples.poll();
        }
        this.samples.add(value);
        ++this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics calc() {
        long currentCount;
        ArrayList<Double> copy;
        ExponentialMovingAverage exponentialMovingAverage = this;
        synchronized (exponentialMovingAverage) {
            copy = new ArrayList<Double>(this.samples);
            currentCount = this.count;
        }
        double sum = 0.0;
        double decay = 1.0 - 1.0 / (double)this.window;
        double sumSquares = 0.0;
        double weight = 0.0;
        double currentMin = this.min;
        double currentMax = this.max;
        for (Double value : copy) {
            if ((value = Double.valueOf(value / this.factor)) > currentMax) {
                currentMax = value;
            }
            if (value < currentMin) {
                currentMin = value;
            }
            sum = decay * sum + value;
            sumSquares = decay * sumSquares + value * value;
            weight = decay * weight + 1.0;
        }
        ExponentialMovingAverage exponentialMovingAverage2 = this;
        synchronized (exponentialMovingAverage2) {
            if (currentMax > this.max) {
                this.max = currentMax;
            }
            if (currentMin < this.min) {
                this.min = currentMin;
            }
        }
        double mean = weight > 0.0 ? sum / weight : 0.0;
        double var = weight > 0.0 ? sumSquares / weight - mean * mean : 0.0;
        double standardDeviation = var > 0.0 ? Math.sqrt(var) : 0.0;
        return new Statistics(currentCount, currentMin == Double.MAX_VALUE ? 0.0 : currentMin, currentMax, mean, standardDeviation);
    }

    public int getCount() {
        return (int)this.count;
    }

    public long getCountLong() {
        return this.count;
    }

    public double getMean() {
        return this.calc().getMean();
    }

    public double getStandardDeviation() {
        return this.calc().getStandardDeviation();
    }

    public double getMax() {
        return this.calc().getMax();
    }

    public double getMin() {
        return this.calc().getMin();
    }

    public Statistics getStatistics() {
        return this.calc();
    }

    public String toString() {
        return this.getStatistics().toString();
    }
}

