/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.json;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.boon.json.JsonFactory;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;
import org.boon.json.JsonSerializerFactory;
import org.boon.json.JsonSlurper;
import org.boon.json.ObjectMapper;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.util.ClassUtils;

@Deprecated
public class BoonJsonObjectMapper
implements JsonObjectMapper<Map<String, Object>, Object>,
BeanClassLoaderAware {
    private static final Log logger = LogFactory.getLog(BoonJsonObjectMapper.class);
    private static final Collection<Class<?>> supportedJsonTypes = Arrays.asList(String.class, byte[].class, byte[].class, File.class, InputStream.class, Reader.class);
    private final ObjectMapper objectMapper;
    private final JsonSlurper slurper = new JsonSlurper();
    private volatile ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public BoonJsonObjectMapper() {
        this.objectMapper = JsonFactory.create();
    }

    public BoonJsonObjectMapper(JsonParserFactory parserFactory, JsonSerializerFactory serializerFactory) {
        this.objectMapper = JsonFactory.create((JsonParserFactory)parserFactory, (JsonSerializerFactory)serializerFactory);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String toJson(Object value) {
        return this.objectMapper.writeValueAsString(value);
    }

    @Override
    public void toJson(Object value, Writer writer) {
        this.objectMapper.toJson(value, (Appendable)writer);
    }

    @Override
    public Map<String, Object> toJsonNode(Object value) throws IOException {
        PipedReader in = new PipedReader();
        PipedWriter out = new PipedWriter(in);
        Executors.newSingleThreadExecutor().execute(() -> this.toJson(value, out));
        return (Map)this.slurper.parse((Reader)in);
    }

    @Override
    public <T> T fromJson(Object json, Class<T> type) {
        if (json instanceof String) {
            return (T)this.objectMapper.readValue((String)json, type);
        }
        if (json instanceof byte[]) {
            return (T)this.objectMapper.readValue((byte[])json, type);
        }
        if (json instanceof char[]) {
            return (T)this.objectMapper.readValue((char[])json, type);
        }
        if (json instanceof File) {
            return (T)this.objectMapper.readValue((File)json, type);
        }
        if (json instanceof InputStream) {
            return (T)this.objectMapper.readValue((InputStream)json, type);
        }
        if (json instanceof Reader) {
            return (T)this.objectMapper.readValue((Reader)json, type);
        }
        throw new IllegalArgumentException("'json' argument must be an instance of: " + supportedJsonTypes + " , but gotten: " + json.getClass());
    }

    @Override
    public <T> T fromJson(Object json, Map<String, Object> javaTypes) throws IOException {
        JsonParserAndMapper parser = this.objectMapper.parser();
        Class<?> classType = this.createJavaType(javaTypes, "json__TypeId__");
        Class<?> contentClassType = this.createJavaType(javaTypes, "json__ContentTypeId__");
        Class<?> keyClassType = this.createJavaType(javaTypes, "json__KeyTypeId__");
        if (keyClassType != null) {
            logger.warn((Object)"Boon doesn't support the Map 'key' conversion. Will be returned raw Map<String, Object>");
            if (json instanceof String) {
                return (T)parser.parseMap((String)json);
            }
            if (json instanceof byte[]) {
                return (T)parser.parseMap((byte[])json);
            }
            if (json instanceof char[]) {
                return (T)parser.parseMap((char[])json);
            }
            if (json instanceof File) {
                return (T)parser.parseMap((Reader)new FileReader((File)json));
            }
            if (json instanceof InputStream) {
                return (T)parser.parseMap((InputStream)json);
            }
            if (json instanceof Reader) {
                return (T)parser.parseMap((Reader)json);
            }
            throw new IllegalArgumentException("'json' argument must be an instance of: " + supportedJsonTypes + " , but gotten: " + json.getClass());
        }
        if (contentClassType != null) {
            if (json instanceof String) {
                return (T)this.objectMapper.readValue((String)json, classType, contentClassType);
            }
            if (json instanceof byte[]) {
                return (T)this.objectMapper.readValue((byte[])json, classType, contentClassType);
            }
            if (json instanceof char[]) {
                return (T)this.objectMapper.readValue((char[])json, classType, contentClassType);
            }
            if (json instanceof File) {
                return (T)this.objectMapper.readValue((File)json, classType, contentClassType);
            }
            if (json instanceof InputStream) {
                return (T)this.objectMapper.readValue((InputStream)json, classType, contentClassType);
            }
            if (json instanceof Reader) {
                return (T)this.objectMapper.readValue((Reader)json, classType, contentClassType);
            }
            throw new IllegalArgumentException("'json' argument must be an instance of: " + supportedJsonTypes + " , but gotten: " + json.getClass());
        }
        return (T)this.fromJson(json, classType);
    }

    protected Class<?> createJavaType(Map<String, Object> javaTypes, String javaTypeKey) {
        Object classValue = javaTypes.get(javaTypeKey);
        if (classValue instanceof Class) {
            return (Class)classValue;
        }
        if (classValue != null) {
            try {
                return ClassUtils.forName((String)classValue.toString(), (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public <T> T fromJson(Object parser, Type valueType) {
        throw new UnsupportedOperationException("Boon doesn't support JSON reader parser abstraction");
    }
}

