/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.graph;

import java.util.function.Supplier;
import org.springframework.integration.graph.EndpointNode;
import org.springframework.integration.graph.IntegrationNode;
import org.springframework.integration.graph.SendTimers;
import org.springframework.integration.graph.SendTimersAware;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.Statistics;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHandler;

public class MessageHandlerNode
extends EndpointNode
implements SendTimersAware {
    private final String input;
    private Supplier<SendTimers> sendTimers;

    public MessageHandlerNode(int nodeId, String name, MessageHandler handler, String input, String output) {
        super(nodeId, name, handler, output, handler instanceof MessageHandlerMetrics ? new Stats((MessageHandlerMetrics)handler) : new IntegrationNode.Stats());
        this.input = input;
    }

    public String getInput() {
        return this.input;
    }

    @Nullable
    public SendTimers getSendTimers() {
        return this.sendTimers != null ? this.sendTimers.get() : null;
    }

    @Override
    public void sendTimers(Supplier<SendTimers> timers) {
        this.sendTimers = timers;
    }

    public static final class Stats
    extends IntegrationNode.Stats {
        private final MessageHandlerMetrics handler;

        Stats(MessageHandlerMetrics handler) {
            this.handler = handler;
        }

        @Override
        protected boolean isAvailable() {
            return this.handler.isCountsEnabled();
        }

        public boolean isLoggingEnabled() {
            return this.handler.isLoggingEnabled();
        }

        public long getHandleCount() {
            return this.handler.getHandleCountLong();
        }

        public long getErrorCount() {
            return this.handler.getErrorCountLong();
        }

        public double getMeanDuration() {
            return this.handler.getMeanDuration();
        }

        public double getMinDuration() {
            return this.handler.getMinDuration();
        }

        public double getMaxDuration() {
            return this.handler.getMaxDuration();
        }

        public double getStandardDeviationDuration() {
            return this.handler.getStandardDeviationDuration();
        }

        public long getActiveCount() {
            return this.handler.getActiveCountLong();
        }

        public Statistics getDuration() {
            return this.handler.getDuration();
        }

        public boolean isStatsEnabled() {
            return this.handler.isStatsEnabled();
        }

        public boolean isCountsEnabled() {
            return this.handler.isCountsEnabled();
        }
    }
}

