/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.integration.context.ExpressionCapable;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class IntegrationNode {
    private final int nodeId;
    private final String nodeName;
    private final Stats stats;
    private final String componentType;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> unmodifiableProperties = Collections.unmodifiableMap(this.properties);

    protected IntegrationNode(int nodeId, String name, Object nodeObject, Stats stats) {
        Expression expression;
        this.nodeId = nodeId;
        this.nodeName = name;
        this.componentType = nodeObject instanceof NamedComponent ? ((NamedComponent)nodeObject).getComponentType() : nodeObject.getClass().getSimpleName();
        this.stats = stats;
        if (nodeObject instanceof ExpressionCapable && (expression = ((ExpressionCapable)nodeObject).getExpression()) != null) {
            this.properties.put("expression", expression.getExpressionString());
        }
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getName() {
        return this.nodeName;
    }

    public final String getComponentType() {
        return this.componentType;
    }

    public Stats getStats() {
        return this.stats.isAvailable() ? this.stats : null;
    }

    public Map<String, Object> getProperties() {
        return this.unmodifiableProperties;
    }

    public void addProperty(String name, Object value) {
        Assert.hasText((String)name, (String)"'name' must not be null");
        this.properties.put(name, value);
    }

    public void addProperties(@Nullable Map<String, Object> props) {
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    public static class Stats {
        protected boolean isAvailable() {
            return false;
        }

        public String getDeprecated() {
            return "stats are deprecated in favor of sendTimers and receiveCounters";
        }
    }
}

