/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.ChannelUtils;
import org.springframework.integration.channel.MessageChannelReactiveUtils;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.IntegrationConsumer;
import org.springframework.integration.router.MessageRouter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;

public class ReactiveStreamsConsumer
extends AbstractEndpoint
implements IntegrationConsumer {
    private final MessageChannel inputChannel;
    private final MessageHandler handler;
    private final Publisher<Message<Object>> publisher;
    private final Subscriber<Message<?>> subscriber;
    private final Lifecycle lifecycleDelegate;
    private ErrorHandler errorHandler;
    private volatile Subscription subscription;

    public ReactiveStreamsConsumer(MessageChannel inputChannel, MessageHandler messageHandler) {
        this(inputChannel, (Subscriber<Message<?>>)(messageHandler instanceof Subscriber ? (Subscriber)messageHandler : new MessageHandlerSubscriber(messageHandler)));
    }

    public ReactiveStreamsConsumer(MessageChannel inputChannel, Subscriber<Message<?>> subscriber) {
        this.inputChannel = inputChannel;
        Assert.notNull((Object)inputChannel, (String)"'inputChannel' must not be null");
        Assert.notNull(subscriber, (String)"'subscriber' must not be null");
        if (inputChannel instanceof NullChannel && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"The consuming from the NullChannel does not have any effects: it doesn't forward messages sent to it. A NullChannel is the end of the flow.");
        }
        this.publisher = MessageChannelReactiveUtils.toPublisher(inputChannel);
        this.subscriber = subscriber;
        Lifecycle lifecycle = this.lifecycleDelegate = subscriber instanceof Lifecycle ? (Lifecycle)subscriber : null;
        this.handler = subscriber instanceof MessageHandlerSubscriber ? ((MessageHandlerSubscriber)subscriber).messageHandler : (subscriber instanceof MessageHandler ? (MessageHandler)subscriber : arg_0 -> this.subscriber.onNext(arg_0));
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public MessageChannel getInputChannel() {
        return this.inputChannel;
    }

    @Override
    public MessageChannel getOutputChannel() {
        if (this.handler instanceof MessageProducer) {
            return ((MessageProducer)this.handler).getOutputChannel();
        }
        if (this.handler instanceof MessageRouter) {
            return ((MessageRouter)this.handler).getDefaultOutputChannel();
        }
        return null;
    }

    @Override
    public MessageHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (this.errorHandler == null) {
            this.errorHandler = ChannelUtils.getErrorHandler(this.getBeanFactory());
        }
    }

    @Override
    protected void doStart() {
        if (this.lifecycleDelegate != null) {
            this.lifecycleDelegate.start();
        }
        this.publisher.subscribe((Subscriber)new DelegatingSubscriber());
    }

    @Override
    protected void doStop() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        if (this.lifecycleDelegate != null) {
            this.lifecycleDelegate.stop();
        }
    }

    private static final class MessageHandlerSubscriber
    implements CoreSubscriber<Message<?>>,
    Disposable,
    Lifecycle {
        private final Consumer<Message<?>> consumer;
        private Subscription subscription;
        private final MessageHandler messageHandler;

        MessageHandlerSubscriber(MessageHandler messageHandler) {
            Assert.notNull((Object)messageHandler, (String)"'messageHandler' must not be null");
            this.messageHandler = messageHandler;
            this.consumer = arg_0 -> ((MessageHandler)this.messageHandler).handleMessage(arg_0);
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
            s.request(Long.MAX_VALUE);
        }

        public void onNext(Message<?> message) {
            this.consumer.accept(message);
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
            this.dispose();
        }

        public void dispose() {
            Subscription s = this.subscription;
            if (s != null) {
                this.subscription = null;
                s.cancel();
            }
        }

        public boolean isDisposed() {
            return this.subscription == null;
        }

        public void start() {
            if (this.messageHandler instanceof Lifecycle) {
                ((Lifecycle)this.messageHandler).start();
            }
        }

        public void stop() {
            if (this.messageHandler instanceof Lifecycle) {
                ((Lifecycle)this.messageHandler).stop();
            }
        }

        public boolean isRunning() {
            return !(this.messageHandler instanceof Lifecycle) || ((Lifecycle)this.messageHandler).isRunning();
        }
    }

    private final class DelegatingSubscriber
    extends BaseSubscriber<Message<?>> {
        private final Subscriber<Message<?>> delegate;

        DelegatingSubscriber() {
            this.delegate = ReactiveStreamsConsumer.this.subscriber;
        }

        public void hookOnSubscribe(Subscription s) {
            ReactiveStreamsConsumer.this.subscription = s;
            this.delegate.onSubscribe(s);
        }

        public void hookOnNext(Message<?> message) {
            try {
                this.delegate.onNext(message);
            }
            catch (Exception e) {
                ReactiveStreamsConsumer.this.errorHandler.handleError((Throwable)e);
                this.hookOnError(e);
            }
        }

        public void hookOnError(Throwable t) {
            this.delegate.onError(t);
        }

        public void hookOnComplete() {
            this.delegate.onComplete();
        }
    }
}

