/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.config.IntegrationManagementConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public class IntegrationManagementConfiguration
implements ImportAware,
EnvironmentAware {
    private AnnotationAttributes attributes;
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map map = importMetadata.getAnnotationAttributes(EnableIntegrationManagement.class.getName());
        this.attributes = AnnotationAttributes.fromMap((Map)map);
        Assert.notNull((Object)this.attributes, () -> "@EnableIntegrationManagement is not present on importing class " + importMetadata.getClassName());
    }

    @Bean(name={"integrationManagementConfigurer"})
    @Role(value=2)
    public IntegrationManagementConfigurer managementConfigurer() {
        IntegrationManagementConfigurer configurer = new IntegrationManagementConfigurer();
        this.setupCountsEnabledNamePatterns(configurer);
        this.setupStatsEnabledNamePatterns(configurer);
        configurer.setDefaultLoggingEnabled(Boolean.parseBoolean(this.environment.resolvePlaceholders((String)this.attributes.get((Object)"defaultLoggingEnabled"))));
        configurer.setDefaultCountsEnabled(Boolean.parseBoolean(this.environment.resolvePlaceholders((String)this.attributes.get((Object)"defaultCountsEnabled"))));
        configurer.setDefaultStatsEnabled(Boolean.parseBoolean(this.environment.resolvePlaceholders((String)this.attributes.get((Object)"defaultStatsEnabled"))));
        configurer.setMetricsFactoryBeanName((String)this.attributes.get((Object)"metricsFactory"));
        return configurer;
    }

    private void setupCountsEnabledNamePatterns(IntegrationManagementConfigurer configurer) {
        String[] countsEnabled;
        ArrayList<String> patterns = new ArrayList<String>();
        for (String managedComponent : countsEnabled = this.attributes.getStringArray("countsEnabled")) {
            String pattern = this.environment.resolvePlaceholders(managedComponent);
            patterns.addAll(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)pattern)));
        }
        configurer.setEnabledCountsPatterns(patterns.toArray(new String[0]));
    }

    private void setupStatsEnabledNamePatterns(IntegrationManagementConfigurer configurer) {
        String[] statsEnabled;
        ArrayList<String> patterns = new ArrayList<String>();
        for (String managedComponent : statsEnabled = this.attributes.getStringArray("statsEnabled")) {
            String pattern = this.environment.resolvePlaceholders(managedComponent);
            patterns.addAll(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)pattern)));
        }
        configurer.setEnabledStatsPatterns(patterns.toArray(new String[0]));
    }
}

