/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.scp;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpFileOpenerHolder;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ManagedExecutorServiceSupplier;
import org.apache.sshd.server.command.AbstractDelegatingCommandFactory;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.scp.ScpCommand;

public class ScpCommandFactory
extends AbstractDelegatingCommandFactory
implements ManagedExecutorServiceSupplier,
ScpFileOpenerHolder,
Cloneable {
    public static final String SCP_FACTORY_NAME = "scp";
    private Supplier<? extends CloseableExecutorService> executorsProvider;
    private ScpFileOpener fileOpener;
    private int sendBufferSize = 127;
    private int receiveBufferSize = 127;
    private Collection<ScpTransferEventListener> listeners = new CopyOnWriteArraySet<ScpTransferEventListener>();
    private ScpTransferEventListener listenerProxy = (ScpTransferEventListener)EventListenerUtils.proxyWrapper(ScpTransferEventListener.class, (ClassLoader)this.getClass().getClassLoader(), this.listeners);

    public ScpCommandFactory() {
        super(SCP_FACTORY_NAME);
    }

    @Override
    public ScpFileOpener getScpFileOpener() {
        return this.fileOpener;
    }

    @Override
    public void setScpFileOpener(ScpFileOpener fileOpener) {
        this.fileOpener = fileOpener;
    }

    public Supplier<? extends CloseableExecutorService> getExecutorServiceProvider() {
        return this.executorsProvider;
    }

    public void setExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider) {
        this.executorsProvider = provider;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendSize) {
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveSize) {
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() receive buffer size (" + receiveSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
    }

    public boolean addEventListener(ScpTransferEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No listener instance");
        }
        return this.listeners.add(listener);
    }

    public boolean removeEventListener(ScpTransferEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No listener instance");
        }
        return this.listeners.remove(listener);
    }

    public boolean isSupportedCommand(String command) {
        if (GenericUtils.isEmpty((CharSequence)command)) {
            return false;
        }
        return command.startsWith(SCP_FACTORY_NAME);
    }

    protected Command executeSupportedCommand(String command) {
        return new ScpCommand(command, this.resolveExecutorService(command), this.getSendBufferSize(), this.getReceiveBufferSize(), this.getScpFileOpener(), this.listenerProxy);
    }

    protected CloseableExecutorService resolveExecutorService(String command) {
        return this.resolveExecutorService();
    }

    public ScpCommandFactory clone() {
        try {
            ScpCommandFactory other = (ScpCommandFactory)this.getClass().cast(super.clone());
            other.listeners = new CopyOnWriteArraySet<ScpTransferEventListener>(this.listeners);
            other.listenerProxy = (ScpTransferEventListener)EventListenerUtils.proxyWrapper(ScpTransferEventListener.class, (ClassLoader)this.getClass().getClassLoader(), other.listeners);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    implements ObjectBuilder<ScpCommandFactory> {
        private final ScpCommandFactory factory = new ScpCommandFactory();

        public Builder withFileOpener(ScpFileOpener opener) {
            this.factory.setScpFileOpener(opener);
            return this;
        }

        public Builder withDelegate(CommandFactory delegate) {
            this.factory.setDelegateCommandFactory(delegate);
            return this;
        }

        public Builder withExecutorServiceProvider(Supplier<? extends CloseableExecutorService> provider) {
            this.factory.setExecutorServiceProvider(provider);
            return this;
        }

        public Builder withSendBufferSize(int sendSize) {
            this.factory.setSendBufferSize(sendSize);
            return this;
        }

        public Builder withReceiveBufferSize(int receiveSize) {
            this.factory.setReceiveBufferSize(receiveSize);
            return this;
        }

        public Builder addEventListener(ScpTransferEventListener listener) {
            this.factory.addEventListener(listener);
            return this;
        }

        public Builder removeEventListener(ScpTransferEventListener listener) {
            this.factory.removeEventListener(listener);
            return this;
        }

        public ScpCommandFactory build() {
            return this.factory.clone();
        }
    }
}

