/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;

public class InteractivePasswordIdentityProvider
implements Iterator<String>,
SessionHolder<ClientSession>,
ClientSessionHolder {
    protected static final String EOF = "EOF";
    private ClientSession clientSession;
    private UserInteraction userInteraction;
    private String prompt;
    private AtomicReference<String> nextPassword = new AtomicReference();

    public InteractivePasswordIdentityProvider(ClientSession clientSession, UserInteraction userInteraction, String prompt) {
        this.clientSession = Objects.requireNonNull(clientSession, "No client session provided");
        this.userInteraction = Objects.requireNonNull(userInteraction, "No user interaction instance configured");
        this.prompt = prompt;
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public ClientSession getSession() {
        return this.getClientSession();
    }

    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public boolean hasNext() {
        String password = this.nextPassword.get();
        if (GenericUtils.isEmpty((CharSequence)password)) {
            password = this.resolveNextPassword();
            if (GenericUtils.isEmpty((CharSequence)password)) {
                password = EOF;
            }
            this.nextPassword.set(password);
        }
        return !GenericUtils.isSameReference((Object)password, (Object)EOF);
    }

    @Override
    public String next() {
        String password = this.nextPassword.get();
        if (password == null) {
            throw new IllegalStateException("hasNext() not called before next()");
        }
        if (GenericUtils.isSameReference((Object)password, (Object)EOF)) {
            throw new NoSuchElementException("All passwords exhausted");
        }
        this.nextPassword.set(null);
        return password;
    }

    protected String resolveNextPassword() {
        ClientSession session = this.getClientSession();
        UserInteraction ui = this.getUserInteraction();
        if (!ui.isInteractionAllowed(session)) {
            return null;
        }
        return ui.getUpdatedPassword(session, this.getPrompt(), "");
    }

    public static PasswordIdentityProvider providerOf(ClientSession clientSession, String prompt) {
        return InteractivePasswordIdentityProvider.providerOf(clientSession, clientSession == null ? null : clientSession.getUserInteraction(), prompt);
    }

    public static PasswordIdentityProvider providerOf(ClientSession clientSession, UserInteraction userInteraction, String prompt) {
        Objects.requireNonNull(clientSession, "No client session provided");
        Objects.requireNonNull(userInteraction, "No user interaction instance configured");
        Iterable passwords = () -> new InteractivePasswordIdentityProvider(clientSession, userInteraction, prompt);
        return () -> passwords;
    }
}

