/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.throttle.ChannelStreamPacketWriterResolver;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Int2IntFunction;
import org.apache.sshd.common.util.Invoker;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;

public abstract class AbstractChannel
extends AbstractInnerCloseable
implements Channel,
ExecutorServiceCarrier {
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add((int)8);
    protected ConnectionService service;
    protected final AtomicBoolean initialized = new AtomicBoolean(false);
    protected final AtomicBoolean eofReceived = new AtomicBoolean(false);
    protected final AtomicBoolean eofSent = new AtomicBoolean(false);
    protected AtomicReference<GracefulState> gracefulState = new AtomicReference<GracefulState>(GracefulState.Opened);
    protected final DefaultCloseFuture gracefulFuture;
    protected final Collection<ChannelListener> channelListeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final ChannelListener channelListenerProxy;
    private int id = -1;
    private int recipient = -1;
    private Session sessionInstance;
    private CloseableExecutorService executor;
    private final List<RequestHandler<Channel>> requestHandlers = new CopyOnWriteArrayList<RequestHandler<Channel>>();
    private final Window localWindow;
    private final Window remoteWindow;
    private ChannelStreamPacketWriterResolver channelStreamPacketWriterResolver;
    private final Map<String, Date> pendingRequests = new ConcurrentHashMap<String, Date>();
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Map<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();

    protected AbstractChannel(boolean client) {
        this("", client);
    }

    protected AbstractChannel(boolean client, Collection<? extends RequestHandler<Channel>> handlers) {
        this("", client, handlers, null);
    }

    protected AbstractChannel(String discriminator, boolean client) {
        this(discriminator, client, Collections.emptyList(), null);
    }

    protected AbstractChannel(String discriminator, boolean client, Collection<? extends RequestHandler<Channel>> handlers, CloseableExecutorService executorService) {
        super(discriminator);
        this.gracefulFuture = new DefaultCloseFuture((Object)discriminator, this.futureLock);
        this.localWindow = new Window(this, null, client, true);
        this.remoteWindow = new Window(this, null, client, false);
        this.channelListenerProxy = (ChannelListener)EventListenerUtils.proxyWrapper(ChannelListener.class, (ClassLoader)this.getClass().getClassLoader(), this.channelListeners);
        this.executor = executorService;
        this.addRequestHandlers(handlers);
    }

    @Override
    public List<RequestHandler<Channel>> getRequestHandlers() {
        return this.requestHandlers;
    }

    @Override
    public void addRequestHandler(RequestHandler<Channel> handler) {
        this.requestHandlers.add(Objects.requireNonNull(handler, "No handler instance"));
    }

    @Override
    public void removeRequestHandler(RequestHandler<Channel> handler) {
        this.requestHandlers.remove(Objects.requireNonNull(handler, "No handler instance"));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getRecipient() {
        return this.recipient;
    }

    protected void setRecipient(int recipient) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setRecipient({}) recipient={}", (Object)this, (Object)recipient);
        }
        this.recipient = recipient;
    }

    @Override
    public Window getLocalWindow() {
        return this.localWindow;
    }

    @Override
    public Window getRemoteWindow() {
        return this.remoteWindow;
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    public PropertyResolver getParentPropertyResolver() {
        return this.getSession();
    }

    public CloseableExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public ChannelStreamPacketWriterResolver getChannelStreamPacketWriterResolver() {
        return this.channelStreamPacketWriterResolver;
    }

    @Override
    public void setChannelStreamPacketWriterResolver(ChannelStreamPacketWriterResolver resolver) {
        this.channelStreamPacketWriterResolver = resolver;
    }

    @Override
    public ChannelStreamPacketWriterResolver resolveChannelStreamPacketWriterResolver() {
        ChannelStreamPacketWriterResolver resolver = this.getChannelStreamPacketWriterResolver();
        if (resolver != null) {
            return resolver;
        }
        Session manager = this.getSession();
        return manager.resolveChannelStreamPacketWriterResolver();
    }

    protected Date addPendingRequest(String request, boolean wantReply) {
        if (!wantReply) {
            return null;
        }
        Date pending = new Date(System.currentTimeMillis());
        Date prev = this.pendingRequests.put(request, pending);
        ValidateUtils.checkTrue((prev == null ? 1 : 0) != 0, (String)"Multiple pending requests of type=%s", (Object)request);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPendingRequest({}) request={}, pending={}", new Object[]{this, request, pending});
        }
        return pending;
    }

    protected Date removePendingRequest(String request) {
        Date pending = this.pendingRequests.remove(request);
        if (this.log.isDebugEnabled()) {
            this.log.debug("removePendingRequest({}) request={}, pending={}", new Object[]{this, request, pending});
        }
        return pending;
    }

    @Override
    public void handleRequest(Buffer buffer) throws IOException {
        this.handleChannelRequest(buffer.getString(), buffer.getBoolean(), buffer);
    }

    protected void handleChannelRequest(String req, boolean wantReply, Buffer buffer) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleChannelRequest({}) SSH_MSG_CHANNEL_REQUEST {} wantReply={}", new Object[]{this, req, wantReply});
        }
        List<RequestHandler<Channel>> handlers = this.getRequestHandlers();
        boolean traceEnabled = this.log.isTraceEnabled();
        for (RequestHandler requestHandler : handlers) {
            RequestHandler.Result result;
            try {
                result = requestHandler.process(this, req, wantReply, buffer);
            }
            catch (Throwable e) {
                this.log.warn("handleRequest({}) {} while {}#process({})[want-reply={}]: {}", new Object[]{this, e.getClass().getSimpleName(), requestHandler.getClass().getSimpleName(), req, wantReply, e.getMessage()});
                if (debugEnabled) {
                    this.log.debug("handleRequest(" + this + ") request=" + req + "[want-reply=" + wantReply + "] processing failure details", e);
                }
                result = RequestHandler.Result.ReplyFailure;
            }
            if (RequestHandler.Result.Unsupported.equals((Object)result)) {
                if (!traceEnabled) continue;
                this.log.trace("handleRequest({})[{}#process({})[want-reply={}]]: {}", new Object[]{this, requestHandler.getClass().getSimpleName(), req, wantReply, result});
                continue;
            }
            this.sendResponse(buffer, req, result, wantReply);
            return;
        }
        this.handleUnknownChannelRequest(req, wantReply, buffer);
    }

    protected void handleUnknownChannelRequest(String req, boolean wantReply, Buffer buffer) throws IOException {
        RequestHandler.Result r = this.handleInternalRequest(req, wantReply, buffer);
        if (r == null || RequestHandler.Result.Unsupported.equals((Object)r)) {
            this.log.warn("handleUnknownChannelRequest({}) Unknown channel request: {}[want-reply={}]", new Object[]{this, req, wantReply});
            this.sendResponse(buffer, req, RequestHandler.Result.Unsupported, wantReply);
        } else {
            this.sendResponse(buffer, req, r, wantReply);
        }
    }

    protected RequestHandler.Result handleInternalRequest(String req, boolean wantReply, Buffer buffer) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleInternalRequest({})[want-reply={}] unknown type: {}", new Object[]{this, wantReply, req});
        }
        return RequestHandler.Result.Unsupported;
    }

    protected IoWriteFuture sendResponse(Buffer buffer, String req, RequestHandler.Result result, boolean wantReply) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendResponse({}) request={} result={}, want-reply={}", new Object[]{this, req, result, wantReply});
        }
        if (RequestHandler.Result.Replied.equals((Object)result) || !wantReply) {
            return new AbstractIoWriteFuture(req, null){
                {
                    this.setValue(Boolean.TRUE);
                }
            };
        }
        byte cmd = RequestHandler.Result.ReplySuccess.equals((Object)result) ? (byte)99 : 100;
        Session session = this.getSession();
        Buffer rsp = session.createBuffer(cmd, 4);
        rsp.putInt((long)this.recipient);
        return session.writePacket(rsp);
    }

    @Override
    public void init(ConnectionService service, Session session, int id) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("init() service={} session={} id={}", new Object[]{service, session, id});
        }
        this.service = service;
        this.sessionInstance = session;
        this.id = id;
        this.signalChannelInitialized();
        this.configureWindow();
        this.initialized.set(true);
    }

    protected void signalChannelInitialized() throws IOException {
        try {
            this.invokeChannelSignaller((Invoker<ChannelListener, Void>)((Invoker)l -> {
                this.signalChannelInitialized((ChannelListener)l);
                return null;
            }));
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException((Throwable)err);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException("Failed (" + e.getClass().getSimpleName() + ") to notify channel " + this + " initialization: " + e.getMessage(), e);
        }
    }

    protected void signalChannelInitialized(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        listener.channelInitialized(this);
    }

    protected void signalChannelOpenSuccess() {
        try {
            this.invokeChannelSignaller((Invoker<ChannelListener, Void>)((Invoker)l -> {
                this.signalChannelOpenSuccess((ChannelListener)l);
                return null;
            }));
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof Error) {
                throw (Error)err;
            }
            throw new RuntimeException(err);
        }
    }

    protected void signalChannelOpenSuccess(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        listener.channelOpenSuccess(this);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    protected void signalChannelOpenFailure(Throwable reason) {
        block4: {
            try {
                this.invokeChannelSignaller((Invoker<ChannelListener, Void>)((Invoker)l -> {
                    this.signalChannelOpenFailure((ChannelListener)l, reason);
                    return null;
                }));
            }
            catch (Throwable err) {
                Object[] suppressed;
                Throwable ignored = GenericUtils.peelException((Throwable)err);
                this.log.warn("signalChannelOpenFailure({}) failed ({}) to inform listener of open failure={}: {}", new Object[]{this, ignored.getClass().getSimpleName(), reason.getClass().getSimpleName(), ignored.getMessage()});
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doInit(" + this + ") inform listener open failure details", ignored);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length((Object[])(suppressed = ignored.getSuppressed())) <= 0) break block4;
                for (Object s : suppressed) {
                    this.log.trace("signalChannelOpenFailure(" + this + ") suppressed channel open failure signalling", (Throwable)s);
                }
            }
        }
    }

    protected void signalChannelOpenFailure(ChannelListener listener, Throwable reason) {
        if (listener == null) {
            return;
        }
        listener.channelOpenFailure(this, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChanged(String hint) {
        try {
            this.invokeChannelSignaller((Invoker<ChannelListener, Void>)((Invoker)l -> {
                this.notifyStateChanged((ChannelListener)l, hint);
                return null;
            }));
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException((Throwable)err);
            this.log.warn("notifyStateChanged({})[{}] {} while signal channel state change: {}", new Object[]{this, hint, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("notifyStateChanged(" + this + ")[" + hint + "] channel state signalling failure details", e);
            }
        }
        finally {
            Object object = this.futureLock;
            synchronized (object) {
                this.futureLock.notifyAll();
            }
        }
    }

    protected void notifyStateChanged(ChannelListener listener, String hint) {
        if (listener == null) {
            return;
        }
        listener.channelStateChanged(this, hint);
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        ChannelListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while channel is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.channelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        ChannelListener.validateListener(listener);
        if (this.channelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public void handleClose() throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleClose({}) SSH_MSG_CHANNEL_CLOSE", (Object)this);
        }
        if (!this.isEofSent() && debugEnabled) {
            this.log.debug("handleClose({}) prevent sending EOF", (Object)this);
        }
        if (this.gracefulState.compareAndSet(GracefulState.Opened, GracefulState.CloseReceived)) {
            this.close(false);
        } else if (this.gracefulState.compareAndSet(GracefulState.CloseSent, GracefulState.Closed)) {
            this.gracefulFuture.setClosed();
        }
    }

    protected Closeable getInnerCloseable() {
        Closeable closer = this.builder().sequential(new Closeable[]{new GracefulChannelCloseable(), this.getExecutorService()}).run((Object)this.toString(), () -> {
            if (this.service != null) {
                this.service.unregisterChannel(this);
            }
        }).build();
        closer.addCloseFutureListener(future -> this.clearAttributes());
        return closer;
    }

    protected void preClose() {
        if (!this.isEofSent()) {
            this.log.debug("close({}) prevent sending EOF", (Object)this);
        }
        try {
            this.signalChannelClosed(null);
        }
        finally {
            this.channelListeners.clear();
        }
        IOException err = IoUtils.closeQuietly((java.io.Closeable[])new java.io.Closeable[]{this.getLocalWindow(), this.getRemoteWindow()});
        if (err != null) {
            Object[] suppressed;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed (" + err.getClass().getSimpleName() + ") to pre-close window(s) of " + this + ": " + err.getMessage());
            }
            if (this.log.isTraceEnabled() && GenericUtils.length((Object[])(suppressed = err.getSuppressed())) > 0) {
                for (Object t : suppressed) {
                    this.log.trace("Suppressed " + t.getClass().getSimpleName() + ") while pre-close window(s) of " + this + ": " + ((Throwable)t).getMessage());
                }
            }
        }
        super.preClose();
    }

    public void signalChannelClosed(Throwable reason) {
        block4: {
            try {
                this.invokeChannelSignaller((Invoker<ChannelListener, Void>)((Invoker)l -> {
                    this.signalChannelClosed((ChannelListener)l, reason);
                    return null;
                }));
            }
            catch (Throwable err) {
                Object[] suppressed;
                Throwable e = GenericUtils.peelException((Throwable)err);
                this.log.warn("signalChannelClosed({}) {} while signal channel closed: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
                if (this.log.isDebugEnabled()) {
                    this.log.debug("signalChannelClosed(" + this + ") channel closed signalling failure details", e);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length((Object[])(suppressed = e.getSuppressed())) <= 0) break block4;
                for (Object s : suppressed) {
                    this.log.trace("signalChannelClosed(" + this + ") suppressed closed channel signalling failure", (Throwable)s);
                }
            }
        }
    }

    protected void signalChannelClosed(ChannelListener listener, Throwable reason) {
        if (listener == null) {
            return;
        }
        listener.channelClosed(this, reason);
    }

    protected void invokeChannelSignaller(Invoker<ChannelListener, Void> invoker) throws Throwable {
        Session session = this.getSession();
        FactoryManager manager = session == null ? null : session.getFactoryManager();
        ChannelListener[] listeners = new ChannelListener[]{manager == null ? null : manager.getChannelListenerProxy(), session == null ? null : session.getChannelListenerProxy(), this.getChannelListenerProxy()};
        Throwable err = null;
        for (ChannelListener l : listeners) {
            if (l == null) continue;
            try {
                invoker.invoke((Object)l);
            }
            catch (Throwable t) {
                err = GenericUtils.accumulateException(err, (Throwable)t);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        Session s = this.getSession();
        if (!this.isClosing()) {
            return s.writePacket(buffer);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("writePacket({}) Discarding output packet because channel is being closed", (Object)this);
        }
        return new AbstractIoWriteFuture(s.toString(), null){
            {
                this.setValue(new EOFException("Channel is being closed"));
            }
        };
    }

    @Override
    public void handleData(Buffer buffer) throws IOException {
        long len = this.validateIncomingDataSize(94, buffer.getUInt());
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleData({}) SSH_MSG_CHANNEL_DATA len={}", (Object)this, (Object)len);
        }
        if (this.log.isTraceEnabled()) {
            BufferUtils.dumpHex((SimplifiedLog)this.getSimplifiedLogger(), (Level)BufferUtils.DEFAULT_HEXDUMP_LEVEL, (String)("handleData(" + this + ")"), (PropertyResolver)this, (char)' ', (byte[])buffer.array(), (int)buffer.rpos(), (int)((int)len));
        }
        if (this.isEofSignalled()) {
            this.log.warn("handleData({}) extra {} bytes sent after EOF", (Object)this, (Object)len);
        }
        this.doWriteData(buffer.array(), buffer.rpos(), len);
    }

    @Override
    public void handleExtendedData(Buffer buffer) throws IOException {
        int ex = buffer.getInt();
        if (ex != 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleExtendedData({}) SSH_MSG_CHANNEL_FAILURE - non STDERR type: {}", (Object)this, (Object)ex);
            }
            Session s = this.getSession();
            Buffer rsp = s.createBuffer((byte)100, 4);
            rsp.putInt((long)this.getRecipient());
            this.writePacket(rsp);
            return;
        }
        long len = this.validateIncomingDataSize(95, buffer.getUInt());
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleExtendedData({}) SSH_MSG_CHANNEL_EXTENDED_DATA len={}", (Object)this, (Object)len);
        }
        if (this.log.isTraceEnabled()) {
            BufferUtils.dumpHex((SimplifiedLog)this.getSimplifiedLogger(), (Level)BufferUtils.DEFAULT_HEXDUMP_LEVEL, (String)("handleExtendedData(" + this + ")"), (PropertyResolver)this, (char)' ', (byte[])buffer.array(), (int)buffer.rpos(), (int)((int)len));
        }
        if (this.isEofSignalled()) {
            this.log.warn("handleExtendedData({}) extra {} bytes sent after EOF", (Object)this, (Object)len);
        }
        this.doWriteExtendedData(buffer.array(), buffer.rpos(), len);
    }

    protected long validateIncomingDataSize(int cmd, long len) {
        if (!BufferUtils.isValidUint32Value((long)len)) {
            throw new IllegalArgumentException("Non UINT32 length (" + len + ") for command=" + SshConstants.getCommandMessageName((int)cmd));
        }
        Window wLocal = this.getLocalWindow();
        long maxLocalSize = wLocal.getPacketSize();
        if (len > maxLocalSize + 4L) {
            throw new IllegalStateException("Bad length (" + len + ")  for cmd=" + SshConstants.getCommandMessageName((int)cmd) + " - max. allowed=" + maxLocalSize);
        }
        return len;
    }

    @Override
    public void handleEof() throws IOException {
        if (this.eofReceived.getAndSet(true)) {
            this.log.warn("handleEof({}) already signalled", (Object)this);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("handleEof({}) SSH_MSG_CHANNEL_EOF", (Object)this);
        }
        this.notifyStateChanged("SSH_MSG_CHANNEL_EOF");
    }

    @Override
    public boolean isEofSignalled() {
        return this.eofReceived.get();
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        int window = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWindowAdjust({}) SSH_MSG_CHANNEL_WINDOW_ADJUST window={}", (Object)this, (Object)window);
        }
        Window wRemote = this.getRemoteWindow();
        wRemote.expand(window);
        this.notifyStateChanged("SSH_MSG_CHANNEL_WINDOW_ADJUST");
    }

    @Override
    public void handleSuccess() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleFhandleSuccessailure({}) SSH_MSG_CHANNEL_SUCCESS", (Object)this);
        }
    }

    @Override
    public void handleFailure() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleFailure({}) SSH_MSG_CHANNEL_FAILURE", (Object)this);
        }
    }

    protected abstract void doWriteData(byte[] var1, int var2, long var3) throws IOException;

    protected abstract void doWriteExtendedData(byte[] var1, int var2, long var3) throws IOException;

    protected void sendEof() throws IOException {
        if (this.isClosing()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendEof({}) already closing or closed", (Object)this);
            }
            return;
        }
        if (this.eofSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendEof({}) already sent", (Object)this);
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendEof({}) SSH_MSG_CHANNEL_EOF", (Object)this);
        }
        Session s = this.getSession();
        Buffer buffer = s.createBuffer((byte)96, 16);
        buffer.putInt((long)this.getRecipient());
        this.writePacket(buffer);
    }

    public boolean isEofSent() {
        return this.eofSent.get();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.get(Objects.requireNonNull(key, "No key"));
    }

    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(key, "No key"), resolver);
    }

    public <T> T setAttribute(AttributeRepository.AttributeKey<T> key, T value) {
        return (T)this.attributes.put(Objects.requireNonNull(key, "No key"), Objects.requireNonNull(value, "No value"));
    }

    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.remove(Objects.requireNonNull(key, "No key"));
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    protected void configureWindow() {
        this.localWindow.init(this);
    }

    protected void sendWindowAdjust(long len) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWindowAdjust({}) SSH_MSG_CHANNEL_WINDOW_ADJUST len={}", (Object)this, (Object)len);
        }
        Session s = this.getSession();
        Buffer buffer = s.createBuffer((byte)93, 16);
        buffer.putInt((long)this.getRecipient());
        buffer.putInt(len);
        this.writePacket(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", recipient=" + this.getRecipient() + "]-" + this.getSession();
    }

    public class GracefulChannelCloseable
    extends IoBaseCloseable {
        private final AtomicBoolean closing = new AtomicBoolean(false);

        public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            AbstractChannel.this.gracefulFuture.addListener(listener);
        }

        public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            AbstractChannel.this.gracefulFuture.removeListener(listener);
        }

        public boolean isClosing() {
            return this.closing.get();
        }

        public void setClosing(boolean on) {
            this.closing.set(on);
        }

        public boolean isClosed() {
            return AbstractChannel.this.gracefulFuture.isClosed();
        }

        public CloseFuture close(boolean immediately) {
            AbstractChannel channel = AbstractChannel.this;
            boolean debugEnabled = this.log.isDebugEnabled();
            if (debugEnabled) {
                this.log.debug("close({})[immediately={}] processing", (Object)channel, (Object)immediately);
            }
            this.setClosing(true);
            if (immediately) {
                AbstractChannel.this.gracefulFuture.setClosed();
            } else if (!AbstractChannel.this.gracefulFuture.isClosed()) {
                if (debugEnabled) {
                    this.log.debug("close({})[immediately={}] send SSH_MSG_CHANNEL_CLOSE", (Object)channel, (Object)immediately);
                }
                Session s = AbstractChannel.this.getSession();
                Buffer buffer = s.createBuffer((byte)97, 16);
                buffer.putInt((long)AbstractChannel.this.getRecipient());
                try {
                    long timeout = channel.getLongProperty("channel-close-timeout", FactoryManager.DEFAULT_CHANNEL_CLOSE_TIMEOUT);
                    s.writePacket(buffer, timeout, TimeUnit.MILLISECONDS).addListener(future -> {
                        if (future.isWritten()) {
                            this.handleClosePacketWritten(channel, immediately);
                        } else {
                            this.handleClosePacketWriteFailure(channel, immediately, future.getException());
                        }
                    });
                }
                catch (IOException e) {
                    if (debugEnabled) {
                        this.log.debug("close({})[immediately={}] {} while writing SSH_MSG_CHANNEL_CLOSE packet on channel: {}", new Object[]{channel, immediately, e.getClass().getSimpleName(), e.getMessage()});
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("close(" + channel + ")[immediately=" + immediately + "] packet write failure details", (Throwable)e);
                    }
                    channel.close(true);
                }
            }
            CloseableExecutorService service = AbstractChannel.this.getExecutorService();
            if (service != null && !service.isShutdown()) {
                List running = service.shutdownNow();
                if (debugEnabled) {
                    this.log.debug("close({})[immediately={}] shutdown executor service on close - running count={}", new Object[]{channel, immediately, GenericUtils.size((Collection)running)});
                }
            }
            return AbstractChannel.this.gracefulFuture;
        }

        protected void handleClosePacketWritten(Channel channel, boolean immediately) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleClosePacketWritten({})[immediately={}] SSH_MSG_CHANNEL_CLOSE written on channel", (Object)channel, (Object)immediately);
            }
            if (AbstractChannel.this.gracefulState.compareAndSet(GracefulState.Opened, GracefulState.CloseSent)) {
                return;
            }
            if (AbstractChannel.this.gracefulState.compareAndSet(GracefulState.CloseReceived, GracefulState.Closed)) {
                AbstractChannel.this.gracefulFuture.setClosed();
            }
        }

        protected void handleClosePacketWriteFailure(Channel channel, boolean immediately, Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleClosePacketWriteFailure({})[immediately={}] failed ({}) to write SSH_MSG_CHANNEL_CLOSE on channel: {}", new Object[]{this, immediately, t.getClass().getSimpleName(), t.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleClosePacketWriteFailure(" + channel + ") SSH_MSG_CHANNEL_CLOSE failure details", t);
            }
            channel.close(true);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[" + AbstractChannel.this + "]";
        }
    }

    protected static enum GracefulState {
        Opened,
        CloseSent,
        CloseReceived,
        Closed;

    }
}

