/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.util.Attribute;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.netty.NettyIoService;
import org.apache.sshd.netty.NettySupport;

public class NettyIoSession
extends AbstractCloseable
implements IoSession {
    public static final Method NIO_JAVA_CHANNEL_METHOD = Stream.of(AbstractNioChannel.class.getDeclaredMethods()).filter(m -> "javaChannel".equals(m.getName()) && m.getParameterCount() == 0).map(m -> {
        m.setAccessible(true);
        return m;
    }).findFirst().orElse(null);
    protected final Map<Object, Object> attributes = new HashMap<Object, Object>();
    protected final NettyIoService service;
    protected final IoHandler handler;
    protected final long id;
    protected ChannelHandlerContext context;
    protected SocketAddress remoteAddr;
    protected ChannelFuture prev;
    protected final ChannelInboundHandlerAdapter adapter = new Adapter();
    private final SocketAddress acceptanceAddress;

    public NettyIoSession(NettyIoService service, IoHandler handler, SocketAddress acceptanceAddress) {
        super(Objects.toString(acceptanceAddress, ""));
        this.service = service;
        this.handler = handler;
        this.id = service.sessionSeq.incrementAndGet();
        this.acceptanceAddress = acceptanceAddress;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttributeIfAbsent(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(key);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddr;
    }

    public SocketAddress getLocalAddress() {
        Channel channel = this.context == null ? null : this.context.channel();
        return channel == null ? null : channel.localAddress();
    }

    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public IoWriteFuture writePacket(Buffer buffer) {
        int bufLen = buffer.available();
        ByteBuf buf = Unpooled.buffer((int)bufLen);
        buf.writeBytes(buffer.array(), buffer.rpos(), bufLen);
        DefaultIoWriteFuture msg = new DefaultIoWriteFuture(this.getRemoteAddress(), null);
        ChannelPromise next = this.context.newPromise();
        this.prev.addListener(whatever -> {
            if (this.context != null) {
                this.context.writeAndFlush((Object)buf, next);
            }
        });
        this.prev = next;
        next.addListener(fut -> {
            if (fut.isSuccess()) {
                msg.setValue(Boolean.TRUE);
            } else {
                msg.setValue(fut.cause());
            }
        });
        return msg;
    }

    public IoService getService() {
        return this.service;
    }

    public void shudownOutputStream() throws IOException {
        SelectableChannel channel;
        Channel ch = this.context.channel();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!(ch instanceof AbstractNioChannel)) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({}) channel is not AbstractNioChannel: {}", (Object)this, ch == null ? null : ch.getClass().getSimpleName());
            }
            return;
        }
        if (NIO_JAVA_CHANNEL_METHOD == null) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({}) missing channel access method", (Object)this);
            }
            return;
        }
        try {
            channel = (SelectableChannel)NIO_JAVA_CHANNEL_METHOD.invoke((Object)ch, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception t) {
            Throwable e = GenericUtils.peelException((Throwable)t);
            this.log.warn("shudownOutputStream({}) failed ({}) to retrieve embedded channel: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            return;
        }
        if (!(channel instanceof SocketChannel)) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({}) not a SocketChannel: {}", (Object)this, channel == null ? null : channel.getClass().getSimpleName());
            }
            return;
        }
        Socket socket = ((SocketChannel)channel).socket();
        if (socket.isConnected() && !socket.isClosed()) {
            if (debugEnabled) {
                this.log.debug("shudownOutputStream({})", (Object)this);
            }
            socket.shutdownOutput();
        }
    }

    protected CloseFuture doCloseGracefully() {
        this.context.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).addListener(fut -> this.closeFuture.setClosed());
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.context.close();
        super.doCloseImmediately();
    }

    protected void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        Channel channel = ctx.channel();
        this.service.channelGroup.add((Object)channel);
        this.service.sessions.put(this.id, this);
        this.prev = this.context.newPromise().setSuccess();
        this.remoteAddr = channel.remoteAddress();
        this.handler.sessionCreated((IoSession)this);
        Attribute connectFuture = channel.attr(NettyIoService.CONNECT_FUTURE_KEY);
        IoConnectFuture future = (IoConnectFuture)connectFuture.get();
        if (future != null) {
            future.setSession((IoSession)this);
        }
    }

    protected void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.service.sessions.remove(this.id);
        this.handler.sessionClosed((IoSession)this);
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        try {
            this.handler.messageReceived((IoSession)this, NettySupport.asReadable(buf));
        }
        finally {
            buf.release();
        }
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.handler.exceptionCaught((IoSession)this, cause);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }

    protected class Adapter
    extends ChannelInboundHandlerAdapter {
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyIoSession.this.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            NettyIoSession.this.channelInactive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            NettyIoSession.this.channelRead(ctx, msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyIoSession.this.exceptionCaught(ctx, cause);
        }
    }

    protected static class DefaultIoWriteFuture
    extends AbstractIoWriteFuture {
        public DefaultIoWriteFuture(Object id, Object lock) {
            super(id, lock);
        }
    }
}

