/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.MethodInvokingMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class BeanNameMessageProcessor<T>
implements MessageProcessor<T>,
BeanFactoryAware {
    private final String beanName;
    private final String methodName;
    private MessageProcessor<T> delegate;
    private BeanFactory beanFactory;

    public BeanNameMessageProcessor(String object, String methodName) {
        this.beanName = object;
        this.methodName = methodName;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' must not be null");
        this.beanFactory = beanFactory;
    }

    @Override
    public T processMessage(Message<?> message) {
        if (this.delegate == null) {
            Object target = this.beanFactory.getBean(this.beanName);
            MethodInvokingMessageProcessor methodInvokingMessageProcessor = new MethodInvokingMessageProcessor(target, this.methodName);
            methodInvokingMessageProcessor.setBeanFactory(this.beanFactory);
            this.delegate = methodInvokingMessageProcessor;
        }
        return this.delegate.processMessage(message);
    }
}

