/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.integration.config.EnablePublisher;
import org.springframework.integration.config.IntegrationRegistrar;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AnnotationConfigParser
implements BeanDefinitionParser {
    public BeanDefinition parse(final Element element, ParserContext parserContext) {
        StandardAnnotationMetadata importingClassMetadata = new StandardAnnotationMetadata(Object.class){

            public Map<String, Object> getAnnotationAttributes(String annotationType) {
                if (EnablePublisher.class.getName().equals(annotationType)) {
                    Element enablePublisherElement = DomUtils.getChildElementByTagName((Element)element, (String)"enable-publisher");
                    if (enablePublisherElement != null) {
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        attributes.put("defaultChannel", enablePublisherElement.getAttribute("default-publisher-channel"));
                        attributes.put("proxyTargetClass", enablePublisherElement.getAttribute("proxy-target-class"));
                        attributes.put("order", enablePublisherElement.getAttribute("order"));
                        return attributes;
                    }
                    return null;
                }
                return null;
            }
        };
        new IntegrationRegistrar().registerBeanDefinitions((AnnotationMetadata)importingClassMetadata, parserContext.getRegistry());
        return null;
    }
}

