/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.integration.config.IntegrationConverter;

public class IntegrationConverterInitializer
implements IntegrationConfigurationInitializer {
    private static final String CONTEXT_PACKAGE = "org.springframework.integration.context.";

    @Override
    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            AnnotationMetadata metadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata();
            boolean hasIntegrationConverter = metadata.hasAnnotation(IntegrationConverter.class.getName());
            if (!hasIntegrationConverter && beanDefinition.getSource() instanceof MethodMetadata) {
                MethodMetadata beanMethod = (MethodMetadata)beanDefinition.getSource();
                hasIntegrationConverter = beanMethod.isAnnotated(IntegrationConverter.class.getName());
            }
            if (!hasIntegrationConverter) continue;
            this.registerConverter(registry, (BeanMetadataElement)new RuntimeBeanReference(beanName));
        }
    }

    public void registerConverter(BeanDefinitionRegistry registry, BeanMetadataElement converterBeanDefinition) {
        Object converters = new ManagedSet();
        if (!registry.containsBeanDefinition("converterRegistrar")) {
            BeanDefinitionBuilder converterRegistrarBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.context.ConverterRegistrar").addConstructorArgValue(converters);
            registry.registerBeanDefinition("converterRegistrar", (BeanDefinition)converterRegistrarBuilder.getBeanDefinition());
            if (!registry.containsBeanDefinition("integrationConversionService")) {
                registry.registerBeanDefinition("integrationConversionService", (BeanDefinition)new RootBeanDefinition("org.springframework.integration.context.CustomConversionServiceFactoryBean"));
            }
        } else {
            BeanDefinition converterRegistrarBeanDefinition = registry.getBeanDefinition("converterRegistrar");
            converters = (Set)((ConstructorArgumentValues.ValueHolder)converterRegistrarBeanDefinition.getConstructorArgumentValues().getIndexedArgumentValues().values().iterator().next()).getValue();
        }
        converters.add(converterBeanDefinition);
    }
}

