/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.putty;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.loader.putty.AbstractPuttyKeyDecoder;
import org.apache.sshd.common.config.keys.loader.putty.PuttyKeyReader;
import org.apache.sshd.common.util.security.SecurityUtils;

public class RSAPuttyKeyDecoder
extends AbstractPuttyKeyDecoder<RSAPublicKey, RSAPrivateKey> {
    public static final RSAPuttyKeyDecoder INSTANCE = new RSAPuttyKeyDecoder();

    public RSAPuttyKeyDecoder() {
        super(RSAPublicKey.class, RSAPrivateKey.class, Collections.singletonList("ssh-rsa"));
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(NamedResource resourceKey, PuttyKeyReader pubReader, PuttyKeyReader prvReader, Map<String, String> headers) throws IOException, GeneralSecurityException {
        pubReader.skip();
        KeyFactory kf = SecurityUtils.getKeyFactory((String)"RSA");
        BigInteger publicExp = pubReader.readInt();
        BigInteger modulus = pubReader.readInt();
        PublicKey pubKey = kf.generatePublic(new RSAPublicKeySpec(modulus, publicExp));
        BigInteger privateExp = prvReader.readInt();
        BigInteger primeP = prvReader.readInt();
        BigInteger primeQ = prvReader.readInt();
        BigInteger crtCoef = prvReader.readInt();
        BigInteger primeExponentP = privateExp.mod(primeP.subtract(BigInteger.ONE));
        BigInteger primeExponentQ = privateExp.mod(primeQ.subtract(BigInteger.ONE));
        RSAPrivateCrtKeySpec prvSpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, primeP, primeQ, primeExponentP, primeExponentQ, crtCoef);
        PrivateKey prvKey = kf.generatePrivate(prvSpec);
        return Collections.singletonList(new KeyPair(pubKey, prvKey));
    }
}

