/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.putty;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.loader.putty.AbstractPuttyKeyDecoder;
import org.apache.sshd.common.config.keys.loader.putty.PuttyKeyReader;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderUtils;

public class EdDSAPuttyKeyDecoder
extends AbstractPuttyKeyDecoder<EdDSAPublicKey, EdDSAPrivateKey> {
    public static final EdDSAPuttyKeyDecoder INSTANCE = new EdDSAPuttyKeyDecoder();

    public EdDSAPuttyKeyDecoder() {
        super(EdDSAPublicKey.class, EdDSAPrivateKey.class, Collections.singletonList("ssh-ed25519"));
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(NamedResource resourceKey, PuttyKeyReader pubReader, PuttyKeyReader prvReader, Map<String, String> headers) throws IOException, GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported for " + resourceKey);
        }
        String keyType = pubReader.readString();
        if (!"ssh-ed25519".equals(keyType)) {
            throw new InvalidKeySpecException("Not an EdDSA key: " + keyType);
        }
        byte[] seed = pubReader.read(Short.MAX_VALUE);
        PublicKey pubKey = EdDSASecurityProviderUtils.generateEDDSAPublicKey((byte[])seed);
        seed = prvReader.read(Short.MAX_VALUE);
        PrivateKey prvKey = EdDSASecurityProviderUtils.generateEDDSAPrivateKey((byte[])seed);
        return Collections.singletonList(new KeyPair(pubKey, prvKey));
    }
}

