/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.io.resource.URLResource;
import org.bouncycastle.openpgp.PGPException;
import org.c02e.jpgpj.Key;

public interface PGPKeyLoader {
    default public Key loadPGPKey(SessionContext session, URL url, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException, PGPException {
        return this.loadPGPKey(session, (IoResource<?>)new URLResource(url), passwordProvider);
    }

    default public Key loadPGPKey(SessionContext session, Path path, FilePasswordProvider passwordProvider, OpenOption ... options) throws IOException, GeneralSecurityException, PGPException {
        return this.loadPGPKey(session, (IoResource<?>)new PathResource(path, options), passwordProvider);
    }

    default public Key loadPGPKey(SessionContext session, IoResource<?> resourceKey, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException, PGPException {
        try (InputStream input = resourceKey.openInputStream();){
            Key key = this.loadPGPKey(session, (NamedResource)resourceKey, passwordProvider, input);
            return key;
        }
    }

    default public Key loadPGPKey(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, InputStream input) throws IOException, GeneralSecurityException, PGPException {
        return PGPKeyLoader.loadPGPKey(input, passwordProvider == null ? null : passwordProvider.getPassword(session, resourceKey, 0));
    }

    public static Key loadPGPKey(InputStream input, String password) throws IOException, PGPException {
        Key key;
        boolean withPassword = GenericUtils.isNotEmpty((CharSequence)password);
        Key key2 = key = withPassword ? new Key(input, password) : new Key(input);
        if (!withPassword) {
            key.setNoPassphrase(true);
        }
        return key;
    }
}

