/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openpgp;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.loader.openpgp.PGPPublicKeyEntryDataResolver;
import org.apache.sshd.common.config.keys.loader.openpgp.PGPPublicKeyExtractor;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.bouncycastle.openpgp.PGPException;

public interface PGPAuthorizedKeyEntriesLoader
extends PGPPublicKeyExtractor,
PublicKeyEntryResolver {
    default public PublicKey resolve(SessionContext session, String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
        List<PublicKey> keys;
        if (!PGPPublicKeyEntryDataResolver.PGP_KEY_TYPES.contains(keyType)) {
            return null;
        }
        String fingerprint = PGPPublicKeyEntryDataResolver.encodeKeyFingerprint(keyData);
        if (GenericUtils.isEmpty((CharSequence)fingerprint)) {
            return null;
        }
        try {
            keys = this.loadMatchingKeyFingerprints(session, Collections.singletonList(fingerprint));
        }
        catch (PGPException e) {
            throw new InvalidKeyException("Failed (" + ((Object)((Object)e)).getClass().getSimpleName() + ") to load key type=" + keyType + " with fingerprint=" + fingerprint + ": " + e.getMessage(), e);
        }
        int numKeys = GenericUtils.size(keys);
        if (numKeys > 1) {
            throw new StreamCorruptedException("Multiple matches (" + numKeys + ") for " + keyType + " fingerprint=" + fingerprint);
        }
        return (PublicKey)GenericUtils.head(keys);
    }

    default public List<PublicKey> resolveAuthorizedEntries(SessionContext session, Collection<? extends PublicKeyEntry> entries, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException, PGPException {
        NavigableMap typesMap = KeyTypeIndicator.groupByKeyType(entries);
        if (GenericUtils.isEmpty((Map)typesMap)) {
            return Collections.emptyList();
        }
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>(entries.size());
        for (Map.Entry te : typesMap.entrySet()) {
            List subKeys;
            String keyType = (String)te.getKey();
            Collection keyEntries = (Collection)te.getValue();
            List list = subKeys = PGPPublicKeyEntryDataResolver.PGP_KEY_TYPES.contains(keyType) ? this.loadMatchingAuthorizedEntries(session, keyEntries) : PublicKeyEntry.resolvePublicKeyEntries((SessionContext)session, (Collection)keyEntries, (PublicKeyEntryResolver)fallbackResolver);
            if (GenericUtils.isEmpty((Collection)subKeys)) continue;
            keys.addAll(subKeys);
        }
        return keys;
    }

    default public List<PublicKey> loadMatchingAuthorizedEntries(SessionContext session, Collection<? extends PublicKeyEntry> entries) throws IOException, GeneralSecurityException, PGPException {
        int numEntries = GenericUtils.size(entries);
        if (numEntries <= 0) {
            return Collections.emptyList();
        }
        TreeSet<String> fingerprints = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (PublicKeyEntry publicKeyEntry : entries) {
            String fp;
            String keyType = publicKeyEntry.getKeyType();
            if (!GenericUtils.isEmpty((CharSequence)keyType) && PGPPublicKeyEntryDataResolver.PGP_KEY_TYPES.contains(keyType) && !GenericUtils.isEmpty((CharSequence)(fp = PGPPublicKeyEntryDataResolver.DEFAULT.encodeEntryKeyData(publicKeyEntry.getKeyData()))) && fingerprints.add(fp)) continue;
        }
        return this.loadMatchingKeyFingerprints(session, fingerprints);
    }

    public List<PublicKey> loadMatchingKeyFingerprints(SessionContext var1, Collection<String> var2) throws IOException, GeneralSecurityException, PGPException;
}

