/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.InboundFileSynchronizer;
import org.springframework.integration.file.support.FileUtils;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractInboundFileSynchronizer<F>
implements InboundFileSynchronizer,
BeanFactoryAware,
InitializingBean,
Closeable {
    protected static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private EvaluationContext evaluationContext;
    private String remoteFileSeparator = "/";
    private String temporaryFileSuffix = ".writing";
    private Expression localFilenameGeneratorExpression;
    private volatile Expression remoteDirectoryExpression;
    private volatile String evaluatedRemoteDirectory;
    private FileListFilter<F> filter;
    private boolean deleteRemoteFiles;
    private boolean preserveTimestamp;
    private BeanFactory beanFactory;
    private Comparator<F> comparator;

    public AbstractInboundFileSynchronizer(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.remoteFileTemplate = new RemoteFileTemplate<F>(sessionFactory);
    }

    protected Comparator<F> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<F> comparator) {
        this.comparator = comparator;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    public void setLocalFilenameGeneratorExpressionString(String localFilenameGeneratorExpression) {
        this.setLocalFilenameGeneratorExpression(EXPRESSION_PARSER.parseExpression(localFilenameGeneratorExpression));
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectoryExpression = new LiteralExpression(remoteDirectory);
        this.evaluateRemoteDirectory();
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.doSetRemoteDirectoryExpression(remoteDirectoryExpression);
    }

    public void setRemoteDirectoryExpressionString(String remoteDirectoryExpression) {
        this.doSetRemoteDirectoryExpression(EXPRESSION_PARSER.parseExpression(remoteDirectoryExpression));
    }

    protected final void doSetRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"'remoteDirectoryExpression' must not be null");
        this.remoteDirectoryExpression = remoteDirectoryExpression;
        this.evaluateRemoteDirectory();
    }

    public void setFilter(FileListFilter<F> filter) {
        this.doSetFilter(filter);
    }

    protected final void doSetFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public final void afterPropertiesSet() {
        Assert.state((this.remoteDirectoryExpression != null ? 1 : 0) != 0, (String)"'remoteDirectoryExpression' must not be null");
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
        }
        this.evaluateRemoteDirectory();
        this.doInit();
    }

    protected void doInit() {
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    @Override
    public void close() throws IOException {
        if (this.filter instanceof Closeable) {
            ((Closeable)((Object)this.filter)).close();
        }
    }

    @Override
    public void synchronizeToLocalDirectory(File localDirectory) {
        this.synchronizeToLocalDirectory(localDirectory, Integer.MIN_VALUE);
    }

    @Override
    public void synchronizeToLocalDirectory(File localDirectory, int maxFetchSize) {
        if (maxFetchSize == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Max Fetch Size is zero - fetch to " + localDirectory.getAbsolutePath() + " ignored"));
            }
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Synchronizing " + this.evaluatedRemoteDirectory + " to " + localDirectory));
        }
        try {
            int transferred = this.remoteFileTemplate.execute(session -> {
                Object[] files = session.list(this.evaluatedRemoteDirectory);
                if (!ObjectUtils.isEmpty((Object[])files)) {
                    files = FileUtils.purgeUnwantedElements(files, e -> !this.isFile(e), this.comparator);
                }
                if (!ObjectUtils.isEmpty((Object[])files)) {
                    List<Object> filteredFiles = this.filterFiles(files);
                    if (maxFetchSize >= 0 && filteredFiles.size() > maxFetchSize) {
                        this.rollbackFromFileToListEnd(filteredFiles, filteredFiles.get(maxFetchSize));
                        ArrayList<Object> newList = new ArrayList<Object>(maxFetchSize);
                        for (int i = 0; i < maxFetchSize; ++i) {
                            newList.add(filteredFiles.get(i));
                        }
                        filteredFiles = newList;
                    }
                    int copied = filteredFiles.size();
                    for (Object file : filteredFiles) {
                        try {
                            if (file == null || this.copyFileToLocalDirectory(this.evaluatedRemoteDirectory, file, localDirectory, session)) continue;
                            --copied;
                        }
                        catch (RuntimeException e1) {
                            this.rollbackFromFileToListEnd(filteredFiles, file);
                            throw e1;
                        }
                        catch (IOException e1) {
                            this.rollbackFromFileToListEnd(filteredFiles, file);
                            throw e1;
                        }
                    }
                    return copied;
                }
                return 0;
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(transferred + " files transferred from '" + this.evaluatedRemoteDirectory + "'"));
            }
        }
        catch (Exception e) {
            throw new MessagingException("Problem occurred while synchronizing '" + this.evaluatedRemoteDirectory + "' to local directory", (Throwable)e);
        }
    }

    protected void rollbackFromFileToListEnd(List<F> filteredFiles, F file) {
        if (this.filter instanceof ReversibleFileListFilter) {
            ((ReversibleFileListFilter)this.filter).rollback(file, filteredFiles);
        }
    }

    protected boolean copyFileToLocalDirectory(String remoteDirectoryPath, F remoteFile, File localDirectory, Session<F> session) throws IOException {
        String remoteFilePath;
        String remoteFileName = this.getFilename(remoteFile);
        String localFileName = this.generateLocalFileName(remoteFileName);
        String string = remoteFilePath = remoteDirectoryPath != null ? remoteDirectoryPath + this.remoteFileSeparator + remoteFileName : remoteFileName;
        if (!this.isFile(remoteFile)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("cannot copy, not a file: " + remoteFilePath));
            }
            return false;
        }
        long modified = this.getModified(remoteFile);
        File localFile = new File(localDirectory, localFileName);
        boolean exists = localFile.exists();
        if (!exists || this.preserveTimestamp && modified != localFile.lastModified()) {
            if (!exists && localFileName.replaceAll("/", Matcher.quoteReplacement(File.separator)).contains(File.separator)) {
                localFile.getParentFile().mkdirs();
            }
            boolean transfer = true;
            if (exists && !localFile.delete()) {
                transfer = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Cannot delete local file '" + localFile + "' in order to transfer modified remote file '" + remoteFile + "'. The local file may be busy in some other process."));
                }
            }
            boolean renamed = false;
            if (transfer) {
                String tempFileName = localFile.getAbsolutePath() + this.temporaryFileSuffix;
                File tempFile = new File(tempFileName);
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
                try {
                    session.read(remoteFilePath, outputStream);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new MessagingException("Failure occurred while copying '" + remoteFilePath + "' from the remote to the local directory", (Throwable)e);
                }
                finally {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Exception exception) {}
                }
                renamed = tempFile.renameTo(localFile);
                if (!renamed) {
                    if (localFile.delete()) {
                        renamed = tempFile.renameTo(localFile);
                        if (!renamed && this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("Cannot rename '" + tempFileName + "' to local file '" + localFile + "' after deleting. The local file may be busy in some other process."));
                        }
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Cannot delete local file '" + localFile + "'. The local file may be busy in some other process."));
                    }
                }
            }
            if (renamed) {
                if (this.deleteRemoteFiles) {
                    session.remove(remoteFilePath);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("deleted remote file: " + remoteFilePath));
                    }
                }
                if (this.preserveTimestamp) {
                    localFile.setLastModified(modified);
                }
                return true;
            }
            if (this.filter instanceof ResettableFileListFilter) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Reverting the remote file '" + remoteFile + "' from the filter for a subsequent transfer attempt"));
                }
                ((ResettableFileListFilter)this.filter).remove(remoteFile);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The remote file '" + remoteFile + "' has not been transferred to the existing local file '" + localFile + "'. Consider removing the local file."));
        }
        return false;
    }

    private String generateLocalFileName(String remoteFileName) {
        if (this.localFilenameGeneratorExpression != null) {
            return (String)this.localFilenameGeneratorExpression.getValue(this.evaluationContext, (Object)remoteFileName, String.class);
        }
        return remoteFileName;
    }

    protected void evaluateRemoteDirectory() {
        if (this.evaluationContext != null) {
            this.evaluatedRemoteDirectory = (String)this.remoteDirectoryExpression.getValue(this.evaluationContext, String.class);
            this.evaluationContext.setVariable("remoteDirectory", (Object)this.evaluatedRemoteDirectory);
        }
    }

    protected abstract boolean isFile(F var1);

    protected abstract String getFilename(F var1);

    protected abstract long getModified(F var1);
}

