/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.integration.annotation.Publisher;
import org.springframework.integration.aop.PublisherMetadataSource;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MethodAnnotationPublisherMetadataSource
implements PublisherMetadataSource {
    private final ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private final Map<Method, String> channels = new HashMap<Method, String>();
    private final Map<Method, Expression> payloadExpressions = new HashMap<Method, Expression>();
    private final Map<Method, Map<String, Expression>> headersExpressions = new HashMap<Method, Map<String, Expression>>();
    private final Set<Class<? extends Annotation>> annotationTypes;
    private volatile String channelAttributeName = "channel";

    public MethodAnnotationPublisherMetadataSource() {
        this(Collections.singleton(Publisher.class));
    }

    public MethodAnnotationPublisherMetadataSource(Set<Class<? extends Annotation>> annotationTypes) {
        Assert.notEmpty(annotationTypes, (String)"annotationTypes must not be empty");
        this.annotationTypes = annotationTypes;
    }

    public void setChannelAttributeName(String channelAttributeName) {
        Assert.hasText((String)channelAttributeName, (String)"channelAttributeName must not be empty");
        this.channelAttributeName = channelAttributeName;
    }

    @Override
    public String getChannelName(Method method) {
        return this.channels.computeIfAbsent(method, method1 -> {
            String channelName = this.getAnnotationValue(method, this.channelAttributeName, String.class);
            if (channelName == null) {
                channelName = this.getAnnotationValue(method.getDeclaringClass(), this.channelAttributeName, String.class);
            }
            return StringUtils.hasText((String)channelName) ? channelName : null;
        });
    }

    @Override
    public Expression getExpressionForPayload(Method method) {
        return this.payloadExpressions.computeIfAbsent(method, method1 -> {
            Expression payloadExpression = null;
            Annotation methodPayloadAnnotation = AnnotationUtils.findAnnotation((Method)method, Payload.class);
            if (methodPayloadAnnotation != null) {
                String payloadExpressionString = this.getAnnotationValue(methodPayloadAnnotation, null, String.class);
                payloadExpression = !StringUtils.hasText((String)payloadExpressionString) ? RETURN_VALUE_EXPRESSION : EXPRESSION_PARSER.parseExpression(payloadExpressionString);
            }
            Annotation[][] annotationArray = method.getParameterAnnotations();
            for (int i = 0; i < annotationArray.length; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation currentAnnotation : parameterAnnotations = annotationArray[i]) {
                    if (!Payload.class.equals(currentAnnotation.annotationType())) continue;
                    Assert.state((payloadExpression == null ? 1 : 0) != 0, (String)"@Payload can be used at most once on a @Publisher method, either at method-level or on a single parameter");
                    Assert.state((boolean)"".equals(AnnotationUtils.getValue((Annotation)currentAnnotation)), (String)"@Payload on a parameter for a @Publisher method may not contain an expression");
                    payloadExpression = EXPRESSION_PARSER.parseExpression("#args[" + i + "]");
                }
            }
            if (payloadExpression == null || RETURN_VALUE_EXPRESSION.getExpressionString().equals(payloadExpression.getExpressionString())) {
                Assert.isTrue((!Void.TYPE.equals(method.getReturnType()) ? 1 : 0) != 0, (String)"When defining @Publisher on a void-returning method, an explicit payload expression that does not rely upon a #return value is required.");
            }
            return payloadExpression;
        });
    }

    @Override
    @Deprecated
    public String getPayloadExpression(Method method) {
        return this.getExpressionForPayload(method).getExpressionString();
    }

    @Override
    public Map<String, Expression> getExpressionsForHeaders(Method method) {
        return this.headersExpressions.computeIfAbsent(method, method1 -> {
            HashMap<String, Expression> headerExpressions = new HashMap<String, Expression>();
            String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(method);
            Annotation[][] annotationArray = method.getParameterAnnotations();
            for (int i = 0; i < annotationArray.length; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation currentAnnotation : parameterAnnotations = annotationArray[i]) {
                    if (!Header.class.equals(currentAnnotation.annotationType())) continue;
                    String name = this.getAnnotationValue(currentAnnotation, null, String.class);
                    if (!StringUtils.hasText((String)name)) {
                        name = parameterNames[i];
                    }
                    headerExpressions.put(name, EXPRESSION_PARSER.parseExpression("#args[" + i + "]"));
                }
            }
            return headerExpressions;
        });
    }

    @Override
    @Deprecated
    public Map<String, String> getHeaderExpressions(Method method) {
        return this.getExpressionsForHeaders(method).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Expression)e.getValue()).getExpressionString()));
    }

    private <T> T getAnnotationValue(Method method, String attributeName, Class<T> expectedType) {
        T value = null;
        for (Class<? extends Annotation> annotationType : this.annotationTypes) {
            Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, annotationType);
            if (annotation == null) continue;
            if (value != null) {
                throw new IllegalStateException("method [" + method + "] contains more than one publisher annotation");
            }
            value = this.getAnnotationValue(annotation, attributeName, expectedType);
        }
        return value;
    }

    private <T> T getAnnotationValue(Class<?> clazz, String attributeName, Class<T> expectedType) {
        T value = null;
        for (Class<? extends Annotation> annotationType : this.annotationTypes) {
            Annotation annotation = AnnotatedElementUtils.findMergedAnnotation(clazz, annotationType);
            if (annotation == null) continue;
            if (value != null) {
                throw new IllegalStateException("class [" + clazz + "] contains more than one publisher annotation");
            }
            value = this.getAnnotationValue(annotation, attributeName, expectedType);
        }
        return value;
    }

    private <T> T getAnnotationValue(Annotation annotation, String attributeName, Class<T> expectedType) {
        Object valueAsObject;
        Object value = null;
        Object object = valueAsObject = attributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        if (valueAsObject != null) {
            if (expectedType.isAssignableFrom(valueAsObject.getClass())) {
                value = valueAsObject;
            } else {
                throw new IllegalArgumentException("expected type [" + expectedType.getName() + "] for attribute '" + attributeName + "' on publisher annotation [" + annotation.annotationType() + "], but actual type was [" + valueAsObject.getClass() + "]");
            }
        }
        return (T)value;
    }
}

