/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;

public abstract class AbstractDelegatingCommandFactory
extends AbstractLoggingBean
implements CommandFactory {
    private final String name;
    private CommandFactory delegate;

    protected AbstractDelegatingCommandFactory(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty((String)name, (String)"No delegating command factory name provided");
    }

    public String toString() {
        return this.name;
    }

    public CommandFactory getDelegateCommandFactory() {
        return this.delegate;
    }

    public void setDelegateCommandFactory(CommandFactory factory) {
        this.delegate = factory;
    }

    @Override
    public Command createCommand(String command) {
        if (this.isSupportedCommand(command)) {
            return this.executeSupportedCommand(command);
        }
        CommandFactory factory = this.getDelegateCommandFactory();
        if (factory != null) {
            return factory.createCommand(command);
        }
        return this.createUnsupportedCommand(command);
    }

    public abstract boolean isSupportedCommand(String var1);

    protected abstract Command executeSupportedCommand(String var1);

    protected Command createUnsupportedCommand(String command) {
        throw new IllegalArgumentException("Unknown command to execute: " + command);
    }
}

