/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.netty.NettyIoService;
import org.apache.sshd.netty.NettyIoServiceFactory;
import org.apache.sshd.netty.NettyIoSession;

public class NettyIoAcceptor
extends NettyIoService
implements IoAcceptor {
    protected final ServerBootstrap bootstrap = new ServerBootstrap();
    protected final DefaultCloseFuture closeFuture = new DefaultCloseFuture((Object)((Object)((Object)this)).toString(), this.lock);
    protected final Map<SocketAddress, Channel> boundAddresses = new ConcurrentHashMap<SocketAddress, Channel>();

    public NettyIoAcceptor(NettyIoServiceFactory factory, final IoHandler handler) {
        super(factory, handler);
        this.channelGroup = new DefaultChannelGroup("sshd-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(factory.eventLoopGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                IoServiceEventListener listener = NettyIoAcceptor.this.getIoServiceEventListener();
                InetSocketAddress local = ch.localAddress();
                InetSocketAddress remote = ch.remoteAddress();
                try {
                    if (listener != null) {
                        try {
                            listener.connectionAccepted((IoAcceptor)NettyIoAcceptor.this, (SocketAddress)local, (SocketAddress)remote);
                        }
                        catch (Exception e) {
                            ch.close();
                            throw e;
                        }
                    }
                    ChannelPipeline p = ch.pipeline();
                    NettyIoSession nettyIoSession = new NettyIoSession(NettyIoAcceptor.this, handler);
                    p.addLast(new ChannelHandler[]{nettyIoSession.adapter});
                }
                catch (Exception e) {
                    block8: {
                        if (listener != null) {
                            try {
                                listener.abortAcceptedConnection((IoAcceptor)NettyIoAcceptor.this, (SocketAddress)local, (SocketAddress)remote, (Throwable)e);
                            }
                            catch (Exception exc) {
                                if (!NettyIoAcceptor.this.log.isDebugEnabled()) break block8;
                                NettyIoAcceptor.this.log.debug("initChannel(" + ch + ") listener=" + listener + " ignoring abort event exception", (Throwable)exc);
                            }
                        }
                    }
                    throw e;
                }
            }
        });
    }

    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        for (SocketAddress socketAddress : addresses) {
            this.bind(socketAddress);
        }
    }

    public void bind(SocketAddress address) throws IOException {
        InetSocketAddress inetAddress = (InetSocketAddress)address;
        ChannelFuture f = this.bootstrap.bind((SocketAddress)inetAddress);
        Channel channel = f.channel();
        this.channelGroup.add((Object)channel);
        try {
            f.sync();
            SocketAddress bound = channel.localAddress();
            this.boundAddresses.put(bound, channel);
            channel.closeFuture().addListener(fut -> this.boundAddresses.remove(bound));
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void unbind(Collection<? extends SocketAddress> addresses) {
        CountDownLatch latch = new CountDownLatch(addresses.size());
        for (SocketAddress socketAddress : addresses) {
            Channel channel = this.boundAddresses.remove(socketAddress);
            if (channel != null) {
                ChannelFuture fut = channel.isOpen() ? channel.close() : channel.closeFuture();
                fut.addListener(f -> latch.countDown());
                continue;
            }
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void unbind(SocketAddress address) {
        Channel channel = this.boundAddresses.remove(address);
        if (channel != null) {
            ChannelFuture fut = channel.isOpen() ? channel.close() : channel.closeFuture();
            try {
                fut.sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void unbind() {
        Set<SocketAddress> addresses = this.getBoundAddresses();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbinding {}", addresses);
        }
        this.unbind(addresses);
    }

    public Set<SocketAddress> getBoundAddresses() {
        return new HashSet<SocketAddress>(this.boundAddresses.keySet());
    }

    protected CloseFuture doCloseGracefully() {
        this.channelGroup.close().addListener(fut -> this.closeFuture.setClosed());
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        this.doCloseGracefully();
        super.doCloseImmediately();
    }
}

