/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class TtyFilterInputStream
extends FilterInputStream {
    public static final Set<PtyMode> INPUT_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.ONLCR, PtyMode.OCRNL, PtyMode.ONLRET, PtyMode.ONOCR));
    private final Set<PtyMode> ttyOptions;
    private Buffer buffer = new ByteArrayBuffer(32, false);
    private int lastChar = -1;

    public TtyFilterInputStream(InputStream in, Map<PtyMode, ?> modes) {
        this(in, PtyMode.resolveEnabledOptions(modes, INPUT_OPTIONS));
    }

    public TtyFilterInputStream(InputStream in, Collection<PtyMode> ttyOptions) {
        super(in);
        this.ttyOptions = GenericUtils.of(ttyOptions);
    }

    public synchronized void write(int c) {
        this.buffer.putByte((byte)c);
    }

    public synchronized void write(byte[] buf, int off, int len) {
        if (len == 1) {
            this.write(buf[off] & 0xFF);
        } else {
            this.buffer.putBytes(buf, off, len);
        }
    }

    @Override
    public synchronized int available() throws IOException {
        return super.available() + this.buffer.available();
    }

    @Override
    public synchronized int read() throws IOException {
        int c = this.readRawInput();
        if (c == -1) {
            return c;
        }
        if (c == 13) {
            c = this.handleCR();
        } else if (c == 10) {
            c = this.handleLF();
        }
        this.lastChar = c;
        return c;
    }

    protected int handleCR() throws IOException {
        if (this.ttyOptions.contains((Object)PtyMode.OCRNL)) {
            return 10;
        }
        return 13;
    }

    protected int handleLF() throws IOException {
        if ((this.ttyOptions.contains((Object)PtyMode.ONLCR) || this.ttyOptions.contains((Object)PtyMode.ONOCR)) && this.lastChar != 13) {
            this.buffer = this.insertCharacter(this.buffer, 10);
            return 13;
        }
        if (this.ttyOptions.contains((Object)PtyMode.ONLRET)) {
            return 13;
        }
        return 10;
    }

    protected Buffer insertCharacter(Buffer org, int c) {
        int remaining = org.capacity();
        int readPos = org.rpos();
        if (remaining > 0 && readPos > 0) {
            int writePos = org.wpos();
            org.wpos(readPos - 1);
            org.putByte((byte)c);
            org.wpos(writePos);
            org.rpos(readPos - 1);
            return org;
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(org.available() + 8, false);
        buf.putByte((byte)c);
        buf.putBuffer((Readable)org);
        return buf;
    }

    protected int readRawInput() throws IOException {
        if (this.buffer.available() > 0) {
            return this.buffer.getUByte();
        }
        return this.in.read();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int nb;
        if (len == 1) {
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            return 1;
        }
        if (this.buffer.available() == 0) {
            nb = this.in.read(b, off, len);
            if (nb == -1) {
                return nb;
            }
            this.buffer.putRawBytes(b, off, nb);
        }
        nb = 0;
        int curPos = off;
        while (nb < len && this.buffer.available() > 0) {
            b[curPos] = (byte)this.read();
            ++nb;
            ++curPos;
        }
        return nb;
    }
}

