/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.global;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.global.AbstractOpenSshHostKeysHandler;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler
implements SignatureFactoriesManager {
    public static final String REQUEST = "hostkeys-prove-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler(){

        @Override
        public List<NamedFactory<Signature>> getSignatureFactories() {
            return null;
        }

        @Override
        public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
            if (!GenericUtils.isEmpty(factories)) {
                throw new UnsupportedOperationException("Not allowed to change default instance signature factories");
            }
        }
    };
    private List<NamedFactory<Signature>> factories;

    public OpenSshHostKeysHandler() {
        super(REQUEST);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser<? extends PublicKey> parser) {
        super(REQUEST, parser);
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    protected RequestHandler.Result handleHostKeys(Session session, Collection<? extends PublicKey> keys, boolean wantReply, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue((boolean)wantReply, (String)"No reply required for host keys of %s", (Object)session);
        Collection factories = ValidateUtils.checkNotNullAndNotEmpty((Collection)SignatureFactoriesManager.resolveSignatureFactories((SignatureFactoriesManager)this, (SignatureFactoriesManager)session), (String)"No signature factories available for host keys of session=%s", (Object[])new Object[]{session});
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys - factories={}", new Object[]{session, wantReply, GenericUtils.size(keys), NamedResource.getNames((Collection)factories)});
        }
        buffer = session.createBuffer((byte)81);
        ByteArrayBuffer buf = new ByteArrayBuffer();
        byte[] sessionId = session.getSessionId();
        KeyPairProvider kpp = Objects.requireNonNull(session.getKeyPairProvider(), "No server keys provider");
        for (PublicKey publicKey : keys) {
            KeyPair kp;
            String keyType = KeyUtils.getKeyType((Key)publicKey);
            Signature verifier = (Signature)ValidateUtils.checkNotNull((Object)NamedFactory.create((Collection)factories, (String)keyType), (String)"No signer could be located for key type=%s", (Object)keyType);
            try {
                kp = (KeyPair)ValidateUtils.checkNotNull((Object)kpp.loadKey(keyType), (String)"No key of type=%s available", (Object)keyType);
            }
            catch (Error e) {
                this.log.warn("handleHostKeys({}) failed ({}) to load key of type={}: {}", new Object[]{session, e.getClass().getSimpleName(), keyType, e.getMessage()});
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleHostKey(" + session + ") " + keyType + " key load failure details", (Throwable)e);
                }
                throw new RuntimeSshException((Throwable)e);
            }
            verifier.initSigner(kp.getPrivate());
            buf.clear();
            buf.putString(REQUEST);
            buf.putBytes(sessionId);
            buf.putPublicKey(publicKey);
            byte[] data = buf.getCompactData();
            verifier.update(data);
            byte[] signature = verifier.sign();
            buffer.putBytes(signature);
        }
        session.writePacket(buffer);
        return RequestHandler.Result.Replied;
    }
}

