/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config;

import java.nio.file.Paths;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.config.AllowTcpForwardingValue;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;

public final class SshServerConfigFileReader {
    public static final String ALLOW_TCP_FORWARDING_CONFIG_PROP = "AllowTcpForwarding";
    public static final String DEFAULT_TCP_FORWARDING = "yes";
    public static final String ALLOW_AGENT_FORWARDING_CONFIG_PROP = "AllowAgentForwarding";
    public static final String DEFAULT_AGENT_FORWARDING = "yes";
    public static final String ALLOW_X11_FORWARDING_CONFIG_PROP = "X11Forwarding";
    public static final String DEFAULT_X11_FORWARDING = "no";
    public static final String BANNER_CONFIG_PROP = "Banner";
    public static final String VISUAL_HOST_KEY = "VisualHostKey";
    public static final String DEFAULT_VISUAL_HOST_KEY = "no";

    private SshServerConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static <S extends SshServer> S configure(S server, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configure(server, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureKeyExchanges(server, props, lenient, ServerBuilder.DH2KEX, ignoreUnsupported);
        return server;
    }

    public static ForwardingFilter resolveServerForwarding(PropertyResolver options) {
        if (GenericUtils.isEmpty((Object[])new PropertyResolver[]{options})) {
            return AcceptAllForwardingFilter.INSTANCE;
        }
        AgentForwardingFilter agentFilter = SshServerConfigFileReader.resolveAgentForwardingFilter(options);
        TcpForwardingFilter tcpFilter = SshServerConfigFileReader.resolveTcpForwardingFilter(options);
        X11ForwardingFilter x11Filter = SshServerConfigFileReader.resolveX11ForwardingFilter(options);
        return ForwardingFilter.asForwardingFilter(agentFilter, x11Filter, tcpFilter);
    }

    public static AgentForwardingFilter resolveAgentForwardingFilter(PropertyResolver options) {
        String value = PropertyResolverUtils.getStringProperty((PropertyResolver)options, (String)ALLOW_AGENT_FORWARDING_CONFIG_PROP, (String)"yes");
        return AgentForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue((String)value));
    }

    public static TcpForwardingFilter resolveTcpForwardingFilter(PropertyResolver options) {
        String value = PropertyResolverUtils.getStringProperty((PropertyResolver)options, (String)ALLOW_TCP_FORWARDING_CONFIG_PROP, (String)"yes");
        AllowTcpForwardingValue filter = AllowTcpForwardingValue.fromString(value);
        ValidateUtils.checkNotNull((Object)filter, (String)"Unknown %s value: %s", (Object[])new Object[]{ALLOW_TCP_FORWARDING_CONFIG_PROP, value});
        return filter;
    }

    public static X11ForwardingFilter resolveX11ForwardingFilter(PropertyResolver options) {
        String value = PropertyResolverUtils.getStringProperty((PropertyResolver)options, (String)ALLOW_X11_FORWARDING_CONFIG_PROP, (String)"no");
        return X11ForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue((String)value));
    }

    public static Object resolveBanner(PropertyResolver options) {
        String bannerOption = PropertyResolverUtils.getString((PropertyResolver)options, (String)BANNER_CONFIG_PROP);
        if (GenericUtils.isEmpty((CharSequence)bannerOption)) {
            bannerOption = PropertyResolverUtils.getStringProperty((PropertyResolver)options, (String)VISUAL_HOST_KEY, (String)"no");
            bannerOption = ConfigFileReaderSupport.parseBooleanValue((String)bannerOption) ? "#auto-welcome-banner" : null;
        }
        if (GenericUtils.isEmpty((CharSequence)bannerOption)) {
            return "Welcome to SSHD\n";
        }
        if ("none".equals(bannerOption)) {
            return null;
        }
        if ("#auto-welcome-banner".equalsIgnoreCase(bannerOption)) {
            return bannerOption;
        }
        return Paths.get(bannerOption, new String[0]);
    }
}

