/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelRequestHandler;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.LoggingFilterOutputStream;
import org.apache.sshd.server.ChannelSessionAware;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.StandardEnvironment;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.AsyncDataReceiver;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.PipeDataReceiver;
import org.apache.sshd.server.channel.PuttyRequestHandler;
import org.apache.sshd.server.command.AsyncCommand;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ChannelSession
extends AbstractServerChannel {
    public static final List<ChannelRequestHandler> DEFAULT_HANDLERS = Collections.singletonList(PuttyRequestHandler.INSTANCE);
    protected String type;
    protected ChannelAsyncOutputStream asyncOut;
    protected ChannelAsyncOutputStream asyncErr;
    protected OutputStream out;
    protected OutputStream err;
    protected Command commandInstance;
    protected ChannelDataReceiver receiver;
    protected Buffer tempBuffer;
    protected final AtomicBoolean commandStarted = new AtomicBoolean(false);
    protected final StandardEnvironment env = new StandardEnvironment();
    protected final CloseFuture commandExitFuture = new DefaultCloseFuture((Object)this.getClass().getSimpleName(), this.lock);

    public ChannelSession() {
        this(DEFAULT_HANDLERS);
    }

    public ChannelSession(Collection<? extends RequestHandler<Channel>> handlers) {
        super("", handlers, null);
    }

    @Override
    public ServerSession getSession() {
        return (ServerSession)super.getSession();
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.asyncOut != null) {
            this.asyncOut.onWindowExpanded();
        }
    }

    @Override
    protected org.apache.sshd.common.Closeable getInnerCloseable() {
        return this.builder().sequential(new org.apache.sshd.common.Closeable[]{new CommandCloseable(), super.getInnerCloseable()}).parallel(new org.apache.sshd.common.Closeable[]{this.asyncOut, this.asyncErr}).run((Object)this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        IOException e;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.commandInstance != null) {
            try {
                this.commandInstance.destroy();
            }
            catch (Throwable e2) {
                this.log.warn("doCloseImmediately({}) failed ({}) to destroy command: {}", new Object[]{this, e2.getClass().getSimpleName(), e2.getMessage()});
                if (debugEnabled) {
                    this.log.debug("doCloseImmediately(" + this + ") command destruction failure details", e2);
                }
            }
            finally {
                this.commandInstance = null;
            }
        }
        if ((e = IoUtils.closeQuietly((Closeable[])new Closeable[]{this.getRemoteWindow(), this.out, this.err, this.receiver})) != null) {
            Object[] suppressed;
            if (debugEnabled) {
                this.log.debug("doCloseImmediately({}) failed ({}) to close resources: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            }
            if (this.log.isTraceEnabled() && GenericUtils.length((Object[])(suppressed = e.getSuppressed())) > 0) {
                for (Object t : suppressed) {
                    this.log.trace("Suppressed " + t.getClass().getSimpleName() + ") while close immediately resource(s) of " + this + ": " + ((Throwable)t).getMessage());
                }
            }
        }
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        IOException e = IoUtils.closeQuietly((Closeable[])new Closeable[]{this.receiver});
        if (e != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleEof({}) failed ({}) to close receiver: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleEof(" + this + ") receiver close failure details", (Throwable)e);
            }
        }
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data length exceeds int boundaries: %d", (long)len);
        if (this.receiver != null) {
            int r = this.receiver.data(this, data, off, (int)len);
            if (r > 0) {
                Window wLocal = this.getLocalWindow();
                wLocal.consumeAndCheck(r);
            }
        } else {
            ValidateUtils.checkTrue((len <= 0x7FFFFFBFL ? 1 : 0) != 0, (String)"Temporary data length exceeds int boundaries: %d", (long)len);
            if (this.tempBuffer == null) {
                this.tempBuffer = new ByteArrayBuffer((int)len + 64, false);
            }
            this.tempBuffer.putRawBytes(data, off, (int)len);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException("Server channel does not support extended data");
    }

    @Override
    protected RequestHandler.Result handleInternalRequest(String requestType, boolean wantReply, Buffer buffer) throws IOException {
        switch (requestType) {
            case "env": {
                return this.handleEnv(buffer, wantReply);
            }
            case "pty-req": {
                return this.handlePtyReq(buffer, wantReply);
            }
            case "window-change": {
                return this.handleWindowChange(buffer, wantReply);
            }
            case "signal": {
                return this.handleSignal(buffer, wantReply);
            }
            case "break": {
                return this.handleBreak(buffer, wantReply);
            }
            case "shell": {
                if (this.type == null) {
                    RequestHandler.Result r = this.handleShell(requestType, buffer, wantReply);
                    if (RequestHandler.Result.ReplySuccess.equals((Object)r) || RequestHandler.Result.Replied.equals((Object)r)) {
                        this.type = requestType;
                    }
                    return r;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, wantReply, requestType, this.type});
                }
                return RequestHandler.Result.ReplyFailure;
            }
            case "exec": {
                if (this.type == null) {
                    RequestHandler.Result r = this.handleExec(requestType, buffer, wantReply);
                    if (RequestHandler.Result.ReplySuccess.equals((Object)r) || RequestHandler.Result.Replied.equals((Object)r)) {
                        this.type = requestType;
                    }
                    return r;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, wantReply, requestType, this.type});
                }
                return RequestHandler.Result.ReplyFailure;
            }
            case "subsystem": {
                if (this.type == null) {
                    RequestHandler.Result r = this.handleSubsystem(requestType, buffer, wantReply);
                    if (RequestHandler.Result.ReplySuccess.equals((Object)r) || RequestHandler.Result.Replied.equals((Object)r)) {
                        this.type = requestType;
                    }
                    return r;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, wantReply, requestType, this.type});
                }
                return RequestHandler.Result.ReplyFailure;
            }
            case "auth-agent-req": 
            case "auth-agent-req@openssh.com": {
                return this.handleAgentForwarding(requestType, buffer, wantReply);
            }
            case "x11-req": {
                return this.handleX11Forwarding(requestType, buffer, wantReply);
            }
        }
        return super.handleInternalRequest(requestType, wantReply, buffer);
    }

    @Override
    protected IoWriteFuture sendResponse(Buffer buffer, String req, RequestHandler.Result result, boolean wantReply) throws IOException {
        IoWriteFuture future = super.sendResponse(buffer, req, result, wantReply);
        if (!RequestHandler.Result.ReplySuccess.equals((Object)result)) {
            return future;
        }
        if (this.commandInstance == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} no pending command", (Object)this, (Object)req);
            }
            return future;
        }
        if (!Objects.equals(this.type, req)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} mismatched channel type: {}", new Object[]{this, req, this.type});
            }
            return future;
        }
        if (this.commandStarted.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} pending command already started", (Object)this, (Object)req);
            }
            return future;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendResponse({}) request={} activate command", (Object)this, (Object)req);
        }
        this.commandInstance.start(this.getEnvironment());
        return future;
    }

    protected RequestHandler.Result handleEnv(Buffer buffer, boolean wantReply) throws IOException {
        String name = buffer.getString();
        String value = buffer.getString();
        this.addEnvVariable(name, value);
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleEnv({}): {} = {}", new Object[]{this, name, value});
        }
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handlePtyReq(Buffer buffer, boolean wantReply) throws IOException {
        String term = buffer.getString();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        byte[] modes = buffer.getBytes();
        StandardEnvironment environment = this.getEnvironment();
        Map<PtyMode, Integer> ptyModes = environment.getPtyModes();
        int i = 0;
        while (i < modes.length && modes[i] != 0) {
            int opcode;
            if ((opcode = modes[i++] & 0xFF) >= 160 && opcode <= 255) {
                this.log.warn("handlePtyReq({}) unknown reserved pty opcode value: {}", (Object)this, (Object)opcode);
                break;
            }
            int val = modes[i++] << 24 & 0xFF000000 | modes[i++] << 16 & 0xFF0000 | modes[i++] << 8 & 0xFF00 | modes[i++] & 0xFF;
            PtyMode mode = PtyMode.fromInt(opcode);
            if (mode == null) {
                this.log.warn("handlePtyReq({}) unsupported pty opcode value: {}={}", new Object[]{this, opcode, val});
                continue;
            }
            ptyModes.put(mode, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("handlePtyReq({}): term={}, size=({} - {}), pixels=({}, {}), modes=[{}]", new Object[]{this, term, tColumns, tRows, tWidth, tHeight, ptyModes});
        }
        this.addEnvVariable("TERM", term);
        this.addEnvVariable("COLUMNS", Integer.toString(tColumns));
        this.addEnvVariable("LINES", Integer.toString(tRows));
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleWindowChange(Buffer buffer, boolean wantReply) throws IOException {
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWindowChange({}): ({} - {}), ({}, {})", new Object[]{this, tColumns, tRows, tWidth, tHeight});
        }
        StandardEnvironment e = this.getEnvironment();
        e.set("COLUMNS", Integer.toString(tColumns));
        e.set("LINES", Integer.toString(tRows));
        e.signal(Signal.WINCH);
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleSignal(Buffer buffer, boolean wantReply) throws IOException {
        Signal signal;
        String name = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSignal({}): {}", (Object)this, (Object)name);
        }
        if ((signal = Signal.get(name)) != null) {
            this.getEnvironment().signal(signal);
        } else {
            this.log.warn("handleSignal({}) unknown signal received: {}", (Object)this, (Object)name);
        }
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleBreak(Buffer buffer, boolean wantReply) throws IOException {
        long breakLength = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleBreak({}) length={}", (Object)this, (Object)breakLength);
        }
        this.getEnvironment().signal(Signal.INT);
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleShell(String request, Buffer buffer, boolean wantReply) throws IOException {
        if (this.isClosing()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - closing", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        ServerFactoryManager manager = Objects.requireNonNull(this.getServerSession(), "No server session").getFactoryManager();
        Factory<Command> factory = Objects.requireNonNull(manager, "No server factory manager").getShellFactory();
        if (factory == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - no shell factory", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        try {
            this.commandInstance = (Command)factory.create();
        }
        catch (Error | RuntimeException e) {
            this.log.warn("handleShell({}) Failed ({}) to create shell: {}", new Object[]{this, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell(" + this + ") shell creation failure details", e);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - no shell command", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        return this.prepareChannelCommand(request, this.commandInstance);
    }

    protected RequestHandler.Result handleExec(String request, Buffer buffer, boolean wantReply) throws IOException {
        if (this.isClosing()) {
            return RequestHandler.Result.ReplyFailure;
        }
        String commandLine = buffer.getString();
        ServerFactoryManager manager = Objects.requireNonNull(this.getServerSession(), "No server session").getFactoryManager();
        CommandFactory factory = Objects.requireNonNull(manager, "No server factory manager").getCommandFactory();
        if (factory == null) {
            this.log.warn("handleExec({}) No command factory for command: {}", (Object)this, (Object)commandLine);
            return RequestHandler.Result.ReplyFailure;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleExec({}) Executing command: {}", (Object)this, (Object)commandLine);
        }
        try {
            this.commandInstance = factory.createCommand(commandLine);
        }
        catch (Error | RuntimeException e) {
            this.log.warn("handleExec({}) Failed ({}) to create command for {}: {}", new Object[]{this, e.getClass().getSimpleName(), commandLine, e.getMessage()});
            if (debugEnabled) {
                this.log.debug("handleExec(" + this + ") command=" + commandLine + " creation failure details", e);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            this.log.warn("handleExec({}) Unsupported command: {}", (Object)this, (Object)commandLine);
            return RequestHandler.Result.ReplyFailure;
        }
        return this.prepareChannelCommand(request, this.commandInstance);
    }

    protected RequestHandler.Result handleSubsystem(String request, Buffer buffer, boolean wantReply) throws IOException {
        ServerFactoryManager manager;
        List<NamedFactory<Command>> factories;
        String subsystem = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSubsystem({})[want-reply={}] subsystem={}", new Object[]{this, wantReply, subsystem});
        }
        if (GenericUtils.isEmpty(factories = Objects.requireNonNull(manager = Objects.requireNonNull(this.getServerSession(), "No server session").getFactoryManager(), "No server factory manager").getSubsystemFactories())) {
            this.log.warn("handleSubsystem({}) No factories for subsystem: {}", (Object)this, (Object)subsystem);
            return RequestHandler.Result.ReplyFailure;
        }
        try {
            this.commandInstance = (Command)NamedFactory.create(factories, (String)subsystem);
        }
        catch (Error | RuntimeException e) {
            this.log.warn("handleSubsystem({}) Failed ({}) to create command for subsystem={}: {}", new Object[]{this, e.getClass().getSimpleName(), subsystem, e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleSubsystem(" + this + ") subsystem=" + subsystem + " creation failure details", e);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            this.log.warn("handleSubsystem({}) Unsupported subsystem: {}", (Object)this, (Object)subsystem);
            return RequestHandler.Result.ReplyFailure;
        }
        return this.prepareChannelCommand(request, this.commandInstance);
    }

    protected RequestHandler.Result prepareChannelCommand(String request, Command cmd) throws IOException {
        Command command = this.prepareCommand(request, cmd);
        if (command == null) {
            this.log.warn("prepareChannelCommand({})[{}] no command prepared", (Object)this, (Object)request);
            return RequestHandler.Result.ReplyFailure;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (command != cmd) {
            if (debugEnabled) {
                this.log.debug("prepareChannelCommand({})[{}] replaced original command", (Object)this, (Object)request);
            }
            this.commandInstance = command;
        }
        if (debugEnabled) {
            this.log.debug("prepareChannelCommand({})[{}] prepared command", (Object)this, (Object)request);
        }
        return RequestHandler.Result.ReplySuccess;
    }

    public void setDataReceiver(ChannelDataReceiver receiver) {
        this.receiver = receiver;
    }

    protected Command prepareCommand(String requestType, Command command) throws IOException {
        if (command == null) {
            return null;
        }
        ServerSession session = this.getSession();
        this.addEnvVariable("USER", session.getUsername());
        if (command instanceof SessionAware) {
            ((SessionAware)((Object)command)).setSession(session);
        }
        if (command instanceof ChannelSessionAware) {
            ((ChannelSessionAware)((Object)command)).setChannelSession(this);
        }
        if (command instanceof FileSystemAware) {
            ServerFactoryManager manager = session.getFactoryManager();
            FileSystemFactory factory = manager.getFileSystemFactory();
            ((FileSystemAware)((Object)command)).setFileSystem(factory.createFileSystem(session));
        }
        if (command instanceof AsyncCommand) {
            this.asyncOut = new ChannelAsyncOutputStream(this, 94);
            this.asyncErr = new ChannelAsyncOutputStream(this, 95);
            ((AsyncCommand)command).setIoOutputStream(this.asyncOut);
            ((AsyncCommand)command).setIoErrorStream(this.asyncErr);
        } else {
            Window wRemote = this.getRemoteWindow();
            this.out = new ChannelOutputStream(this, wRemote, this.log, 94, false);
            this.err = new ChannelOutputStream(this, wRemote, this.log, 95, false);
            if (this.log.isTraceEnabled()) {
                this.out = new LoggingFilterOutputStream(this.out, "OUT(" + this + ")", this.log, (PropertyResolver)this);
                this.err = new LoggingFilterOutputStream(this.err, "ERR(" + this + ")", this.log, (PropertyResolver)this);
            }
            command.setOutputStream(this.out);
            command.setErrorStream(this.err);
        }
        if (this.receiver == null) {
            ChannelDataReceiver recv;
            if (command instanceof AsyncCommand) {
                recv = new AsyncDataReceiver(this);
                this.setDataReceiver(recv);
                ((AsyncCommand)command).setIoInputStream(((AsyncDataReceiver)recv).getIn());
            } else {
                recv = new PipeDataReceiver(this, this.getLocalWindow());
                this.setDataReceiver(recv);
                command.setInputStream(((PipeDataReceiver)recv).getIn());
            }
        }
        if (this.tempBuffer != null) {
            Buffer buffer = this.tempBuffer;
            this.tempBuffer = null;
            this.doWriteData(buffer.array(), buffer.rpos(), buffer.available());
        }
        command.setExitCallback((exitValue, exitMessage) -> {
            try {
                this.closeShell(exitValue);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("onExit({}) code={} message='{}' shell closed", new Object[]{this, exitValue, exitMessage});
                }
            }
            catch (IOException e) {
                this.log.warn("onExit({}) code={} message='{}' {} closing shell: {}", new Object[]{this, exitValue, exitMessage, e.getClass().getSimpleName(), e.getMessage()});
            }
        });
        return command;
    }

    protected int getPtyModeValue(PtyMode mode) {
        Number v = this.getEnvironment().getPtyModes().get((Object)mode);
        return v != null ? v.intValue() : 0;
    }

    protected RequestHandler.Result handleAgentForwarding(String requestType, Buffer buffer, boolean wantReply) throws IOException {
        ServerSession session = this.getServerSession();
        PropertyResolverUtils.updateProperty((PropertyResolver)session, (String)"agent-fw-auth-type", (Object)requestType);
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        AgentForwardingFilter filter = manager.getAgentForwardingFilter();
        SshAgentFactory factory = manager.getAgentFactory();
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            if (factory == null || filter == null || !filter.canForwardAgent(session, requestType)) {
                if (debugEnabled) {
                    this.log.debug("handleAgentForwarding(" + this + ")[haveFactory=" + (factory != null) + ",haveFilter=" + (filter != null) + "] filtered out request=" + requestType);
                }
                return RequestHandler.Result.ReplyFailure;
            }
        }
        catch (Error e) {
            this.log.warn("handleAgentForwarding({}) failed ({}) to consult forwarding filter for '{}': {}", new Object[]{this, e.getClass().getSimpleName(), requestType, e.getMessage()});
            if (debugEnabled) {
                this.log.debug("handleAgentForwarding(" + this + ")[" + requestType + "] filter consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException((Throwable)e);
        }
        AgentForwardSupport agentForward = this.service.getAgentForwardSupport();
        if (agentForward == null) {
            if (debugEnabled) {
                this.log.debug("handleAgentForwarding() no agent forward support", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        String authSocket = agentForward.initialize();
        this.addEnvVariable("SSH_AUTH_SOCK", authSocket);
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleX11Forwarding(String requestType, Buffer buffer, boolean wantReply) throws IOException {
        ServerSession session = this.getServerSession();
        boolean singleConnection = buffer.getBoolean();
        String authProtocol = buffer.getString();
        String authCookie = buffer.getString();
        int screenId = buffer.getInt();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        X11ForwardingFilter filter = manager.getX11ForwardingFilter();
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            if (filter == null || !filter.canForwardX11(session, requestType)) {
                if (debugEnabled) {
                    this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={}, filter={}: filtered request={}", new Object[]{this, singleConnection, authProtocol, authCookie, screenId, filter, requestType});
                }
                return RequestHandler.Result.ReplyFailure;
            }
        }
        catch (Error e) {
            this.log.warn("handleX11Forwarding({}) failed ({}) to consult forwarding filter for '{}': {}", new Object[]{this, e.getClass().getSimpleName(), requestType, e.getMessage()});
            if (debugEnabled) {
                this.log.debug("handleX11Forwarding(" + this + ")[" + requestType + "] filter consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException((Throwable)e);
        }
        X11ForwardSupport x11Forward = this.service.getX11ForwardSupport();
        if (x11Forward == null) {
            if (debugEnabled) {
                this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={} - no forwarder'", new Object[]{this, singleConnection, authProtocol, authCookie, screenId});
            }
            return RequestHandler.Result.ReplyFailure;
        }
        String display = x11Forward.createDisplay(singleConnection, authProtocol, authCookie, screenId);
        if (debugEnabled) {
            this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={} - display='{}'", new Object[]{this, singleConnection, authProtocol, authCookie, screenId, display});
        }
        if (GenericUtils.isEmpty((CharSequence)display)) {
            return RequestHandler.Result.ReplyFailure;
        }
        this.addEnvVariable("DISPLAY", display);
        return RequestHandler.Result.ReplySuccess;
    }

    protected void addEnvVariable(String name, String value) {
        this.getEnvironment().set(name, value);
    }

    public StandardEnvironment getEnvironment() {
        return this.env;
    }

    protected void closeShell(int exitValue) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closeShell({}) exit code={}", (Object)this, (Object)exitValue);
        }
        if (!this.isClosing()) {
            if (this.out != null) {
                this.out.flush();
            }
            this.sendEof();
            this.sendExitStatus(exitValue);
            this.commandExitFuture.setClosed();
            this.close(false);
        } else {
            this.commandExitFuture.setClosed();
        }
    }

    public class CommandCloseable
    extends IoBaseCloseable {
        public boolean isClosed() {
            return ChannelSession.this.commandExitFuture.isClosed();
        }

        public boolean isClosing() {
            return this.isClosed();
        }

        public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            ChannelSession.this.commandExitFuture.addListener(listener);
        }

        public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            ChannelSession.this.commandExitFuture.removeListener(listener);
        }

        public CloseFuture close(boolean immediately) {
            if (immediately || ChannelSession.this.commandInstance == null) {
                ChannelSession.this.commandExitFuture.setClosed();
            } else if (!ChannelSession.this.commandExitFuture.isClosed()) {
                IOException e = IoUtils.closeQuietly((Closeable[])new Closeable[]{ChannelSession.this.receiver});
                if (e != null && this.log.isDebugEnabled()) {
                    this.log.debug("close({})[immediately={}] failed ({}) to close receiver: {}", new Object[]{this, immediately, e.getClass().getSimpleName(), e.getMessage()});
                }
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        ChannelSession.this.commandExitFuture.setClosed();
                    }
                };
                ChannelSession channel = ChannelSession.this;
                long timeout = PropertyResolverUtils.getLongProperty((PropertyResolver)channel, (String)"command-exit-timeout", (long)ServerFactoryManager.DEFAULT_COMMAND_EXIT_TIMEOUT);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Wait {} ms for shell to exit cleanly on {}", (Object)timeout, (Object)channel);
                }
                ServerSession s = channel.getSession();
                FactoryManager manager = Objects.requireNonNull(s.getFactoryManager(), "No factory manager");
                ScheduledExecutorService scheduler = Objects.requireNonNull(manager.getScheduledExecutorService(), "No scheduling service");
                scheduler.schedule(task, timeout, TimeUnit.MILLISECONDS);
                ChannelSession.this.commandExitFuture.addListener(future -> task.cancel());
            }
            return ChannelSession.this.commandExitFuture;
        }
    }
}

