/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class KeySetPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    private final Collection<? extends PublicKey> keySet;

    public KeySetPublickeyAuthenticator(Collection<? extends PublicKey> keySet) {
        this.keySet = keySet == null ? Collections.emptyList() : keySet;
    }

    public final Collection<? extends PublicKey> getKeySet() {
        return this.keySet;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        return this.authenticate(username, key, session, this.getKeySet());
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session, Collection<? extends PublicKey> keys) {
        boolean matchFound;
        if (GenericUtils.isEmpty(keys)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + username + ")[" + session + "] no keys");
            }
            return false;
        }
        PublicKey matchKey = KeyUtils.findMatchingKey((PublicKey)key, keys);
        boolean bl = matchFound = matchKey != null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate(" + username + ")[" + session + "] match found=" + matchFound);
        }
        return matchFound;
    }
}

