/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;

public class StandardEnvironment
extends AbstractLoggingBean
implements Environment {
    private final Map<Signal, Collection<SignalListener>> listeners = new ConcurrentHashMap<Signal, Collection<SignalListener>>(3);
    private final Map<String, String> env = new ConcurrentHashMap<String, String>();
    private final Map<PtyMode, Integer> ptyModes = new ConcurrentHashMap<PtyMode, Integer>();

    @Override
    public void addSignalListener(SignalListener listener, Signal ... signals) {
        this.addSignalListener(listener, Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty((Object[])signals, (String)"No signals", (Object[])new Object[0])));
    }

    @Override
    public void addSignalListener(SignalListener listener) {
        this.addSignalListener(listener, Signal.SIGNALS);
    }

    @Override
    public void addSignalListener(SignalListener listener, Collection<Signal> signals) {
        SignalListener.validateListener(listener);
        ValidateUtils.checkNotNullAndNotEmpty(signals, (String)"No signals", (Object[])new Object[0]);
        for (Signal s : signals) {
            this.getSignalListeners(s, true).add(listener);
        }
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public Map<PtyMode, Integer> getPtyModes() {
        return this.ptyModes;
    }

    @Override
    public void removeSignalListener(SignalListener listener) {
        if (listener == null) {
            return;
        }
        SignalListener.validateListener(listener);
        for (Signal s : Signal.SIGNALS) {
            Collection<SignalListener> ls = this.getSignalListeners(s, false);
            if (ls == null) continue;
            ls.remove(listener);
        }
    }

    public void signal(Signal signal) {
        Collection<SignalListener> ls = this.getSignalListeners(signal, false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("signal({}) - listeners={}", (Object)signal, ls);
        }
        if (GenericUtils.isEmpty(ls)) {
            return;
        }
        for (SignalListener l : ls) {
            try {
                l.signal(signal);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("Signal {} to {}", (Object)signal, (Object)l);
            }
            catch (RuntimeException e) {
                this.log.warn("Failed ({}) to signal {} to listener={}: {}", new Object[]{e.getClass().getSimpleName(), signal, l, e.getMessage()});
            }
        }
    }

    public void set(String key, String value) {
        this.getEnv().put(ValidateUtils.checkNotNullAndNotEmpty((String)key, (String)"Empty environment variable name"), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<SignalListener> getSignalListeners(Signal signal, boolean create) {
        Collection<SignalListener> ls = this.listeners.get((Object)signal);
        if (ls == null && create) {
            Map<Signal, Collection<SignalListener>> map = this.listeners;
            synchronized (map) {
                ls = this.listeners.get((Object)signal);
                if (ls == null) {
                    ls = new CopyOnWriteArraySet<SignalListener>();
                    this.listeners.put(signal, ls);
                }
            }
        }
        return ls;
    }

    public String toString() {
        return "env=" + this.getEnv() + ", modes=" + this.getPtyModes();
    }
}

